/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.workingsets.DefaultWorkingSetImpl;
import org.eclipse.n4js.ui.workingsets.MutableWorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetEditWizard;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerImpl;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerModificationStrategy;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerModificationStrategyProvider;
import org.eclipse.n4js.ui.workingsets.WorkingSetManualAssociationWizard;
import org.eclipse.n4js.ui.workingsets.WorkingSetNewWizard;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ManualAssociationAwareWorkingSetManager
extends WorkingSetManagerImpl
implements MutableWorkingSetManager,
IPropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(ManualAssociationAwareWorkingSetManager.class);
    private static final String ORDERED_ASSOCIATIONS_KEY = ".orderedAssociations";
    private final ProjectAssociation projectAssociations = new ProjectAssociation();
    @Inject
    private Provider<WorkingSetManualAssociationWizard> wizardProvider;
    @Inject
    private WorkingSetManagerModificationStrategyProvider strategyProvider;

    @Override
    public String getLabel() {
        return "Manual Association";
    }

    @Override
    public Optional<Image> getImage() {
        return ImageDescriptorCache.ImageRef.PROJECT_MODE.asImage();
    }

    @Override
    public IStatus saveState(IProgressMonitor monitor) {
        IStatus superSaveResult = super.saveState(monitor);
        if (superSaveResult.isOK()) {
            Preferences node = this.getPreferences();
            try {
                String associationString = this.projectAssociationsToJsonString(this.projectAssociations);
                node.put(ORDERED_ASSOCIATIONS_KEY, associationString);
                node.flush();
            }
            catch (BackingStoreException e) {
                String message = "Error occurred while saving state to preference store.";
                LOGGER.error((Object)"Error occurred while saving state to preference store.", (Throwable)e);
                return this.statusHelper.createError("Error occurred while saving state to preference store.", (Throwable)e);
            }
            this.resetEclipseWorkingSetsBaseOnCurrentState();
            return this.statusHelper.OK();
        }
        return superSaveResult;
    }

    @Override
    public IStatus restoreState(IProgressMonitor monitor) {
        IStatus superRestoreResult = super.restoreState(monitor);
        if (superRestoreResult.isOK()) {
            Preferences node = this.getPreferences();
            String orderedFilters = node.get(ORDERED_ASSOCIATIONS_KEY, "");
            if (!Strings.isNullOrEmpty((String)orderedFilters)) {
                ProjectAssociation association = this.jsonStringToProjectAssociation(orderedFilters);
                if (association == null) {
                    String message = "Error occurred while deserializing project associations: \"" + orderedFilters + "\"";
                    LOGGER.error((Object)message);
                    return this.statusHelper.createError(message);
                }
                this.projectAssociations.clear();
                this.projectAssociations.putAll(association);
            }
            this.discardWorkingSetCaches();
            return this.statusHelper.OK();
        }
        return superRestoreResult;
    }

    private String projectAssociationsToJsonString(ProjectAssociation assocs) {
        JSONObject jsonObj = JSONModelUtils.createObject((Map)assocs, Function.identity(), coll -> JSONModelUtils.createStringArray((Iterable)coll));
        return JSONModelUtils.serializeJSON((JSONValue)jsonObj);
    }

    private ProjectAssociation jsonStringToProjectAssociation(String jsonStr) {
        JSONDocument doc = JSONModelUtils.parseJSON((String)jsonStr);
        JSONObject obj = (JSONObject)JSONModelUtils.getContent((JSONDocument)doc, JSONObject.class);
        if (doc == null) {
            return null;
        }
        ProjectAssociation result = new ProjectAssociation();
        for (NameValuePair nvp : obj.getNameValuePairs()) {
            result.put(nvp.getName(), JSONModelUtils.asStringsInArrayOrEmpty((JSONValue)nvp.getValue()));
        }
        return result;
    }

    @Override
    public void updateState(Diff<WorkingSet> diff) {
        super.updateState(diff);
        if (!diff.isEmpty()) {
            this.projectAssociations.clear();
            WorkingSet[] workingSetArray = (WorkingSet[])diff.getNewAllItems();
            int n = workingSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorkingSet workingSet = workingSetArray[n2];
                ManualAssociationWorkingSet associationWorkingSet = (ManualAssociationWorkingSet)workingSet;
                Collection<String> projectNames = associationWorkingSet.getAssociatedProjectNames();
                String id = associationWorkingSet.getId();
                if ("Other Projects".equals(id)) {
                    this.projectAssociations.put(id, Collections.emptyList());
                } else {
                    this.projectAssociations.put(id, projectNames);
                }
                ++n2;
            }
            this.discardWorkingSetCaches();
            this.getWorkingSetManagerBroker().fireWorkingSetManagerUpdated(this.getId(), diff);
        }
    }

    @Override
    protected List<WorkingSet> initializeWorkingSets() {
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)this);
        Preconditions.checkState((this.projectAssociations.keySet().size() == this.orderedWorkingSetIds.size() ? 1 : 0) != 0, (Object)("Expected same number of working set names as project associations.\nNames were: " + Iterables.toString((Iterable)this.orderedWorkingSetIds) + "\nAssociations were: " + this.projectAssociations));
        if (this.projectAssociations.isEmpty()) {
            this.projectAssociations.put("Other Projects", Collections.emptyList());
            this.orderedWorkingSetIds.add("Other Projects");
        }
        int size = this.projectAssociations.keySet().size();
        WorkingSet[] workingSets = new WorkingSet[size];
        int i = 0;
        while (i < size) {
            String name = (String)this.orderedWorkingSetIds.get(i);
            Collection projectNames = (Collection)this.projectAssociations.get(name);
            workingSets[i] = new ManualAssociationWorkingSet(projectNames, name, this);
            ++i;
        }
        return Arrays.asList(workingSets);
    }

    @Override
    public WorkingSetNewWizard createNewWizard() {
        return (WorkingSetNewWizard)((Object)this.wizardProvider.get());
    }

    @Override
    public WorkingSetEditWizard createEditWizard() {
        return (WorkingSetEditWizard)((Object)this.wizardProvider.get());
    }

    @Override
    protected void discardWorkingSetState() {
        super.discardWorkingSetState();
        this.projectAssociations.clear();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.strategyProvider.getStrategy(event).execute(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.deleteEclipseResourcesWorkingSets();
    }

    private void resetEclipseWorkingSetsBaseOnCurrentState() {
        try {
            if (PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().getWorkingSetManager() == null) {
                return;
            }
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)this);
            this.deleteEclipseResourcesWorkingSets();
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            WorkingSet[] workingSetArray = this.getAllWorkingSets();
            int n = workingSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorkingSet workingSet = workingSetArray[n2];
                if (!"Other Projects".equals(workingSet.getId())) {
                    org.eclipse.ui.internal.WorkingSet eclipseWorkingSet = this.createEclipseWorkingSet(workingSet);
                    eclipseWorkingSet.setId("org.eclipse.ui.resourceWorkingSetPage");
                    manager.addWorkingSet((IWorkingSet)eclipseWorkingSet);
                }
                ++n2;
            }
        }
        finally {
            IWorkingSetManager wsm;
            IWorkbench wb = PlatformUI.getWorkbench();
            if (wb != null && (wsm = wb.getWorkingSetManager()) != null) {
                wsm.addPropertyChangeListener((IPropertyChangeListener)this);
            }
        }
    }

    private org.eclipse.ui.internal.WorkingSet createEclipseWorkingSet(WorkingSet workingSet) {
        String name = workingSet.getName();
        return new org.eclipse.ui.internal.WorkingSet(name, name, workingSet.getElements());
    }

    private void deleteEclipseResourcesWorkingSets() {
        Iterator<IWorkingSet> itr = this.getAllEclipseResourceWorkingSetsIterator();
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        while (itr.hasNext()) {
            IWorkingSet next = itr.next();
            manager.removeWorkingSet(next);
        }
    }

    private Iterator<IWorkingSet> getAllEclipseResourceWorkingSetsIterator() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        List<IWorkingSet> allWorkingSets = Arrays.asList(manager.getAllWorkingSets());
        return FluentIterable.from(allWorkingSets).filter(WorkingSetManagerModificationStrategy.RESOURCE_WORKING_SETS).iterator();
    }

    public static final class ManualAssociationWorkingSet
    extends DefaultWorkingSetImpl {
        private final Collection<String> projectNames;

        public ManualAssociationWorkingSet(Iterable<String> projectNames, String name, WorkingSetManager manager) {
            super(name, manager);
            this.projectNames = Sets.newHashSet(projectNames);
        }

        public boolean apply(IProject project) {
            return this.projectNames.contains(project.getName());
        }

        public Collection<IProject> getAssociatedProjects() {
            return FluentIterable.from(Arrays.asList(this.getAllProjects())).filter(p -> this.projectNames.contains(p.getName())).toSet();
        }

        public Collection<String> getAssociatedProjectNames() {
            return FluentIterable.from(Arrays.asList(this.getAllProjects())).filter(p -> this.projectNames.contains(p.getName())).transform(p -> p.getName()).toSet();
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " " + Iterables.toString(this.projectNames);
        }
    }

    public static final class ProjectAssociation
    extends LinkedHashMap<String, Collection<String>> {
        public ProjectAssociation() {
            super(16, 0.75f);
        }
    }
}

