/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator.headless;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.n4js.binaries.BinariesCommandFactory;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.utils.process.ProcessResult;

public class N4jscJarUtils {
    private static final Logger LOGGER = Logger.getLogger(N4jscJarUtils.class);
    public static final String PROVIDED_N4JSC_JAR_ENV = "PROVIDED_N4JSC_JAR";
    public static final String DEFAULT_N4JSC_JAR = "target/n4jsc.jar";
    private static final long PROCESS_TIMEOUT_IN_MINUTES = 60L;

    public static File getAbsoluteRunnableN4jsc() {
        File jar;
        String providedJar = System.getenv(PROVIDED_N4JSC_JAR_ENV);
        if (providedJar == null || "".equals(providedJar.trim()) || "null".equals(providedJar)) {
            LOGGER.info((Object)"Environment variable \"PROVIDED_N4JSC_JAR\" is unset; using default \"target/n4jsc.jar\"");
            jar = new File(DEFAULT_N4JSC_JAR).getAbsoluteFile();
        } else {
            LOGGER.info((Object)("Environment variable \"PROVIDED_N4JSC_JAR\" is set to: " + providedJar));
            jar = new File(providedJar).getAbsoluteFile();
        }
        LOGGER.info((Object)("Using n4jsc.jar at: " + jar.getAbsolutePath()));
        Preconditions.checkState((boolean)jar.exists(), (Object)("n4jsc.jar does not exist at location: " + jar));
        return jar;
    }

    public static void buildHeadlessWithN4jscJar(File workspaceRoot) {
        List<String> javaOpts = Arrays.asList("-Xmx2000m");
        List<String> n4jscOpts = Collections.emptyList();
        N4jscJarUtils.buildHeadlessWithN4jscJar(Collections.singletonList(workspaceRoot), javaOpts, n4jscOpts);
    }

    public static void buildHeadlessWithN4jscJar(File workspaceRoot, List<String> javaOpts, List<String> n4jscOpts) {
        N4jscJarUtils.buildHeadlessWithN4jscJar(Collections.singletonList(workspaceRoot), javaOpts, n4jscOpts);
    }

    public static void buildHeadlessWithN4jscJar(Collection<? extends File> workspaceRoots, List<String> javaOpts, List<String> n4jscOpts) {
        String msg;
        Objects.requireNonNull(workspaceRoots);
        Objects.requireNonNull(javaOpts);
        Objects.requireNonNull(n4jscOpts);
        if (workspaceRoots.isEmpty()) {
            throw new IllegalArgumentException("at least one workspace root must be given");
        }
        List workspaceRootsAbsolute = workspaceRoots.stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList());
        ArrayList<String> cmdline = new ArrayList<String>();
        cmdline.add("java");
        cmdline.addAll(javaOpts);
        cmdline.addAll(Arrays.asList("-jar", N4jscJarUtils.getAbsoluteRunnableN4jsc().getAbsolutePath(), "--buildType", "allprojects"));
        cmdline.addAll(n4jscOpts);
        cmdline.add("--projectlocations");
        cmdline.addAll(workspaceRootsAbsolute);
        ProcessBuilder pb = new ProcessBuilder(cmdline);
        pb.directory(null);
        pb.inheritIO();
        LOGGER.info((Object)("current directory is: " + new File("").getAbsolutePath()));
        LOGGER.info((Object)("spawning process with command: " + Joiner.on((String)" ").join(cmdline)));
        boolean timeout = false;
        int exitCode = 0;
        boolean gotExitCode = false;
        Exception ex = null;
        System.out.println("--- start of output of external process");
        try {
            Process ps = pb.start();
            boolean bl = timeout = !ps.waitFor(60L, TimeUnit.MINUTES);
            if (!timeout) {
                exitCode = ps.exitValue();
                gotExitCode = true;
            }
        }
        catch (Exception e) {
            ex = e;
        }
        System.out.println("--- end of output of external process");
        LOGGER.info((Object)("external process done (exit code: " + (gotExitCode ? Integer.valueOf(exitCode) : "<none>") + ")"));
        if (ex != null) {
            msg = "exception while running external process";
            LOGGER.error((Object)"exception while running external process", (Throwable)ex);
            ex.printStackTrace();
            throw new IllegalStateException("exception while running external process", ex);
        }
        if (timeout) {
            msg = "external process timed out (after 60 minutes)";
            LOGGER.error((Object)"external process timed out (after 60 minutes)");
            throw new IllegalStateException("external process timed out (after 60 minutes)");
        }
        if (exitCode != 0) {
            msg = "external process returned non-zero exit code: " + exitCode;
            LOGGER.error((Object)msg);
            throw new IllegalStateException(msg);
        }
    }

    public static void buildHeadlessWithN4jscli(BinariesCommandFactory commandFactory, NodeJsBinary nodeJsBinary, File workspaceRoot, List<String> javaOpts, List<String> n4jscOpts) {
        String msg;
        Objects.requireNonNull(workspaceRoot);
        Objects.requireNonNull(javaOpts);
        Objects.requireNonNull(n4jscOpts);
        File parentFolder = workspaceRoot.getParentFile();
        ProcessResult result = commandFactory.createInstallPackageCommand(parentFolder, "n4js-cli@test", false).execute();
        if (result.getExitCode() != 0) {
            String msg2 = "Cannot install n4js-cli@test";
            LOGGER.error((Object)"Cannot install n4js-cli@test");
            throw new IllegalStateException("Cannot install n4js-cli@test");
        }
        ArrayList<String> cmdline = new ArrayList<String>();
        cmdline.add(nodeJsBinary.getBinaryAbsolutePath());
        Path n4jscliAbsolutePath = FileSystems.getDefault().getPath(String.valueOf(parentFolder.getPath()) + File.separatorChar + "node_modules/n4js-cli/bin/n4jsc.js", new String[0]).normalize().toAbsolutePath();
        cmdline.add(n4jscliAbsolutePath.toString());
        cmdline.addAll(javaOpts);
        cmdline.addAll(Arrays.asList("--buildType", "allprojects"));
        cmdline.addAll(n4jscOpts);
        cmdline.add("--projectlocations");
        cmdline.add(workspaceRoot.getAbsolutePath());
        ProcessBuilder pb = new ProcessBuilder(cmdline);
        pb.directory(null);
        pb.inheritIO();
        LOGGER.info((Object)("current directory is: " + new File("").getAbsolutePath()));
        LOGGER.info((Object)("spawning process with command: " + Joiner.on((String)" ").join(cmdline)));
        boolean timeout = false;
        int exitCode = 0;
        boolean gotExitCode = false;
        Exception ex = null;
        System.out.println("--- start of output of external process");
        try {
            Process ps = pb.start();
            boolean bl = timeout = !ps.waitFor(60L, TimeUnit.MINUTES);
            if (!timeout) {
                exitCode = ps.exitValue();
                gotExitCode = true;
            }
        }
        catch (Exception e) {
            ex = e;
        }
        System.out.println("--- end of output of external process");
        LOGGER.info((Object)("external process done (exit code: " + (gotExitCode ? Integer.valueOf(exitCode) : "<none>") + ")"));
        if (ex != null) {
            msg = "exception while running external process";
            LOGGER.error((Object)"exception while running external process", (Throwable)ex);
            ex.printStackTrace();
            throw new IllegalStateException("exception while running external process", ex);
        }
        if (timeout) {
            msg = "external process timed out (after 60 minutes)";
            LOGGER.error((Object)"external process timed out (after 60 minutes)");
            throw new IllegalStateException("external process timed out (after 60 minutes)");
        }
        if (exitCode != 0) {
            msg = "external process returned non-zero exit code: " + exitCode;
            LOGGER.error((Object)msg);
            throw new IllegalStateException(msg);
        }
    }
}

