/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.components;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.n4js.ui.dialog.SingleClassSelectionDialog;
import org.eclipse.n4js.ui.wizard.classes.N4JSClassWizardModel;
import org.eclipse.n4js.ui.wizard.components.WizardComponent;
import org.eclipse.n4js.ui.wizard.components.WizardComponentContainer;
import org.eclipse.n4js.ui.wizard.components.WizardComponentDataConverters;
import org.eclipse.n4js.ui.wizard.components.WizardComponentUtils;
import org.eclipse.n4js.ui.wizard.model.ClassifierReference;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xtext.resource.IEObjectDescription;

public class SuperClassComponentProvider {
    @Inject
    private Provider<SingleClassSelectionDialog> singleClassSelectionDialogProvider;

    public SuperClassComponent create(N4JSClassWizardModel model, WizardComponentContainer container) {
        return new SuperClassComponent(model, container);
    }

    public class SuperClassComponent
    extends WizardComponent {
        private final Text text;
        private final Button browseButton;
        private final N4JSClassWizardModel model;

        public SuperClassComponent(N4JSClassWizardModel model, WizardComponentContainer container) {
            super(container);
            this.model = model;
            Label superClassLabel = new Label(container.getComposite(), 0);
            superClassLabel.setText("Super class:");
            this.text = new Text(container.getComposite(), 2048);
            this.text.setLayoutData((Object)WizardComponentUtils.fillTextDefaults());
            this.browseButton = new Button(container.getComposite(), 0);
            this.browseButton.setToolTipText("Opens a dialog to choose the super class");
            this.browseButton.setText("Browse...");
            this.setupBindings();
            this.setupDialog();
        }

        private void setupBindings() {
            IObservableValue superClassValue = BeanProperties.value(N4JSClassWizardModel.class, (String)"superClass").observe((Object)this.model);
            ISWTObservableValue superClassUI = WidgetProperties.text((int)24).observe((Widget)this.text);
            this.getDataBindingContext().bindValue((IObservableValue)superClassUI, superClassValue, new WizardComponentDataConverters.StringToClassifierReferenceConverter().updatingValueStrategy(), new WizardComponentDataConverters.ClassifierReferenceToStringConverter().updatingValueStrategy());
        }

        private void setupDialog() {
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SingleClassSelectionDialog dialog = (SingleClassSelectionDialog)((Object)((SuperClassComponent)SuperClassComponent.this).SuperClassComponentProvider.this.singleClassSelectionDialogProvider.get());
                    dialog.setInitialPattern(SuperClassComponent.this.model.getSuperClass().getFullSpecifier());
                    dialog.open();
                    if (dialog.getReturnCode() == 1) {
                        return;
                    }
                    Object result = dialog.getFirstResult();
                    if (result instanceof IEObjectDescription) {
                        IEObjectDescription objectDescription = (IEObjectDescription)result;
                        URI objectUri = ((IEObjectDescription)result).getEObjectURI();
                        SuperClassComponent.this.model.setSuperClass(new ClassifierReference(objectDescription.getQualifiedName(), objectUri));
                    }
                }
            });
        }

        @Override
        public void setFocus() {
            this.text.setFocus();
        }
    }
}

