/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.scoping.utils.AbstractDescriptionWithError;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.resource.IEObjectDescription;

public class WrongWriteAccessDescription
extends AbstractDescriptionWithError {
    private final boolean accessForWriteOperation;
    private final boolean isAssignmentToFinalFieldInCtor;

    public WrongWriteAccessDescription(IEObjectDescription delegate, boolean accessForWriteOperation, boolean isAssignmentToFinalFieldInCtor) {
        super(delegate);
        this.accessForWriteOperation = accessForWriteOperation;
        this.isAssignmentToFinalFieldInCtor = isAssignmentToFinalFieldInCtor;
    }

    public String getMessage() {
        if (this.isAssignmentToFinalFieldInCtor) {
            return IssueCodes.getMessageForCLF_FIELD_FINAL_REINIT_IN_CTOR(this.getName());
        }
        return IssueCodes.getMessageForVIS_WRONG_READ_WRITE_ACCESS(this.getKeyword(), this.getName(), this.accessForWriteOperation ? "read-only" : "write-only");
    }

    public String getIssueCode() {
        if (this.isAssignmentToFinalFieldInCtor) {
            return "CLF_FIELD_FINAL_REINIT_IN_CTOR";
        }
        return "VIS_WRONG_READ_WRITE_ACCESS";
    }

    private String getKeyword() {
        EObject obj = this.delegate().getEObjectOrProxy();
        if (obj instanceof TField) {
            if (((TField)obj).isConst()) {
                return "const field";
            }
            if (((TField)obj).isFinal()) {
                return "final field";
            }
            return "field";
        }
        if (obj instanceof FieldAccessor) {
            return "accessor";
        }
        if (obj instanceof TMethod) {
            return "method";
        }
        return "member";
    }
}

