/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AssignmentOperator;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionAnnotationList;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.GetterDeclaration;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.TypedElement;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.extensions.ExpressionExtensions;
import org.eclipse.n4js.scoping.N4JSScopeProvider;
import org.eclipse.n4js.scoping.members.TypingStrategyFilter;
import org.eclipse.n4js.scoping.utils.AbstractDescriptionWithError;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.AnyType;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.VoidType;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.Result;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class N4JSTypeValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private N4JSScopeProvider n4jsScopeProvider;
    @Inject
    protected ContainerTypesHelper containerTypesHelper;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkGenericDeclarationType(GenericDeclaration declaration) {
        TObjectPrototype functionType = RuleEnvironmentExtensions.functionType(RuleEnvironmentExtensions.newRuleEnvironment((EObject)declaration));
        Consumer<TypeVariable> _function = typeVar -> {
            Type declType;
            TypeRef ub = typeVar.getDeclaredUpperBound();
            if (ub != null && (declType = ub.getDeclaredType()) instanceof ContainerType && declType.isFinal()) {
                if (declType == functionType) {
                    return;
                }
                String message = IssueCodes.getMessageForCLF_UPPER_BOUND_FINAL(declType.getName(), typeVar.getName());
                this.addIssue(message, (EObject)ub, (EStructuralFeature)TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE, "CLF_UPPER_BOUND_FINAL", new String[0]);
            }
        };
        IterableExtensions.filterNull((Iterable)declaration.getTypeVars()).forEach(_function);
    }

    @Check
    public void checkTModuleCreated(Script script) {
        ICompositeNode rootNode;
        boolean _tripleEquals;
        TModule _module = script.getModule();
        boolean bl = _tripleEquals = _module == null;
        if (_tripleEquals && (rootNode = NodeModelUtils.getNode((EObject)script)) != null) {
            this.addIssue(IssueCodes.getMessageForTYS_MISSING(), (EObject)script, rootNode.getOffset(), rootNode.getLength(), "TYS_MISSING");
        }
    }

    @Check
    public void checkParameterizedTypeRef(ParameterizedTypeRef paramTypeRef) {
        Type declaredType = paramTypeRef.getDeclaredType();
        if (declaredType == null || declaredType.eIsProxy()) {
            return;
        }
        if (declaredType instanceof TFunction) {
            boolean _not;
            EObject _eContainer = paramTypeRef.eContainer();
            boolean bl = _not = !(_eContainer instanceof TypeTypeRef);
            if (_not) {
                this.addIssue(IssueCodes.getMessageForTYS_FUNCTION_DISALLOWED_AS_TYPE(), (EObject)paramTypeRef, "TYS_FUNCTION_DISALLOWED_AS_TYPE");
                return;
            }
        }
        boolean isInTypeTypeRef = paramTypeRef.eContainer() instanceof TypeTypeRef || paramTypeRef.eContainer() instanceof Wildcard && paramTypeRef.eContainer().eContainer() instanceof TypeTypeRef;
        this.internalCheckValidLocationForVoid(paramTypeRef);
        if (isInTypeTypeRef) {
            this.internalCheckValidTypeInTypeTypeRef(paramTypeRef);
        } else {
            this.internalCheckTypeArguments((List<? extends TypeVariable>)declaredType.getTypeVars(), (List<? extends TypeArgument>)paramTypeRef.getTypeArgs(), false, (IdentifiableElement)declaredType, (EObject)paramTypeRef, (EStructuralFeature)TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_DeclaredType());
        }
        this.internalCheckDynamic(paramTypeRef);
        this.internalCheckStructuralPrimitiveTypeRef(paramTypeRef);
    }

    private void internalCheckStructuralPrimitiveTypeRef(ParameterizedTypeRef typeRef) {
        if (typeRef.getDeclaredType() instanceof PrimitiveType && !Objects.equal((Object)typeRef.getTypingStrategy(), (Object)TypingStrategy.NOMINAL)) {
            this.addIssue(IssueCodes.getMessageForTYS_STRUCTURAL_PRIMITIVE(), (EObject)typeRef, "TYS_STRUCTURAL_PRIMITIVE");
        }
    }

    private void internalCheckValidLocationForVoid(ParameterizedTypeRef typeRef) {
        Type _declaredType = typeRef.getDeclaredType();
        if (_declaredType instanceof VoidType) {
            boolean isValidLocationForVoid;
            boolean bl = isValidLocationForVoid = typeRef.eContainer() instanceof FunctionDefinition && typeRef.eContainmentFeature() == N4JSPackage.eINSTANCE.getFunctionDefinition_ReturnTypeRef() || typeRef.eContainer() instanceof FunctionTypeExpression && typeRef.eContainmentFeature() == TypeRefsPackage.eINSTANCE.getFunctionTypeExpression_ReturnTypeRef() || typeRef.eContainer() instanceof TFunction && typeRef.eContainmentFeature() == TypesPackage.eINSTANCE.getTFunction_ReturnTypeRef() || typeRef.eContainer() instanceof GetterDeclaration && typeRef.eContainmentFeature() == N4JSPackage.eINSTANCE.getTypedElement_DeclaredTypeRef();
            if (!isValidLocationForVoid) {
                this.addIssue(IssueCodes.getMessageForTYS_VOID_AT_WRONG_LOCATION(), (EObject)typeRef, "TYS_VOID_AT_WRONG_LOCATION");
            }
        }
    }

    private void internalCheckValidTypeInTypeTypeRef(ParameterizedTypeRef paramTypeRef) {
        boolean _not;
        boolean _isEmpty = paramTypeRef.getTypeArgs().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.addIssue(IssueCodes.getMessageForAST_NO_TYPE_ARGS_IN_CLASSIFIERTYPEREF(), (EObject)paramTypeRef, "AST_NO_TYPE_ARGS_IN_CLASSIFIERTYPEREF");
        } else if (paramTypeRef instanceof FunctionTypeRef) {
            this.addIssue(IssueCodes.getMessageForAST_NO_FUNCTIONTYPEREFS_IN_CLASSIFIERTYPEREF(), (EObject)paramTypeRef, "AST_NO_FUNCTIONTYPEREFS_IN_CLASSIFIERTYPEREF");
        } else {
            Type _declaredType = paramTypeRef.getDeclaredType();
            if (_declaredType instanceof TFunction) {
                this.addIssue(IssueCodes.getMessageForAST_NO_FUNCTIONTYPEREFS_IN_CLASSIFIERTYPEREF(), (EObject)paramTypeRef, "AST_NO_FUNCTIONTYPEREFS_IN_CLASSIFIERTYPEREF");
            }
        }
    }

    @Check
    public void checkThisTypeRef(ThisTypeRef thisTypeRef) {
        boolean _not;
        if (thisTypeRef instanceof BoundThisTypeRef) {
            return;
        }
        boolean bl = _not = !this.isUsedStructurallyAsFormalParametersInTheConstructor(thisTypeRef) && !this.isUsedAtCovariantPositionInClassifierDeclaration(thisTypeRef) && !this.isUsedInVariableWithSyntaxError(thisTypeRef);
        if (_not) {
            this.addIssue(IssueCodes.getMessageForAST_THIS_WRONG_PLACE(), (EObject)thisTypeRef, "AST_THIS_WRONG_PLACE");
        }
    }

    private boolean isUsedStructurallyAsFormalParametersInTheConstructor(ThisTypeRef thisTypeRef) {
        boolean _isUseSiteStructuralTyping = thisTypeRef.isUseSiteStructuralTyping();
        if (_isUseSiteStructuralTyping) {
            EObject methodOrConstructor;
            EObject _eContainer = null;
            if (thisTypeRef != null) {
                _eContainer = thisTypeRef.eContainer();
            }
            EObject _eContainer_1 = null;
            if (_eContainer != null) {
                _eContainer_1 = _eContainer.eContainer();
            }
            if ((methodOrConstructor = _eContainer_1) instanceof N4MethodDeclaration && methodOrConstructor != null && ((N4MethodDeclaration)methodOrConstructor).isConstructor()) {
                return true;
            }
        }
        return false;
    }

    private boolean isUsedAtCovariantPositionInClassifierDeclaration(ThisTypeRef thisTypeRef) {
        N4ClassifierDeclaration classifierDecl = (N4ClassifierDeclaration)EcoreUtil2.getContainerOfType((EObject)thisTypeRef, N4ClassifierDeclaration.class);
        if (classifierDecl != null) {
            N4MemberDeclaration memberDecl;
            if (classifierDecl instanceof N4InterfaceDeclaration && (memberDecl = (N4MemberDeclaration)EcoreUtil2.getContainerOfType((EObject)thisTypeRef, N4MemberDeclaration.class)) != null && memberDecl.isStatic()) {
                return false;
            }
            Variance varianceOfPos = N4JSLanguageUtils.getVarianceOfPosition((TypeRef)thisTypeRef);
            if (varianceOfPos != null) {
                return varianceOfPos == Variance.CO;
            }
        }
        return false;
    }

    private boolean isUsedInVariableWithSyntaxError(ThisTypeRef ref) {
        EObject container = ref.eContainer();
        if (container instanceof VariableDeclaration) {
            String _name = ((VariableDeclaration)container).getName();
            return _name == null;
        }
        return false;
    }

    @Check
    public void checkSymbolReference(TypeRef typeRef) {
        EObject parent;
        TObjectPrototype _symbolObjectType;
        boolean _tripleEquals;
        Resource _eResource = null;
        if (typeRef != null) {
            _eResource = typeRef.eResource();
        }
        BuiltInTypeScope bits = BuiltInTypeScope.get((ResourceSet)_eResource.getResourceSet());
        Type _declaredType = typeRef.getDeclaredType();
        boolean bl = _tripleEquals = _declaredType == (_symbolObjectType = bits.getSymbolObjectType());
        if (_tripleEquals && (!((parent = typeRef.eContainer()) instanceof ParameterizedPropertyAccessExpression) || ((ParameterizedPropertyAccessExpression)parent).getTarget() != typeRef)) {
            this.addIssue(IssueCodes.getMessageForBIT_SYMBOL_INVALID_USE(), (EObject)typeRef, "BIT_SYMBOL_INVALID_USE");
        }
    }

    public void internalCheckDynamic(ParameterizedTypeRef ref) {
        Type t;
        boolean _isDynamic = ref.isDynamic();
        if (_isDynamic && (t = ref.getDeclaredType()) instanceof PrimitiveType && !(t instanceof AnyType)) {
            this.addIssue(IssueCodes.getMessageForTYS_PRIMITIVE_TYPE_DYNAMIC(t.getName()), (EObject)ref, "TYS_PRIMITIVE_TYPE_DYNAMIC");
        }
    }

    @Check
    public void checkTypeHiddenByTypeVariable(GenericDeclaration genDecl) {
        boolean _not;
        boolean _isEmpty = genDecl.getTypeVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean staticAccess = genDecl instanceof N4MemberDeclaration && ((N4MemberDeclaration)genDecl).isStatic();
            IScope scope = this.n4jsScopeProvider.getTypeScope(genDecl.eContainer(), staticAccess);
            Consumer<TypeVariable> _function = it -> {
                boolean _not_1;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getName());
                boolean bl = _not_1 = !_isNullOrEmpty;
                if (_not_1) {
                    EObject hiddenType;
                    IEObjectDescription hiddenTypeDscr = scope.getSingleElement(QualifiedName.create((String)it.getName()));
                    EObject _eObjectOrProxy = null;
                    if (hiddenTypeDscr != null) {
                        _eObjectOrProxy = hiddenTypeDscr.getEObjectOrProxy();
                    }
                    if ((hiddenType = _eObjectOrProxy) instanceof Type && !AbstractDescriptionWithError.isErrorDescription_XTEND_MVN_BUG_HACK(hiddenTypeDscr)) {
                        String message = IssueCodes.getMessageForVIS_TYPE_PARAMETER_HIDES_TYPE(it.getName(), this.keywordProvider.keyword(hiddenType));
                        this.addIssue(message, (EObject)it, "VIS_TYPE_PARAMETER_HIDES_TYPE");
                    }
                }
            };
            genDecl.getTypeVars().forEach(_function);
        }
    }

    @Check
    public void checkCompoundAssignmentGetterSetterClashOnLhs(AssignmentExpression assExpr) {
        IdentifiableElement prop;
        if (assExpr.getOp() == null || assExpr.getOp() == AssignmentOperator.ASSIGN) {
            return;
        }
        Expression lhs = assExpr.getLhs();
        if (lhs instanceof ParameterizedPropertyAccessExpression && (prop = ((ParameterizedPropertyAccessExpression)lhs).getProperty()) instanceof TSetter) {
            Type targetType;
            TSetter setter = (TSetter)prop;
            TypeRef _tau = this.ts.tau((TypableElement)((ParameterizedPropertyAccessExpression)lhs).getTarget());
            Type _declaredType = null;
            if (_tau != null) {
                _declaredType = _tau.getDeclaredType();
            }
            if ((targetType = _declaredType) instanceof ContainerType) {
                TMember m = this.containerTypesHelper.fromContext((EObject)assExpr).findMember((ContainerType)targetType, setter.getName(), false, setter.isStatic());
                if (m == null) {
                    String message = IssueCodes.getMessageForTYS_COMPOUND_MISSING_GETTER();
                    this.addIssue(message, (EObject)assExpr.getLhs(), "TYS_COMPOUND_MISSING_GETTER");
                } else if (m instanceof TGetter) {
                    TypeRef typeOfGetter;
                    TGetter getter = (TGetter)m;
                    RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)assExpr);
                    TypeRef expectedType = this.ts.expectedType(G, (EObject)assExpr, assExpr.getRhs());
                    TypeRef typeOfGetterRAW = TypeUtils.getMemberTypeRef((TMember)getter);
                    if (expectedType != null && typeOfGetterRAW != null && (typeOfGetter = this.ts.substTypeVariables(G, typeOfGetterRAW)) != null) {
                        Result result = this.ts.subtype(G, (TypeArgument)typeOfGetter, (TypeArgument)expectedType);
                        this.createTypeError(result, (EObject)assExpr.getLhs());
                    }
                }
            }
        }
    }

    @Check
    public void checkInconsistentInterfaceImplementationOrExtension(N4ClassifierDeclaration classifierDecl) {
        Type _definedType = classifierDecl.getDefinedType();
        TClassifier tClassifier = (TClassifier)_definedType;
        if (tClassifier == null) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)classifierDecl);
        RuleEnvironmentExtensions.recordInconsistentSubstitutions(G);
        Consumer<ParameterizedTypeRef> _function = it -> this.tsh.addSubstitutions(G, (TypeRef)it);
        tClassifier.getSuperClassifierRefs().forEach(_function);
        Set<TypeVariable> _typeMappingKeys = RuleEnvironmentExtensions.getTypeMappingKeys(G);
        for (TypeVariable tv : _typeMappingKeys) {
            boolean _not_1;
            boolean _not;
            TypeRef subst;
            if (tv.isDeclaredCovariant() || tv.isDeclaredContravariant() || !((subst = this.ts.substTypeVariables(G, (TypeRef)TypeUtils.createTypeRef((Type)tv, (TypeArgument[])new TypeArgument[0]))) instanceof UnknownTypeRef)) continue;
            List<TypeRef> badSubst = RuleEnvironmentExtensions.getInconsistentSubstitutions(G, tv);
            boolean _isEmpty = badSubst.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            boolean _allEqualType = this.tsh.allEqualType(G, (TypeRef[])Conversions.unwrapArray(badSubst, TypeRef.class));
            boolean bl2 = _not_1 = !_allEqualType;
            if (!_not_1) continue;
            String _xifexpression = null;
            _xifexpression = tClassifier instanceof TClass ? "implement" : "extend";
            String mode = _xifexpression;
            EObject _eContainer = tv.eContainer();
            String ifcName = ((TInterface)_eContainer).getName();
            String _name = tv.getName();
            String tvName = "invariant " + _name;
            Functions.Function1 _function_1 = it -> it.getTypeRefAsString();
            String typeRefsStr = IterableExtensions.join((Iterable)ListExtensions.map(badSubst, (Functions.Function1)_function_1), (CharSequence)", ");
            String message = IssueCodes.getMessageForCLF_IMPLEMENT_EXTEND_SAME_INTERFACE_INCONSISTENTLY(mode, ifcName, tvName, typeRefsStr);
            this.addIssue(message, (EObject)classifierDecl, (EStructuralFeature)N4JSPackage.eINSTANCE.getN4TypeDeclaration_Name(), "CLF_IMPLEMENT_EXTEND_SAME_INTERFACE_INCONSISTENTLY", new String[0]);
        }
    }

    @Check
    public void checkTypeMatchesExpectedType(Expression expression) {
        boolean _not;
        boolean _requireCheckTypeMatchesExpectedType = this.jsVariantHelper.requireCheckTypeMatchesExpectedType((EObject)expression);
        boolean bl = _not = !_requireCheckTypeMatchesExpectedType;
        if (_not) {
            return;
        }
        if (expression instanceof ExpressionAnnotationList) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)expression);
        TypeRef inferredType = this.ts.type(G, (TypableElement)expression);
        if (inferredType instanceof UnknownTypeRef) {
            return;
        }
        G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)expression);
        TypeRef expectedTypeRef = this.ts.expectedType(G, expression.eContainer(), expression);
        if (expectedTypeRef != null) {
            ArrowFunction singleExprArrowFunction = N4JSASTUtils.getContainingSingleExpressionArrowFunction((Expression)expression);
            if (singleExprArrowFunction != null && TypeUtils.isVoid((TypeArgument)inferredType)) {
                boolean _tripleEquals;
                if (TypeUtils.isVoid((TypeArgument)expectedTypeRef) || singleExprArrowFunction.isReturnValueOptional()) {
                    return;
                }
                TypeRef _returnTypeRef = singleExprArrowFunction.getReturnTypeRef();
                boolean bl2 = _tripleEquals = _returnTypeRef == null;
                if (_tripleEquals) {
                    String message = IssueCodes.getMessageForFUN_SINGLE_EXP_LAMBDA_IMPLICIT_RETURN_ALLOWED_UNLESS_VOID();
                    this.addIssue(message, (EObject)expression, "FUN_SINGLE_EXP_LAMBDA_IMPLICIT_RETURN_ALLOWED_UNLESS_VOID");
                    return;
                }
            }
            this.internalCheckUseOfUndefinedExpression(G, expression, expectedTypeRef, inferredType);
            boolean writeAccess = ExpressionExtensions.isLeftHandSide((EObject)expression);
            if (writeAccess) {
                Result result = this.ts.subtype(G, (TypeArgument)expectedTypeRef, (TypeArgument)inferredType);
                boolean _isFailure = result.isFailure();
                if (_isFailure) {
                    String message_1 = IssueCodes.getMessageForTYS_NO_SUPERTYPE_WRITE_ACCESS(expectedTypeRef.getTypeRefAsString(), inferredType.getTypeRefAsString());
                    this.addIssue(message_1, (EObject)expression, "TYS_NO_SUPERTYPE_WRITE_ACCESS");
                }
            } else {
                Result result_1 = this.ts.subtype(G, (TypeArgument)inferredType, (TypeArgument)expectedTypeRef);
                boolean errorCreated = this.createTypeError(result_1, (EObject)expression);
                if (!errorCreated) {
                    this.internalCheckSuperfluousPropertiesInObjectLiteralRek(G, expectedTypeRef, expression);
                }
            }
        }
    }

    public void internalCheckSuperfluousPropertiesInObjectLiteralRek(RuleEnvironment G, TypeRef expectedTypeRef, Expression expression) {
        if (expression instanceof ObjectLiteral) {
            this.internalCheckSuperfluousPropertiesInObjectLiteral(expectedTypeRef, (ObjectLiteral)expression);
        } else if (expression instanceof ArrayLiteral) {
            boolean _not;
            boolean _isEmpty = expectedTypeRef.getTypeArgs().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                TypeArgument arrayElementType = (TypeArgument)expectedTypeRef.getTypeArgs().get(0);
                TypeRef typeArgTypeRef = this.ts.resolveType(G, arrayElementType);
                EList _elements = ((ArrayLiteral)expression).getElements();
                for (ArrayElement arrElem : _elements) {
                    Expression arrExpr = arrElem.getExpression();
                    this.internalCheckSuperfluousPropertiesInObjectLiteralRek(G, typeArgTypeRef, arrExpr);
                }
            }
        }
    }

    public void internalCheckSuperfluousPropertiesInObjectLiteral(TypeRef typeRef, ObjectLiteral objectLiteral) {
        TypingStrategy typingStrategy = typeRef.getTypingStrategy();
        if (!Objects.equal((Object)typingStrategy, (Object)TypingStrategy.NOMINAL) && !Objects.equal((Object)typingStrategy, (Object)TypingStrategy.DEFAULT)) {
            boolean _isDynamic = typeRef.isDynamic();
            if (_isDynamic) {
                return;
            }
            Type type = typeRef.getDeclaredType();
            if (type == null && typeRef instanceof BoundThisTypeRef) {
                ParameterizedTypeRef _actualThisTypeRef = ((BoundThisTypeRef)typeRef).getActualThisTypeRef();
                Type _declaredType = null;
                if (_actualThisTypeRef != null) {
                    _declaredType = _actualThisTypeRef.getDeclaredType();
                }
                type = _declaredType;
            }
            if (!(type instanceof ContainerType)) {
                return;
            }
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)objectLiteral);
            EList structuralMembers = typeRef.getStructuralMembers();
            if (structuralMembers.isEmpty() && Objects.equal((Object)type, (Object)RuleEnvironmentExtensions.objectType(G))) {
                return;
            }
            TMethod ctor = this.containerTypesHelper.fromContext((EObject)objectLiteral).findConstructor((ContainerType)type);
            boolean _isSpecArgumentToSpecCtor = N4JSTypeValidator.isSpecArgumentToSpecCtor((Expression)objectLiteral, ctor);
            TypingStrategyFilter strategyFilter = new TypingStrategyFilter(typingStrategy, typingStrategy == TypingStrategy.STRUCTURAL_WRITE_ONLY_FIELDS, _isSpecArgumentToSpecCtor);
            Functions.Function1 _function = member -> strategyFilter.apply((TMember)member);
            Functions.Function1 _function_1 = member -> member.getName();
            Set expectedMembers = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.containerTypesHelper.fromContext((EObject)objectLiteral).allMembers((ContainerType)type), (Functions.Function1)_function), (Functions.Function1)_function_1));
            Consumer<TStructMember> _function_2 = member -> expectedMembers.add(member.getName());
            typeRef.getStructuralMembers().forEach(_function_2);
            Type _definedType = objectLiteral.getDefinedType();
            EList inputMembers = ((ContainerType)_definedType).getOwnedMembers();
            for (TMember property : inputMembers) {
                boolean _not;
                boolean _contains = expectedMembers.contains(property.getName());
                boolean bl = _not = !_contains;
                if (!_not) continue;
                EObject astElement = property.getAstElement();
                if (astElement instanceof PropertyNameValuePair) {
                    astElement = ((PropertyNameValuePair)astElement).getDeclaredName();
                }
                String message = IssueCodes.getMessageForCLF_SPEC_SUPERFLUOUS_PROPERTIES(property.getName(), typeRef.getTypeRefAsString());
                this.addIssue(message, astElement, "CLF_SPEC_SUPERFLUOUS_PROPERTIES");
            }
        }
    }

    private void internalCheckUseOfUndefinedExpression(RuleEnvironment G, Expression expression, TypeRef expectedTypeRef, TypeRef actualTypeRef) {
        EObject parent;
        if (!(!TypeUtils.isUndefined((TypeArgument)actualTypeRef) || TypeUtils.isUndefined((TypeArgument)expectedTypeRef) || (parent = expression.eContainer()) instanceof ExpressionStatement || parent instanceof UnaryExpression && ((UnaryExpression)parent).getOp() == UnaryOperator.VOID || expression instanceof UnaryExpression && ((UnaryExpression)expression).getOp() == UnaryOperator.VOID || expression instanceof ThisLiteral)) {
            boolean isUndefinedLiteral;
            TMember _findOwnedMember = RuleEnvironmentExtensions.globalObjectType(G).findOwnedMember("undefined", false, false);
            TField undefinedField = (TField)_findOwnedMember;
            boolean _xifexpression = false;
            if (expression instanceof IdentifierRef) {
                IdentifiableElement _id = ((IdentifierRef)expression).getId();
                boolean bl = _xifexpression = _id == undefinedField;
            }
            if (!(isUndefinedLiteral = _xifexpression)) {
                this.addIssue(IssueCodes.getMessageForEXP_USE_OF_UNDEF_EXPR(), (EObject)expression, "EXP_USE_OF_UNDEF_EXPR");
            }
        }
    }

    @Check
    public void checkBogusTypeReference(TypedElement te) {
        boolean _tripleNotEquals;
        TypeRef _bogusTypeRef = te.getBogusTypeRef();
        boolean bl = _tripleNotEquals = _bogusTypeRef != null;
        if (_tripleNotEquals) {
            this.addIssue(IssueCodes.getMessageForTYS_INVALID_TYPE_SYNTAX(), (EObject)te.getBogusTypeRef(), "TYS_INVALID_TYPE_SYNTAX");
        }
    }

    @Check
    public void checkUnionTypeContainsNoAny(UnionTypeExpression ute) {
        this.checkComposedTypeRefContainsNoAny((ComposedTypeRef)ute, IssueCodes.getMessageForUNI_ANY_USED(), "UNI_ANY_USED", true);
    }

    @Check
    public void checkIntersectionTypeContainsNoAny(IntersectionTypeExpression ite) {
        this.checkComposedTypeRefContainsNoAny((ComposedTypeRef)ite, IssueCodes.getMessageForINTER_ANY_USED(), "INTER_ANY_USED", false);
    }

    private void checkComposedTypeRefContainsNoAny(ComposedTypeRef ctr, String msg, String issueCode, boolean soleVoidAllowesAny) {
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)ctr);
        AnyType anyType = RuleEnvironmentExtensions.anyType(G);
        VoidType voidType = RuleEnvironmentExtensions.voidType(G);
        EList typeRefs = ctr.getTypeRefs();
        Functions.Function1 _function = it -> {
            Type _declaredType = it.getDeclaredType();
            return _declaredType == anyType;
        };
        Iterable anyTypeRefs = IterableExtensions.filter((Iterable)typeRefs, (Functions.Function1)_function);
        boolean dontShowWarning = false;
        if (soleVoidAllowesAny) {
            Functions.Function1 _function_1 = it -> {
                Type _declaredType = it.getDeclaredType();
                return _declaredType == voidType;
            };
            boolean containsVoid = IterableExtensions.exists((Iterable)typeRefs, (Functions.Function1)_function_1);
            boolean bl = dontShowWarning = containsVoid && IterableExtensions.size((Iterable)anyTypeRefs) == 1;
        }
        if (!dontShowWarning) {
            for (TypeRef anyTR : anyTypeRefs) {
                this.addIssue(msg, (EObject)anyTR, issueCode);
            }
        }
    }

    @Check
    public void checkUnionHasUnnecessarySubtype(UnionTypeExpression ute) {
        boolean _greaterThan;
        List<TypeRef> tRefs = this.extractNonStructTypeRefs((ComposedTypeRef)ute);
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)ute);
        AnyType anyType = RuleEnvironmentExtensions.anyType(G);
        Predicate<TypeRef> _function = it -> {
            Type _declaredType = it.getDeclaredType();
            return _declaredType == anyType;
        };
        tRefs.removeIf(_function);
        int _size = tRefs.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            List<TypeRef> intersectionTR = this.tsh.getSuperTypesOnly(G, (TypeRef[])Conversions.unwrapArray(tRefs, TypeRef.class));
            tRefs.removeAll(intersectionTR);
            for (TypeRef tClassR : tRefs) {
                String message = IssueCodes.getMessageForUNI_REDUNDANT_SUBTYPE();
                this.addIssue(message, (EObject)tClassR, "UNI_REDUNDANT_SUBTYPE");
            }
        }
    }

    @Check
    public void checkIntersectionType(IntersectionTypeExpression ite) {
        boolean _greaterThan;
        List<TypeRef> tClassRefs = this.extractNonStructTypeRefs((ComposedTypeRef)ite);
        int _size = tClassRefs.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)ite);
            List<TypeRef> intersectionTR = this.tsh.getSubtypesOnly(G, (TypeRef[])Conversions.unwrapArray(tClassRefs, TypeRef.class));
            this.checkIntersectionTypeContainsMaxOneClass(ite, G, tClassRefs, intersectionTR);
            this.checkIntersectionHasUnnecessarySupertype(ite, G, tClassRefs, intersectionTR);
        }
    }

    private void checkIntersectionTypeContainsMaxOneClass(IntersectionTypeExpression ite, RuleEnvironment G, List<TypeRef> tClassRefs, List<TypeRef> intersectionTR) {
        boolean _greaterThan;
        int _size = intersectionTR.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            for (TypeRef tClassR : intersectionTR) {
                String message = IssueCodes.getMessageForINTER_ONLY_ONE_CLASS_ALLOWED();
                this.addIssue(message, (EObject)tClassR, "INTER_ONLY_ONE_CLASS_ALLOWED");
            }
        }
    }

    private void checkIntersectionHasUnnecessarySupertype(IntersectionTypeExpression ite, RuleEnvironment G, List<TypeRef> tClassRefs, List<TypeRef> intersectionTR) {
        tClassRefs.removeAll(intersectionTR);
        for (TypeRef tClassR : tClassRefs) {
            String message = IssueCodes.getMessageForINTER_REDUNDANT_SUPERTYPE();
            this.addIssue(message, (EObject)tClassR, "INTER_REDUNDANT_SUPERTYPE");
        }
    }

    private List<TypeRef> extractNonStructTypeRefs(ComposedTypeRef ctr) {
        LinkedList<TypeRef> tClassRefs = new LinkedList<TypeRef>();
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)ctr);
        List<TypeRef> tRefs = this.tsh.getSimplifiedTypeRefs(G, ctr);
        for (TypeRef tR : tRefs) {
            boolean isStructural;
            Type type = tR.getDeclaredType();
            if (!(type instanceof TClass)) continue;
            boolean bl = isStructural = tR.isDefSiteStructuralTyping() || tR.isUseSiteStructuralTyping();
            if (isStructural) continue;
            tClassRefs.add(tR);
        }
        return tClassRefs;
    }

    private static boolean isSpecArgumentToSpecCtor(Expression expr, TMethod ctor) {
        int argIdx;
        TFormalParameter ctorFpar;
        if (ctor == null) {
            return false;
        }
        EObject _eContainer = null;
        if (expr != null) {
            _eContainer = expr.eContainer();
        }
        EObject parent = _eContainer;
        EObject _eContainer_1 = null;
        if (parent != null) {
            _eContainer_1 = parent.eContainer();
        }
        EObject grandParent = _eContainer_1;
        if (parent instanceof Argument && grandParent instanceof NewExpression && (ctorFpar = ctor.getFparForArgIdx(argIdx = ((NewExpression)grandParent).getArguments().indexOf((Object)parent))) != null) {
            return AnnotationDefinition.SPEC.hasAnnotation((TAnnotableElement)ctorFpar);
        }
        return false;
    }
}

