/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.model;

import java.util.Collection;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.ControlFlowable;
import org.eclipse.n4js.flowgraphs.model.JumpToken;
import org.eclipse.n4js.flowgraphs.model.Node;

public class EdgeUtils {
    public static void connectCF(ControlFlowable cf1, ControlFlowable cf2) {
        EdgeUtils.connectCF(cf1.getExit(), cf2.getEntry());
    }

    public static ControlFlowEdge connectCF(Node n1, Node n2) {
        return EdgeUtils.connectCF(n1, n2, ControlFlowType.Successor);
    }

    public static ControlFlowEdge connectCF(Node n1, Node n2, ControlFlowType cfType) {
        ControlFlowEdge cfEdge = new ControlFlowEdge(n1, n2, cfType);
        try {
            n1.addSuccessor(cfEdge);
            n2.addPredecessor(cfEdge);
            return cfEdge;
        }
        catch (IllegalStateException e) {
            System.out.println("Edge details: " + cfEdge);
            throw e;
        }
    }

    public static ControlFlowEdge connectCF(Node n1, Node n2, JumpToken jumpContext) {
        ControlFlowEdge cfEdge = new ControlFlowEdge(n1, n2, jumpContext);
        n1.addSuccessor(cfEdge);
        n2.addPredecessor(cfEdge);
        return cfEdge;
    }

    public static void removeAllCF(Collection<ControlFlowEdge> succEdges) {
        for (ControlFlowEdge succEdge : succEdges) {
            EdgeUtils.removeCF(succEdge);
        }
    }

    public static void removeCF(ControlFlowEdge succEdge) {
        Node start = succEdge.start;
        Node end = succEdge.end;
        start.succ.remove(succEdge);
        end.pred.remove(succEdge);
    }
}

