/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.sse.core.internal.util.AbstractMemoryListener;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.osgi.service.event.Event;

public class GlobalCMDocumentCache {
    private static GlobalCMDocumentCache globalDocumentCache = new GlobalCMDocumentCache();
    private Map systemCatalogEntries = GlobalCMDocumentCache.getSystemCatalogEntries();
    private MemoryListener memoryListener;
    private static final String CATEGORY = "CMDocumentGlobalCache";

    protected GlobalCMDocumentCache() {
        Logger.trace(CATEGORY, "Cache initialized");
        this.memoryListener = new MemoryListener();
        this.memoryListener.connect();
    }

    public static GlobalCMDocumentCache getInstance() {
        return globalDocumentCache;
    }

    public synchronized GlobalCacheQueryResponse getCMDocument(String grammarURI) {
        Object systemCatalogEntry = this.systemCatalogEntries.get(grammarURI);
        if (systemCatalogEntry != null) {
            Object object = ((SoftReference)systemCatalogEntry).get();
            if (object != null) {
                return new GlobalCacheQueryResponse((CMDocument)object, true);
            }
            return new GlobalCacheQueryResponse(null, true);
        }
        return new GlobalCacheQueryResponse(null, false);
    }

    public synchronized void putCMDocument(String grammarURI, CMDocument cmDocument) {
        this.systemCatalogEntries.put(grammarURI, new SoftReference<CMDocument>(cmDocument));
    }

    private static synchronized HashMap getSystemCatalogEntries() {
        HashMap<String, SoftReference<Object>> systemCatalogURIs = new HashMap<String, SoftReference<Object>>();
        ICatalog systemCatalog = null;
        ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        INextCatalog[] nextCatalogs = defaultCatalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog catalog = nextCatalogs[i];
            ICatalog referencedCatalog = catalog.getReferencedCatalog();
            if (referencedCatalog != null && "system_catalog".equals(referencedCatalog.getId())) {
                systemCatalog = referencedCatalog;
            }
            ++i;
        }
        if (systemCatalog != null) {
            ICatalogEntry[] catalogEntries = systemCatalog.getCatalogEntries();
            int i2 = 0;
            while (i2 < catalogEntries.length) {
                systemCatalogURIs.put(catalogEntries[i2].getURI(), new SoftReference<Object>(null));
                ++i2;
            }
        }
        return systemCatalogURIs;
    }

    public class GlobalCacheQueryResponse {
        private CMDocument cachedDocument;
        private boolean documentCacheable;

        public GlobalCacheQueryResponse(CMDocument cachedCMDocument, boolean documentCacheable) {
            this.cachedDocument = cachedCMDocument;
            this.documentCacheable = documentCacheable;
        }

        public CMDocument getCachedCMDocument() {
            return this.cachedDocument;
        }

        public boolean isDocumentCacheable() {
            return this.documentCacheable;
        }
    }

    private class MemoryListener
    extends AbstractMemoryListener {
        private MemoryListener() {
        }

        protected void handleMemoryEvent(Event event) {
            Object topic = event.getProperty("event.topics");
            if ("org/eclipse/equinox/events/MemoryEvent/SERIOUS".equals(topic) || "org/eclipse/equinox/events/MemoryEvent/CRITICAL".equals(topic)) {
                Logger.trace(GlobalCMDocumentCache.CATEGORY, "Serious severity low memory event received, flushing global CMDocument cache.");
                GlobalCMDocumentCache.this.systemCatalogEntries = GlobalCMDocumentCache.getSystemCatalogEntries();
            }
        }
    }
}

