/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitorInternal;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.flowgraphs.dataflow.guards.Guard;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardStructure;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardStructureFactory;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardType;
import org.eclipse.n4js.flowgraphs.dataflow.guards.InstanceofGuard;
import org.eclipse.n4js.flowgraphs.factories.CFEMapper;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class InstanceofGuardAnalyser
extends GraphVisitorInternal {
    Map<ControlFlowElement, InstanceofBranchWalker> elementsToBranch = new HashMap<ControlFlowElement, InstanceofBranchWalker>();

    public InstanceofGuardAnalyser() {
        super(TraverseDirection.Forward);
    }

    public Collection<InstanceofGuard> getAlwaysHoldingTypes(ControlFlowElement cfe) {
        InstanceofBranchWalker ibw = this.elementsToBranch.get(cfe = CFEMapper.map(cfe));
        if (ibw != null) {
            return ibw.alwaysHoldGards;
        }
        return null;
    }

    public Collection<InstanceofGuard> getNeverHoldingTypes(ControlFlowElement cfe) {
        InstanceofBranchWalker ibw = this.elementsToBranch.get(cfe = CFEMapper.map(cfe));
        if (ibw != null) {
            return ibw.neverHoldGards;
        }
        return null;
    }

    public Collection<InstanceofGuard> getMayHoldingTypes(ControlFlowElement cfe) {
        InstanceofBranchWalker ibw = this.elementsToBranch.get(cfe = CFEMapper.map(cfe));
        if (ibw != null) {
            return ibw.mayHoldGards;
        }
        return null;
    }

    @Override
    protected void initializeContainerInternal(ControlFlowElement curContainer) {
        this.requestActivation(new InstanceofGraphExplorer());
    }

    class InstanceofBranchWalker
    extends BranchWalkerInternal {
        Set<InstanceofGuard> alwaysHoldGards = new HashSet<InstanceofGuard>();
        Set<InstanceofGuard> neverHoldGards = new HashSet<InstanceofGuard>();
        Set<InstanceofGuard> mayHoldGards = new HashSet<InstanceofGuard>();

        InstanceofBranchWalker() {
        }

        @Override
        protected BranchWalkerInternal fork() {
            InstanceofBranchWalker ibw = new InstanceofBranchWalker();
            ibw.alwaysHoldGards.addAll(this.alwaysHoldGards);
            ibw.neverHoldGards.addAll(this.neverHoldGards);
            ibw.mayHoldGards.addAll(this.mayHoldGards);
            return ibw;
        }

        @Override
        protected void visit(Node node) {
            InstanceofGuardAnalyser.this.elementsToBranch.put(node.getControlFlowElement(), this);
        }

        @Override
        protected void visit(Node lastVisitNode, Node end, ControlFlowEdge edge) {
            GuardStructure guardStructure = GuardStructureFactory.create(edge);
            if (guardStructure != null) {
                for (Guard guard : guardStructure.allGuards()) {
                    if (guard.type != GuardType.InstanceOf) continue;
                    InstanceofGuard instanceofGuard = (InstanceofGuard)guard;
                    switch (guard.asserts) {
                        case AlwaysHolds: {
                            this.alwaysHoldGards.add(instanceofGuard);
                            break;
                        }
                        case NeverHolds: {
                            this.neverHoldGards.add(instanceofGuard);
                            break;
                        }
                        case MayHolds: {
                            this.mayHoldGards.add(instanceofGuard);
                            break;
                        }
                    }
                }
            }
        }
    }

    class InstanceofGraphExplorer
    extends GraphExplorerInternal {
        InstanceofGraphExplorer() {
        }

        @Override
        protected BranchWalkerInternal firstBranchWalker() {
            return new InstanceofBranchWalker();
        }

        @Override
        protected BranchWalkerInternal joinBranchWalkers(List<BranchWalkerInternal> branchWalkers) {
            InstanceofBranchWalker joinedIBW = new InstanceofBranchWalker();
            HashSet<InstanceofGuard> alwaysHoldUnion = new HashSet<InstanceofGuard>();
            Iterator<BranchWalkerInternal> bwiIter = branchWalkers.iterator();
            if (!bwiIter.hasNext()) {
                return joinedIBW;
            }
            InstanceofBranchWalker ibw = (InstanceofBranchWalker)bwiIter.next();
            alwaysHoldUnion.addAll(ibw.alwaysHoldGards);
            joinedIBW.alwaysHoldGards.addAll(ibw.alwaysHoldGards);
            joinedIBW.neverHoldGards.addAll(ibw.neverHoldGards);
            joinedIBW.mayHoldGards.addAll(ibw.mayHoldGards);
            while (bwiIter.hasNext()) {
                ibw = (InstanceofBranchWalker)bwiIter.next();
                if (ibw.isDeadCodeBranch()) continue;
                alwaysHoldUnion.addAll(ibw.alwaysHoldGards);
                joinedIBW.alwaysHoldGards.retainAll(ibw.alwaysHoldGards);
                joinedIBW.neverHoldGards.retainAll(ibw.neverHoldGards);
                joinedIBW.mayHoldGards.addAll(ibw.mayHoldGards);
            }
            alwaysHoldUnion.removeAll(joinedIBW.alwaysHoldGards);
            joinedIBW.mayHoldGards.addAll(alwaysHoldUnion);
            return joinedIBW;
        }
    }
}

