/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class TopologicalSorter {
    private LinkedHashSet<ProjectDescription> result;
    private Map<String, Entry> name2entry;
    private IAcceptor<ProjectDescription> cyclicAcceptor;

    public List<ProjectDescription> sortByDependencies(Iterable<ProjectDescription> descriptions, final Procedures.Procedure1<? super ProjectDescription> cyclicAcceptor) {
        List _xblockexpression = null;
        this.cyclicAcceptor = new IAcceptor<ProjectDescription>(){

            public void accept(ProjectDescription arg0) {
                cyclicAcceptor.apply((Object)arg0);
            }
        };
        Functions.Function1 _function = it -> new Entry((ProjectDescription)it);
        Functions.Function1 _function_1 = it -> ((Entry)it).description.getName();
        this.name2entry = IterableExtensions.toMap((Iterable)IterableExtensions.map(descriptions, (Functions.Function1)_function), (Functions.Function1)_function_1);
        this.result = CollectionLiterals.newLinkedHashSet();
        Consumer<Entry> _function_2 = it -> this.visit((Entry)it);
        this.name2entry.values().forEach(_function_2);
        _xblockexpression = IterableExtensions.toList(this.result);
        return _xblockexpression;
    }

    protected boolean visit(Entry current) {
        if (!this.result.contains(current.description) && !current.cyclic) {
            if (current.marked) {
                this.markCyclic(current);
                return false;
            }
            current.marked = true;
            List _dependencies = current.description.getDependencies();
            for (String it : _dependencies) {
                Entry depEntry = this.name2entry.get(it);
                if (depEntry == null || this.visit(depEntry)) continue;
                this.markCyclic(current);
                return false;
            }
            current.marked = false;
            this.result.add(current.description);
        }
        return true;
    }

    protected void markCyclic(Entry it) {
        if (!it.cyclic) {
            it.cyclic = true;
            this.cyclicAcceptor.accept((Object)it.description);
        }
    }

    @FinalFieldsConstructor
    protected static class Entry {
        private final ProjectDescription description;
        private boolean marked;
        private boolean cyclic;

        public String toString() {
            return this.description.getName();
        }

        public Entry(ProjectDescription description) {
            this.description = description;
        }
    }
}

