/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class MultimapJoiner {
    private final Joiner entryJoiner;
    private final String keyValueSeparator;
    private final String separator;

    public MultimapJoiner(Joiner entryJoiner, String separator, String keyValueSeparator) {
        this.entryJoiner = entryJoiner;
        this.separator = separator;
        this.keyValueSeparator = keyValueSeparator;
    }

    public <A extends Appendable> A appendTo(A appendable, Multimap<?, ?> map) throws IOException {
        return this.appendTo(appendable, map.asMap().entrySet());
    }

    public <A extends Appendable> A appendTo(A appendable, Map<?, ? extends Collection<?>> map) throws IOException {
        return this.appendTo(appendable, map.entrySet());
    }

    public StringBuilder appendTo(StringBuilder builder, Multimap<?, ?> map) {
        return this.appendTo(builder, (Iterable<? extends Map.Entry<?, ? extends Collection<?>>>)map.asMap().entrySet());
    }

    public StringBuilder appendTo(StringBuilder builder, Map<?, ? extends Collection<?>> map) {
        return this.appendTo(builder, (Iterable<? extends Map.Entry<?, ? extends Collection<?>>>)map.entrySet());
    }

    public String join(Multimap<?, ?> map) {
        return this.join(map.asMap().entrySet());
    }

    public <A extends Appendable> A appendTo(A appendable, Iterable<? extends Map.Entry<?, ? extends Collection<?>>> entries) throws IOException {
        Iterator<Map.Entry<?, Collection<?>>> iterator = entries.iterator();
        if (iterator.hasNext()) {
            Map.Entry<?, Collection<?>> entry = iterator.next();
            appendable.append(this.toString(entry.getKey()));
            appendable.append(this.keyValueSeparator);
            this.entryJoiner.appendTo(appendable, (Iterable)entry.getValue());
            while (iterator.hasNext()) {
                appendable.append(this.separator);
                Map.Entry<?, Collection<?>> e = iterator.next();
                appendable.append(this.toString(e.getKey()));
                appendable.append(this.keyValueSeparator);
                this.entryJoiner.appendTo(appendable, (Iterable)e.getValue());
            }
        }
        return appendable;
    }

    public StringBuilder appendTo(StringBuilder builder, Iterable<? extends Map.Entry<?, ? extends Collection<?>>> entries) {
        try {
            this.appendTo((Appendable)builder, entries);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return builder;
    }

    public String join(Iterable<? extends Map.Entry<?, ? extends Collection<?>>> entries) {
        return this.appendTo(new StringBuilder(), entries).toString();
    }

    protected CharSequence toString(Object part) {
        return part instanceof CharSequence ? (CharSequence)part : part.toString();
    }

    public MultimapJoiner skipNulls() {
        return new MultimapJoiner(this.entryJoiner.skipNulls(), this.separator, this.keyValueSeparator);
    }

    public MultimapJoiner useForNull(final String nullText) {
        return new MultimapJoiner(this.entryJoiner.useForNull(nullText), this.separator, this.keyValueSeparator){

            @Override
            protected CharSequence toString(Object part) {
                return part == null ? nullText : MultimapJoiner.this.toString(part);
            }

            @Override
            public MultimapJoiner useForNull(String nullText2) {
                throw new UnsupportedOperationException("already specified useForNull");
            }

            @Override
            public MultimapJoiner skipNulls() {
                throw new UnsupportedOperationException("already specified useForNull");
            }
        };
    }
}

