/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries.nodejs;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.BinariesConstants;
import org.eclipse.n4js.binaries.BinariesLocatorHelper;
import org.eclipse.n4js.binaries.BinariesPreferenceStore;
import org.eclipse.n4js.binaries.BinariesValidator;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.model.SemverSerializer;

@Singleton
public class NodeJsBinary
implements Binary {
    private String memoizedCalculatedNodePath = null;
    @Inject
    private BinariesValidator validator;
    @Inject
    private Provider<NpmBinary> npmBinaryProvider;
    @Inject
    private BinariesPreferenceStore preferenceStore;
    @Inject
    private BinariesLocatorHelper nodeBinaryLocatorHelper;

    @Override
    public String getId() {
        return NodeJsBinary.class.getName();
    }

    @Override
    public String getLabel() {
        return "Node.js";
    }

    @Override
    public String getDescription() {
        return "Configuration of the folder location of the Node.js\u00ae executable can be provided here. If not given, then the '" + this.getDefaultNodePath() + "' location will be used as the default location. The required minimum version for Node.js is '" + SemverSerializer.serialize((VersionNumber)this.getMinimumVersion()) + "'.";
    }

    @Override
    public VersionNumber getMinimumVersion() {
        return BinariesConstants.NODE_MIN_VERSION;
    }

    @Override
    public String getBinaryAbsolutePath() {
        return String.valueOf(this.getUserNodePathOrDefault()) + File.separator + BinariesConstants.NODE_BINARY_NAME;
    }

    @Override
    public String getVersionArgument() {
        return "-v";
    }

    @Override
    public Binary getParent() {
        return null;
    }

    @Override
    public Iterable<Binary> getChildren() {
        return Collections.singletonList((Binary)this.npmBinaryProvider.get());
    }

    @Override
    public Map<String, String> updateEnvironment(Map<String, String> environment) {
        String additionalNodePath = this.getUserNodePathOrDefault();
        String currentPathValue = environment.get("PATH");
        if (Strings.isNullOrEmpty((String)currentPathValue)) {
            environment.put("PATH", additionalNodePath);
        } else {
            environment.put("PATH", String.valueOf(currentPathValue) + File.pathSeparator + additionalNodePath);
        }
        return environment;
    }

    @Override
    public URI getUserConfiguredLocation() {
        return this.preferenceStore.getPath(this);
    }

    @Override
    public IStatus validate() {
        return this.validator.validate(this);
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeJsBinary)) {
            return false;
        }
        NodeJsBinary other = (NodeJsBinary)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    public String getUserNodePathOrDefault() {
        URI userConfiguredLocation = this.getUserConfiguredLocation();
        return userConfiguredLocation == null ? this.getDefaultNodePath() : new File(userConfiguredLocation).getAbsolutePath();
    }

    private String getDefaultNodePath() {
        if (this.memoizedCalculatedNodePath == null) {
            this.memoizedCalculatedNodePath = this.nodeBinaryLocatorHelper.findNodePath().toString();
        }
        return this.memoizedCalculatedNodePath;
    }
}

