/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AssignmentOperator;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.BinaryBitwiseExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ImportCallExpression;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.n4JS.JSXPropertyAttribute;
import org.eclipse.n4js.n4JS.MultiplicativeExpression;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PostfixExpression;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.ShiftExpression;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.n4JS.util.N4JSSwitch;
import org.eclipse.n4js.n4jsx.ReactHelper;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeExtensions;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.AbstractJudgment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.PromisifyHelper;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.EcoreUtil2;

class ExpectedTypeJudgment
extends AbstractJudgment {
    @Inject
    private PromisifyHelper promisifyHelper;
    @Inject
    private JavaScriptVariantHelper javaScriptVariantHelper;
    @Inject
    private ReactHelper reactHelper;

    ExpectedTypeJudgment() {
    }

    public TypeRef apply(RuleEnvironment G, EObject container, Expression expression) {
        return expression != null ? (TypeRef)new ExpectedTypeJudgmentSwitch(G, expression).doSwitch(container) : null;
    }

    private final class ExpectedTypeJudgmentSwitch
    extends N4JSSwitch<TypeRef> {
        private final RuleEnvironment G;
        private final Expression expression;

        private ExpectedTypeJudgmentSwitch(RuleEnvironment G, Expression expression) {
            this.G = G;
            this.expression = expression;
        }

        public TypeRef defaultCase(EObject container) {
            return null;
        }

        public TypeRef caseFormalParameter(FormalParameter fpar) {
            TypeRef tFparTypeRef;
            TypeRef declTypeRef = fpar.getDeclaredTypeRef();
            if (declTypeRef != null) {
                return declTypeRef;
            }
            TFormalParameter tFpar = fpar.getDefinedTypeElement();
            TypeRef typeRef = tFparTypeRef = tFpar != null ? tFpar.getTypeRef() : null;
            if (tFparTypeRef != null) {
                return tFparTypeRef;
            }
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseArgument(Argument argument) {
            EObject exprPlain = argument.eContainer();
            if (exprPlain instanceof NewExpression) {
                TFormalParameter fpar;
                NewExpression expr = (NewExpression)exprPlain;
                if (!expr.getArguments().contains((Object)argument)) {
                    return ExpectedTypeJudgment.unknown();
                }
                TypeRef ctorTypeRefPlain = ExpectedTypeJudgment.this.ts.type(this.G, (TypableElement)expr.getCallee());
                if (!(ctorTypeRefPlain instanceof TypeTypeRef)) {
                    return ExpectedTypeJudgment.unknown();
                }
                TypeTypeRef ctorTypeRef = (TypeTypeRef)ctorTypeRefPlain;
                TypeRef typeRefOfInstanceToCreate = ExpectedTypeJudgment.this.typeSystemHelper.createTypeRefFromStaticType(this.G, ctorTypeRef, (TypeArgument[])expr.getTypeArgs().toArray((Object[])new TypeArgument[0]));
                Type typeOfInstanceToCreatePlain = typeRefOfInstanceToCreate.getDeclaredType();
                if (!(typeOfInstanceToCreatePlain instanceof ContainerType)) {
                    return ExpectedTypeJudgment.unknown();
                }
                ContainerType typeOfInstanceToCreate = (ContainerType)typeOfInstanceToCreatePlain;
                RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                ExpectedTypeJudgment.this.typeSystemHelper.addSubstitutions(G2, typeRefOfInstanceToCreate);
                RuleEnvironmentExtensions.addThisType(G2, typeRefOfInstanceToCreate);
                TMethod ctor = ExpectedTypeJudgment.this.containerTypesHelper.fromContext(expr.eResource()).findConstructor(typeOfInstanceToCreate);
                TFormalParameter tFormalParameter = fpar = ctor != null ? ctor.getFparForArgIdx(ECollections.indexOf((List)expr.getArguments(), (Object)argument, (int)0)) : null;
                if (fpar == null) {
                    return ExpectedTypeJudgment.unknown();
                }
                TypeRef paramType = fpar.getTypeRef();
                if (paramType == null) {
                    return RuleEnvironmentExtensions.anyTypeRef(G2);
                }
                return ExpectedTypeJudgment.this.ts.substTypeVariables(G2, paramType);
            }
            if (exprPlain instanceof ParameterizedCallExpression) {
                ParameterizedCallExpression expr = (ParameterizedCallExpression)exprPlain;
                if (!expr.getArguments().contains((Object)argument)) {
                    return ExpectedTypeJudgment.unknown();
                }
                TypeRef targetTypeRef = ExpectedTypeJudgment.this.ts.type(this.G, (TypableElement)expr.getTarget());
                if (targetTypeRef instanceof FunctionTypeExprOrRef) {
                    FunctionTypeExprOrRef F = (FunctionTypeExprOrRef)targetTypeRef;
                    int argIndex = ECollections.indexOf((List)expr.getArguments(), (Object)argument, (int)0);
                    TFormalParameter fpar = F.getFparForArgIdx(argIndex);
                    if (fpar == null) {
                        return ExpectedTypeJudgment.unknown();
                    }
                    TypeRef paramTypeRef = fpar.getTypeRef();
                    if (paramTypeRef == null) {
                        return RuleEnvironmentExtensions.anyTypeRef(this.G);
                    }
                    RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                    ExpectedTypeJudgment.this.typeSystemHelper.addSubstitutions(G2, expr, (TypeRef)F);
                    if (expr.getTarget() instanceof SuperLiteral) {
                        Type containingClass;
                        N4ClassDeclaration containingClassDecl = (N4ClassDeclaration)EcoreUtil2.getContainerOfType((EObject)expr, N4ClassDeclaration.class);
                        Type type = containingClass = containingClassDecl != null ? containingClassDecl.getDefinedType() : null;
                        if (containingClass instanceof TClass) {
                            RuleEnvironmentExtensions.addThisType(G2, TypeExtensions.ref((Type)containingClass, (TypeArgument[])new TypeArgument[0]));
                            ParameterizedTypeRef superClassRef = ((TClass)containingClass).getSuperClassRef();
                            if (superClassRef != null) {
                                ExpectedTypeJudgment.this.typeSystemHelper.addSubstitutions(G2, (TypeRef)superClassRef);
                                if (paramTypeRef instanceof ThisTypeRefStructural) {
                                    RuleEnvironmentExtensions.addThisType(G2, (TypeRef)superClassRef);
                                }
                            }
                        }
                    }
                    TypeRef paramTypeRefSubst = ExpectedTypeJudgment.this.ts.substTypeVariables(G2, paramTypeRef);
                    return paramTypeRefSubst;
                }
                return ExpectedTypeJudgment.unknown();
            }
            if (exprPlain instanceof ImportCallExpression) {
                ImportCallExpression expr = (ImportCallExpression)exprPlain;
                int argIdx = expr.getArguments().indexOf((Object)argument);
                if (argIdx == 0) {
                    return RuleEnvironmentExtensions.stringTypeRef(this.G);
                }
                return ExpectedTypeJudgment.unknown();
            }
            return ExpectedTypeJudgment.unknown();
        }

        public TypeRef casePostfixExpression(PostfixExpression e) {
            if (ExpectedTypeJudgment.this.javaScriptVariantHelper.isTypeAware((EObject)e)) {
                return RuleEnvironmentExtensions.numberTypeRef(this.G);
            }
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseUnaryExpression(UnaryExpression e) {
            if (ExpectedTypeJudgment.this.javaScriptVariantHelper.isTypeAware((EObject)e)) {
                switch (e.getOp()) {
                    case DELETE: {
                        return TypeUtils.createNonSimplifiedUnionType((TypeRef[])new TypeRef[]{RuleEnvironmentExtensions.anyTypeRef(this.G), RuleEnvironmentExtensions.voidTypeRef(this.G)});
                    }
                    case VOID: {
                        return TypeUtils.createNonSimplifiedUnionType((TypeRef[])new TypeRef[]{RuleEnvironmentExtensions.anyTypeRef(this.G), RuleEnvironmentExtensions.voidTypeRef(this.G)});
                    }
                    case TYPEOF: {
                        return TypeUtils.createNonSimplifiedUnionType((TypeRef[])new TypeRef[]{RuleEnvironmentExtensions.anyTypeRef(this.G), RuleEnvironmentExtensions.voidTypeRef(this.G)});
                    }
                    case INC: {
                        return RuleEnvironmentExtensions.numberTypeRef(this.G);
                    }
                    case DEC: {
                        return RuleEnvironmentExtensions.numberTypeRef(this.G);
                    }
                    case POS: {
                        return RuleEnvironmentExtensions.numberTypeRef(this.G);
                    }
                    case NEG: {
                        return RuleEnvironmentExtensions.numberTypeRef(this.G);
                    }
                    case INV: {
                        return RuleEnvironmentExtensions.numberTypeRef(this.G);
                    }
                    case NOT: {
                        return RuleEnvironmentExtensions.anyTypeRef(this.G);
                    }
                }
                return RuleEnvironmentExtensions.anyTypeRef(this.G);
            }
            switch (e.getOp()) {
                case DELETE: {
                    return TypeUtils.createNonSimplifiedUnionType((TypeRef[])new TypeRef[]{RuleEnvironmentExtensions.anyTypeRef(this.G), RuleEnvironmentExtensions.voidTypeRef(this.G)});
                }
                case VOID: {
                    return TypeUtils.createNonSimplifiedUnionType((TypeRef[])new TypeRef[]{RuleEnvironmentExtensions.anyTypeRef(this.G), RuleEnvironmentExtensions.voidTypeRef(this.G)});
                }
                case TYPEOF: {
                    return TypeUtils.createNonSimplifiedUnionType((TypeRef[])new TypeRef[]{RuleEnvironmentExtensions.anyTypeRef(this.G), RuleEnvironmentExtensions.voidTypeRef(this.G)});
                }
            }
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseMultiplicativeExpression(MultiplicativeExpression e) {
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseAdditiveExpression(AdditiveExpression e) {
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseShiftExpression(ShiftExpression e) {
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseRelationalExpression(RelationalExpression e) {
            switch (e.getOp()) {
                case INSTANCEOF: {
                    if (this.expression == e.getRhs()) {
                        return TypeUtils.createNonSimplifiedUnionType((TypeRef[])new TypeRef[]{RuleEnvironmentExtensions.functionTypeRef(this.G), TypeUtils.createTypeTypeRef((TypeArgument)RuleEnvironmentExtensions.objectTypeRef(this.G), (boolean)false), TypeUtils.createTypeTypeRef((TypeArgument)RuleEnvironmentExtensions.n4EnumTypeRef(this.G), (boolean)false)});
                    }
                    return RuleEnvironmentExtensions.anyTypeRef(this.G);
                }
                case IN: {
                    if (this.expression == e.getRhs()) {
                        return RuleEnvironmentExtensions.objectTypeRef(this.G);
                    }
                    if (ExpectedTypeJudgment.this.javaScriptVariantHelper.isTypeAware((EObject)e)) {
                        return TypeUtils.createNonSimplifiedUnionType((TypeRef[])new TypeRef[]{RuleEnvironmentExtensions.numberTypeRef(this.G), RuleEnvironmentExtensions.stringTypeRef(this.G)});
                    }
                    return RuleEnvironmentExtensions.anyTypeRef(this.G);
                }
            }
            if (ExpectedTypeJudgment.this.javaScriptVariantHelper.isTypeAware((EObject)e)) {
                UnionTypeExpression primsTR = TypeUtils.createNonSimplifiedUnionType((TypeRef[])new TypeRef[]{RuleEnvironmentExtensions.numberTypeRef(this.G), RuleEnvironmentExtensions.stringTypeRef(this.G), RuleEnvironmentExtensions.booleanTypeRef(this.G)});
                Expression otherSide = this.expression == e.getLhs() ? e.getRhs() : e.getLhs();
                TypeRef otherSideTR = ExpectedTypeJudgment.this.ts.type(this.G, (TypableElement)otherSide);
                if (otherSideTR == null) {
                    return ExpectedTypeJudgment.unknown();
                }
                if (ExpectedTypeJudgment.this.ts.subtype(this.G, (TypeArgument)otherSideTR, (TypeArgument)primsTR).isSuccess() && !ExpectedTypeJudgment.this.ts.subtype(this.G, (TypeArgument)otherSideTR, (TypeArgument)RuleEnvironmentExtensions.nullTypeRef(this.G)).isSuccess()) {
                    return otherSideTR;
                }
                return primsTR;
            }
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseEqualityExpression(EqualityExpression e) {
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseBinaryBitwiseExpression(BinaryBitwiseExpression e) {
            if (ExpectedTypeJudgment.this.javaScriptVariantHelper.isTypeAware((EObject)e)) {
                return RuleEnvironmentExtensions.numberTypeRef(this.G);
            }
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseBinaryLogicalExpression(BinaryLogicalExpression e) {
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseAssignmentExpression(AssignmentExpression expr) {
            Expression operand = this.expression;
            if (!ExpectedTypeJudgment.this.javaScriptVariantHelper.isTypeAware((EObject)expr)) {
                if (operand == expr.getLhs()) {
                    return RuleEnvironmentExtensions.bottomTypeRef(this.G);
                }
                return RuleEnvironmentExtensions.topTypeRef(this.G);
            }
            if (DestructureUtils.isTopOfDestructuringAssignment((EObject)expr)) {
                if (operand == expr.getLhs()) {
                    return RuleEnvironmentExtensions.bottomTypeRef(this.G);
                }
                return RuleEnvironmentExtensions.topTypeRef(this.G);
            }
            if (expr.getOp() == AssignmentOperator.ASSIGN) {
                if (operand == expr.getLhs()) {
                    return RuleEnvironmentExtensions.bottomTypeRef(this.G);
                }
                return ExpectedTypeJudgment.this.ts.type(this.G, (TypableElement)expr.getLhs());
            }
            if (expr.getOp() == AssignmentOperator.ADD_ASSIGN) {
                if (operand == expr.getLhs()) {
                    return TypeUtils.createNonSimplifiedIntersectionType((TypeRef[])new TypeRef[]{RuleEnvironmentExtensions.numberTypeRef(this.G), RuleEnvironmentExtensions.stringTypeRef(this.G)});
                }
                TypeRef lhsTypeRef = ExpectedTypeJudgment.this.ts.type(this.G, (TypableElement)expr.getLhs());
                if (lhsTypeRef == null) {
                    return ExpectedTypeJudgment.unknown();
                }
                if (lhsTypeRef.getDeclaredType() == RuleEnvironmentExtensions.stringType(this.G)) {
                    return RuleEnvironmentExtensions.anyTypeRef(this.G);
                }
                if (RuleEnvironmentExtensions.isNumeric(this.G, lhsTypeRef.getDeclaredType())) {
                    return RuleEnvironmentExtensions.numberTypeRef(this.G);
                }
                return RuleEnvironmentExtensions.anyTypeRef(this.G);
            }
            return RuleEnvironmentExtensions.numberTypeRef(this.G);
        }

        public TypeRef caseVariableDeclaration(VariableDeclaration vdecl) {
            TypeRef declTypeRef = vdecl.getDeclaredTypeRef();
            if (declTypeRef != null) {
                return declTypeRef;
            }
            return RuleEnvironmentExtensions.topTypeRef(this.G);
        }

        public TypeRef caseVariableBinding(VariableBinding binding) {
            return RuleEnvironmentExtensions.topTypeRef(this.G);
        }

        public TypeRef caseN4FieldDeclaration(N4FieldDeclaration fdecl) {
            TypeRef declTypeRef = fdecl.getDeclaredTypeRef();
            if (declTypeRef != null) {
                return declTypeRef;
            }
            return RuleEnvironmentExtensions.topTypeRef(this.G);
        }

        public TypeRef casePropertyNameValuePair(PropertyNameValuePair pnvp) {
            TypeRef declTypeRef = pnvp.getDeclaredTypeRef();
            if (declTypeRef != null) {
                return declTypeRef;
            }
            return RuleEnvironmentExtensions.topTypeRef(this.G);
        }

        public TypeRef caseReturnStatement(ReturnStatement stmnt) {
            return ExpectedTypeJudgment.this.typeSystemHelper.getExpectedTypeOfReturnValueExpression(this.G, this.expression);
        }

        public TypeRef caseYieldExpression(YieldExpression yieldExpr) {
            TypeRef exprTypeRef = ExpectedTypeJudgment.this.ts.type(this.G, (TypableElement)this.expression);
            if (exprTypeRef == null) {
                return ExpectedTypeJudgment.unknown();
            }
            return ExpectedTypeJudgment.this.typeSystemHelper.getExpectedTypeOfYieldValueExpression(this.G, yieldExpr, exprTypeRef);
        }

        public TypeRef caseExpressionStatement(ExpressionStatement exprStmnt) {
            if (N4JSASTUtils.getContainingSingleExpressionArrowFunction((Expression)this.expression) != null) {
                return ExpectedTypeJudgment.this.typeSystemHelper.getExpectedTypeOfReturnValueExpression(this.G, this.expression);
            }
            return null;
        }

        public TypeRef caseForStatement(ForStatement forStmnt) {
            if (forStmnt.isForOf() && this.expression == forStmnt.getExpression()) {
                Wildcard wildThing = TypeRefsFactory.eINSTANCE.createWildcard();
                if (!DestructureUtils.isTopOfDestructuringForStatement((EObject)forStmnt)) {
                    VariableDeclaration varDeclOutside;
                    VariableDeclaration varDeclInFor = !forStmnt.getVarDecl().isEmpty() ? (VariableDeclaration)forStmnt.getVarDecl().get(0) : null;
                    VariableDeclaration variableDeclaration = varDeclOutside = forStmnt.getInitExpr() instanceof IdentifierRef && ((IdentifierRef)forStmnt.getInitExpr()).getId() instanceof VariableDeclaration ? (VariableDeclaration)((IdentifierRef)forStmnt.getInitExpr()).getId() : null;
                    if (varDeclInFor != null && varDeclInFor.getDeclaredTypeRef() != null || varDeclOutside != null) {
                        VariableDeclaration varDecl = varDeclOutside != null ? varDeclOutside : varDeclInFor;
                        TypeRef varTypeRef = ExpectedTypeJudgment.this.ts.type(this.G, (TypableElement)varDecl);
                        if (varTypeRef == null) {
                            return ExpectedTypeJudgment.unknown();
                        }
                        wildThing.setDeclaredUpperBound((TypeRef)TypeUtils.copyIfContained((EObject)varTypeRef));
                    }
                }
                return RuleEnvironmentExtensions.iterableTypeRef(this.G, new TypeArgument[]{wildThing});
            }
            if (forStmnt.isForIn() && this.expression == forStmnt.getExpression()) {
                return TypeUtils.createNonSimplifiedUnionType((TypeRef[])new TypeRef[]{RuleEnvironmentExtensions.objectTypeRef(this.G), RuleEnvironmentExtensions.stringTypeRef(this.G), RuleEnvironmentExtensions.argumentsTypeRef(this.G)});
            }
            return null;
        }

        public TypeRef caseAwaitExpression(AwaitExpression awaitExpr) {
            if (ExpectedTypeJudgment.this.promisifyHelper.isAutoPromisify(awaitExpr)) {
                return null;
            }
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseJSXPropertyAttribute(JSXPropertyAttribute container) {
            TypeRef propsTypeRef;
            EObject jsxElem = container.eContainer();
            if (jsxElem instanceof JSXElement && (propsTypeRef = ExpectedTypeJudgment.this.reactHelper.getPropsType((JSXElement)jsxElem)) != null) {
                RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                ExpectedTypeJudgment.this.typeSystemHelper.addSubstitutions(G2, propsTypeRef);
                RuleEnvironmentExtensions.addThisType(G2, propsTypeRef);
                TypeRef propertyTypeRef = ExpectedTypeJudgment.this.ts.type(G2, (TypableElement)container.getProperty());
                if (propertyTypeRef == null) {
                    return ExpectedTypeJudgment.unknown();
                }
                TypeRef propertyTypeRefSubst = ExpectedTypeJudgment.this.ts.substTypeVariables(G2, propertyTypeRef);
                return propertyTypeRefSubst;
            }
            return ExpectedTypeJudgment.unknown();
        }
    }
}

