/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;

public abstract class AbstractEditStrategyProvider {
    protected abstract void configure(IEditStrategyAcceptor var1);

    public List<IAutoEditStrategy> getStrategies(final ISourceViewer sourceViewer, final String contentType) {
        final ArrayList strategies = Lists.newArrayList();
        this.configure(new IEditStrategyAcceptor(){

            @Override
            public void accept(IAutoEditStrategy strategy, String type) {
                if (type == null || contentType.equals(type)) {
                    if (strategy instanceof ISourceViewerAware) {
                        ((ISourceViewerAware)strategy).setSourceViewer(sourceViewer);
                    }
                    if (strategy instanceof VerifyKeyListener) {
                        sourceViewer.getTextWidget().addVerifyKeyListener((VerifyKeyListener)strategy);
                    }
                    strategies.add(strategy);
                }
            }
        });
        return strategies;
    }

    public static interface IEditStrategyAcceptor {
        public void accept(IAutoEditStrategy var1, String var2);
    }
}

