/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;

public class JvmTypesUtil {
    private static void collectAllSuperTypes(JvmType type, Set<JvmType> visited) {
        if (type == null || type.eIsProxy() || !visited.add(type)) {
            return;
        }
        if (type instanceof JvmDeclaredType) {
            for (JvmTypeReference ref : ((JvmDeclaredType)type).getSuperTypes()) {
                JvmTypesUtil.collectAllSuperTypes(ref.getType(), visited);
            }
        }
    }

    public static Set<JvmType> getAllSuperTypes(JvmDeclaredType type) {
        LinkedHashSet visited = Sets.newLinkedHashSet();
        for (JvmTypeReference ref : type.getSuperTypes()) {
            JvmTypesUtil.collectAllSuperTypes(ref.getType(), visited);
        }
        return visited;
    }

    public static Set<JvmType> getSelfAndAllSuperTypes(JvmDeclaredType type) {
        LinkedHashSet visited = Sets.newLinkedHashSet();
        visited.add(type);
        for (JvmTypeReference ref : type.getSuperTypes()) {
            JvmTypesUtil.collectAllSuperTypes(ref.getType(), visited);
        }
        return visited;
    }
}

