/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.ui.internal.GitLabels;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingTree;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class GitLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private ResourceManager imageCache;
    private LabelProvider workbenchLabelProvider;

    public String getText(Object element) {
        return GitLabels.getPlainShortLabelExtended(element);
    }

    public Image getImage(Object element) {
        if (element instanceof Repository) {
            return UIIcons.getImage(this.getImageCache(), RepositoryTreeNodeType.REPO.getIcon());
        }
        if (element instanceof RefNode) {
            return this.getRefIcon((Ref)((RefNode)element).getObject());
        }
        if (element instanceof Ref) {
            return this.getRefIcon((Ref)element);
        }
        if (element instanceof GitModelBlob || element instanceof GitModelTree) {
            Object adapter = AdapterUtils.adapt((Object)element, IResource.class);
            return this.getWorkbenchLabelProvider().getImage(adapter);
        }
        if (element instanceof GitModelCommit || element instanceof GitModelCache || element instanceof GitModelWorkingTree || element instanceof RepositoryCommit) {
            return this.getChangesetIcon();
        }
        if (element instanceof GitModelRepository) {
            return this.getImage(((GitModelRepository)element).getRepository());
        }
        if (element instanceof ProjectRecord) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
        return super.getImage(element);
    }

    public StyledString getStyledText(Object element) {
        return GitLabels.getStyledLabelExtendedSafe(element);
    }

    protected Image getChangesetIcon() {
        return this.getImageCache().createImage(UIIcons.CHANGESET);
    }

    private Image getRefIcon(Ref ref) {
        String name = ref.getName();
        if (name.startsWith("refs/heads/") || name.startsWith("refs/remotes/")) {
            return UIIcons.getImage(this.getImageCache(), RepositoryTreeNodeType.REF.getIcon());
        }
        if (name.startsWith("refs/tags/")) {
            return UIIcons.getImage(this.getImageCache(), RepositoryTreeNodeType.TAG.getIcon());
        }
        return UIIcons.getImage(this.getImageCache(), RepositoryTreeNodeType.ADDITIONALREF.getIcon());
    }

    private LabelProvider getWorkbenchLabelProvider() {
        if (this.workbenchLabelProvider == null) {
            this.workbenchLabelProvider = new WorkbenchLabelProvider();
        }
        return this.workbenchLabelProvider;
    }

    private ResourceManager getImageCache() {
        if (this.imageCache == null) {
            this.imageCache = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.imageCache;
    }

    public void dispose() {
        super.dispose();
        if (this.imageCache != null) {
            this.imageCache.dispose();
        }
        if (this.workbenchLabelProvider != null) {
            this.workbenchLabelProvider.dispose();
        }
    }
}

