/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.search;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.JSXElementName;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.util.NameStaticPair;
import org.eclipse.n4js.ts.ui.search.LabelledReferenceDescription;
import org.eclipse.n4js.ts.ui.search.LabellingReferenceQueryExecutor;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.validation.validators.utils.MemberCube;
import org.eclipse.n4js.validation.validators.utils.MemberMatrix;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IReferenceDescription;

public class N4JSReferenceQueryExecutor
extends LabellingReferenceQueryExecutor {
    @Inject
    ContainerTypesHelper containerTypesHelper;
    public static boolean considerOverridenMethods = false;
    public static boolean ignoreNamedImportSpecifier = true;

    protected Iterable<URI> getTargetURIs(EObject primaryTarget) {
        Iterable originalResult = super.getTargetURIs(primaryTarget);
        ArrayList newResult = Lists.newArrayList((Iterable)originalResult);
        if (primaryTarget instanceof LiteralOrComputedPropertyName) {
            primaryTarget = primaryTarget.eContainer();
        }
        ArrayList<Object> realTargets = new ArrayList<Object>();
        if (primaryTarget instanceof TMember && ((TMember)primaryTarget).isComposed()) {
            EList eList = ((TMember)primaryTarget).getConstituentMembers();
            for (TMember constituentMember : eList) {
                realTargets.add(constituentMember);
            }
        } else {
            realTargets.add(primaryTarget);
        }
        for (EObject eObject : realTargets) {
            if (!considerOverridenMethods || !(eObject instanceof N4MemberDeclaration) && (!(eObject instanceof TMember) || !(eObject.eContainer() instanceof TClassifier))) continue;
            TMember tmember = primaryTarget instanceof N4MemberDeclaration ? ((N4MemberDeclaration)primaryTarget).getDefinedTypeElement() : (TMember)primaryTarget;
            for (TMember inheritedOrImplementedMember : this.getInheritedAndImplementedMembers(tmember)) {
                URI uri = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)inheritedOrImplementedMember);
                newResult.add(uri);
            }
        }
        return newResult;
    }

    protected boolean isRelevantToUser(IReferenceDescription referenceDescription) {
        if (referenceDescription instanceof LabelledReferenceDescription) {
            EObject source = ((LabelledReferenceDescription)referenceDescription).getSource();
            return !(source.eContainer() instanceof JSXElementName) || source.eContainer().eContainingFeature() != N4JSPackage.eINSTANCE.getJSXElement_JsxClosingName();
        }
        return super.isRelevantToUser(referenceDescription);
    }

    private MemberMatrix getMemberMatrix(TMember member) {
        TClassifier tclassifier = (TClassifier)member.eContainer();
        ContainerTypesHelper.MemberCollector memberCollector = this.containerTypesHelper.fromContext((EObject)tclassifier);
        MemberCube memberCube = new MemberCube(tclassifier, memberCollector);
        NameStaticPair nsp = NameStaticPair.of((TMember)member);
        Optional<Map.Entry> ret = memberCube.entrySet().stream().filter(entry -> ((NameStaticPair)entry.getKey()).equals((Object)nsp)).findFirst();
        if (ret.isPresent()) {
            Map.Entry mmEntry = ret.get();
            return (MemberMatrix)mmEntry.getValue();
        }
        return null;
    }

    private List<TMember> getInheritedAndImplementedMembers(TMember tmember) {
        ArrayList<TMember> ret = new ArrayList<TMember>();
        MemberMatrix mm = this.getMemberMatrix(tmember);
        if (mm != null) {
            for (TMember member : mm.inherited()) {
                ret.add(member);
            }
            for (TMember member : mm.implemented()) {
                ret.add(member);
            }
        }
        return ret;
    }
}

