/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.tester.domain.ID;
import org.eclipse.n4js.tester.domain.TestElement;
import org.eclipse.n4js.tester.domain.TestResult;

@JsonAutoDetect
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TestCase
implements TestElement,
Comparable<TestCase> {
    @JsonProperty
    private ID id;
    @JsonProperty
    private String className;
    @JsonProperty
    private String origin;
    @JsonProperty
    private String name;
    @JsonProperty
    private String displayName;
    private TestResult result;
    private URI uri;

    static TestCase copyOf(TestCase testCase) {
        TestCase copy = new TestCase(ID.copyOf(testCase.id), testCase.className, testCase.origin, testCase.name, testCase.displayName, testCase.uri);
        copy.setResult(TestResult.copyOf(testCase.result));
        return copy;
    }

    private TestCase() {
    }

    public TestCase(ID id, String className, String origin, String name, String displayName, URI methodURI) {
        this.id = id;
        this.className = className;
        this.origin = origin;
        this.name = name;
        this.displayName = displayName;
        this.uri = methodURI;
    }

    public URI getURI() {
        return this.uri;
    }

    public TestResult getResult() {
        return this.result;
    }

    public void setResult(TestResult result) {
        this.result = result;
    }

    public ID getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TestCase clone() throws CloneNotSupportedException {
        return TestCase.copyOf(this);
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + (this.id == null ? 0 : this.id.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestCase other = (TestCase)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(" [ID: ");
        sb.append(this.id);
        sb.append(", executed:");
        sb.append(this.result != null);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(TestCase o) {
        return o == null ? -1 : Strings.nullToEmpty((String)this.name).compareTo(Strings.nullToEmpty((String)o.name));
    }
}

