/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.common.base.Strings;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class DropDownAction
extends Action
implements IMenuCreator {
    private Menu menu;

    protected DropDownAction(String text) {
        this(text, null);
    }

    protected DropDownAction(ImageDescriptor imageDescriptor) {
        this("", imageDescriptor);
    }

    protected DropDownAction(String text, ImageDescriptor imageDescriptor) {
        this.setMenuCreator(this);
        if (imageDescriptor != null) {
            this.setImageDescriptor(imageDescriptor);
        }
        if (!Strings.isNullOrEmpty((String)text)) {
            this.setText(text);
        }
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar control = toolItem.getParent();
            Menu menu = this.getMenu((Control)control);
            Rectangle bounds = toolItem.getBounds();
            Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
            menu.setLocation(control.toDisplay(topLeft));
            menu.setVisible(true);
        }
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        this.menu = new Menu(parent);
        this.createMenuItems(this.menu);
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected abstract void createMenuItems(Menu var1);

    protected MenuItem createSeparator(Menu parent) {
        return new MenuItem(parent, 2);
    }
}

