/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.quickfix;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.binaries.IllegalBinaryStateException;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.ModifierUtils;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4FieldAccessor;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.projectDescription.ProjectDependency;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.SemverUtils;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ui.binaries.IllegalBinaryStateDialog;
import org.eclipse.n4js.ui.changes.ChangeProvider;
import org.eclipse.n4js.ui.changes.IChange;
import org.eclipse.n4js.ui.changes.SemanticChangeProvider;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.quickfix.AbstractN4JSQuickfixProvider;
import org.eclipse.n4js.ui.quickfix.N4Modification;
import org.eclipse.n4js.ui.quickfix.QuickfixUtil;
import org.eclipse.n4js.ui.quickfix.TopLevelVisibilityFixProvider;
import org.eclipse.n4js.ui.utils.ImportUtil;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.StatusUtils;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class N4JSQuickfixProvider
extends AbstractN4JSQuickfixProvider {
    @Inject
    @Extension
    private ImportUtil _importUtil;
    @Inject
    @Extension
    private StatusHelper _statusHelper;
    @Inject
    @Extension
    private QuickfixUtil.IssueUserDataKeysExtension _issueUserDataKeysExtension;
    @Inject
    private TopLevelVisibilityFixProvider topLevelVisibilityFixProvider;
    @Inject
    @Extension
    private SemanticChangeProvider _semanticChangeProvider;
    @Inject
    protected JavaScriptVariantHelper jsVariantHelper;
    @Inject
    private LibraryManager libraryManager;
    private static final String INTERNAL_ANNOTATION = AnnotationDefinition.INTERNAL.name;
    private static final String OVERRIDE_ANNOTATION = AnnotationDefinition.OVERRIDE.name;
    private static final String FINAL_ANNOTATION = AnnotationDefinition.FINAL.name;

    public void someSimpleQuickFixExample(Issue issue, IssueResolutionAcceptor acceptor) {
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                IChange _insertLineAbove = ChangeProvider.insertLineAbove(context.getXtextDocument(), offset, "@SomeAnnotationToBeAdded", true);
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_insertLineAbove}));
            }
        };
        this.accept(acceptor, issue, "Some Label", "Some enlightening description.", "SomeImage.gif", _function);
    }

    public void someComplexQuickFixExample(Issue issue, IssueResolutionAcceptor acceptor) {
        this.accept(acceptor, issue, "Some Label", "Some enlightening description.", "SomeImage.gif", new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                return null;
            }

            @Override
            public boolean supportsMultiApply() {
                return true;
            }

            @Override
            public boolean isApplicableTo(IMarker marker) {
                return true;
            }
        });
    }

    @Fix(value="CLF_FIELD_OPTIONAL_OLD_SYNTAX")
    public void fixOldSyntaxForOptionalFields(Issue issue, IssueResolutionAcceptor acceptor) {
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                int offsetNameEnd = N4JSQuickfixProvider.this.getOffsetOfNameEnd(element.eContainer());
                IChange _replace = ChangeProvider.replace(context.getXtextDocument(), offset + length - 1, 1, "");
                IChange _replace_1 = ChangeProvider.replace(context.getXtextDocument(), offsetNameEnd, 0, "?");
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_replace, _replace_1}));
            }
        };
        this.accept(acceptor, issue, "Change to new syntax", "The syntax for optional fields has changed. This quick fix will change the code to the new syntax.", "reorder.gif", _function);
    }

    private int getOffsetOfNameEnd(EObject parent) {
        ICompositeNode _switchResult = null;
        boolean _matched = false;
        if (parent instanceof N4FieldDeclaration) {
            _matched = true;
            _switchResult = NodeModelUtils.findActualNodeFor((EObject)((PropertyNameOwner)parent).getDeclaredName());
        }
        if (!_matched && parent instanceof TField) {
            _matched = true;
            _switchResult = (INode)IterableExtensions.head((Iterable)NodeModelUtils.findNodesForFeature((EObject)parent, (EStructuralFeature)TypesPackage.eINSTANCE.getIdentifiableElement_Name()));
        }
        ICompositeNode nodeOfName = _switchResult;
        int _xifexpression = 0;
        if (nodeOfName != null) {
            int _offset = nodeOfName.getOffset();
            int _length = nodeOfName.getLength();
            _xifexpression = _offset + _length;
        } else {
            _xifexpression = -1;
        }
        return _xifexpression;
    }

    @Fix(value="FUN_PARAM_OPTIONAL_WRONG_SYNTAX")
    public void fixOldSyntaxForOptionalFpars(Issue issue, IssueResolutionAcceptor acceptor) {
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                IChange _replace = ChangeProvider.replace(context.getXtextDocument(), offset + length - 1, 1, " = undefined");
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_replace}));
            }
        };
        this.accept(acceptor, issue, "Change to Default Parameter", "Some enlightening description.", "reorder.gif", _function);
    }

    @Fix(value="CLF_OVERRIDE_ANNOTATION")
    public void addOverrideAnnotation(Issue issue, IssueResolutionAcceptor acceptor) {
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                IChange _insertLineAbove = ChangeProvider.insertLineAbove(context.getXtextDocument(), offset, "@" + OVERRIDE_ANNOTATION, true);
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_insertLineAbove}));
            }
        };
        this.accept(acceptor, issue, "Add @Override", "Add missing @Override annotation.", "annotation_add.png", _function);
    }

    @Fix(value="CLF_OVERRIDE_NON_EXISTENT")
    public void removeOverrideAnnotation(Issue issue, IssueResolutionAcceptor acceptor) {
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                if (element instanceof N4MethodDeclaration) {
                    Functions.Function1 _function = it -> {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)OVERRIDE_ANNOTATION);
                    };
                    IChange _removeSemanticObject = ChangeProvider.removeSemanticObject(context.getXtextDocument(), (EObject)IterableExtensions.findFirst((Iterable)((N4MethodDeclaration)element).getAnnotations(), (Functions.Function1)_function), true);
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_removeSemanticObject}));
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }
        };
        this.accept(acceptor, issue, "Remove @Override", "Remove unnecessary @Override annotation.", "annotation_remove.png", _function);
    }

    @Fix(value="SYN_MODIFIER_BAD_ORDER")
    public void orderModifiers(Issue issue, IssueResolutionAcceptor acceptor) {
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                if (element instanceof ModifiableElement) {
                    String modifierStr = IterableExtensions.join((Iterable)ModifierUtils.getSortedModifiers((Collection)((ModifiableElement)element).getDeclaredModifiers()), (CharSequence)" ");
                    IChange _replace = ChangeProvider.replace(context.getXtextDocument(), offset, length, modifierStr);
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_replace}));
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }
        };
        this.accept(acceptor, issue, "Order modifiers", "Rearrange the modifiers to make them appear in correct order.", "reorder.gif", _function);
    }

    @Fix(value="org.eclipse.xtext.diagnostics.Diagnostic.Linking")
    public void addImportForUnresolvedReference(Issue issue, IssueResolutionAcceptor acceptor) {
        boolean _startsWith = issue.getMessage().startsWith("Couldn't resolve reference to ");
        if (_startsWith) {
            List<ICompletionProposal> proposals = this._importUtil.findImportCandidates(issue, false);
            for (ICompletionProposal currProp : proposals) {
                String _displayString = currProp.getDisplayString();
                String _plus = "Import " + _displayString;
                this.accept(acceptor, issue, _plus, "Add import declaration for the element.", "import_obj.gif", currProp);
            }
        }
    }

    @Fix(value="CLF_ABSTRACT_BODY")
    public void removeAbstractAnnotationFromMethodWithBody(Issue issue, IssueResolutionAcceptor acceptor) {
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                if (element instanceof N4MethodDeclaration) {
                    IChange _removeModifier = N4JSQuickfixProvider.this._semanticChangeProvider.removeModifier(context.getXtextDocument(), (ModifiableElement)element, N4Modifier.ABSTRACT);
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_removeModifier}));
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }
        };
        this.accept(acceptor, issue, "Remove abstract annotation", "", "annotation_remove.png", _function);
    }

    @Fix(value="CLF_ABSTRACT_MISSING")
    public void declareClassWithAbstractMethodAsAbstract(Issue issue, IssueResolutionAcceptor acceptor) {
        this.accept(acceptor, issue, "Declare class as abstract", "", "annotation_add.png", new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                EObject containingClass;
                if (element instanceof N4MemberDeclaration && (containingClass = ((N4MemberDeclaration)element).eContainer()) instanceof N4ClassDeclaration) {
                    IChange _addModifier = N4JSQuickfixProvider.this._semanticChangeProvider.addModifier(context.getXtextDocument(), (ModifiableElement)containingClass, N4Modifier.ABSTRACT);
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_addModifier}));
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }

            @Override
            public boolean supportsMultiApply() {
                return false;
            }
        });
    }

    @Fix(value="CLF_MISSING_IMPLEMENTATION")
    public void declareClassNotImplementingAbstractMethodAsAbstract(Issue issue, IssueResolutionAcceptor acceptor) {
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                if (element instanceof N4ClassDeclaration) {
                    IChange _addModifier = N4JSQuickfixProvider.this._semanticChangeProvider.addModifier(context.getXtextDocument(), (ModifiableElement)element, N4Modifier.ABSTRACT);
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_addModifier}));
                }
                return null;
            }
        };
        this.accept(acceptor, issue, "Declare class as abstract", "", null, _function);
    }

    @Fix(value="CLF_MISSING_BODY")
    public void declareMemberWithoutBodyAsAbstract(Issue issue, IssueResolutionAcceptor acceptor) {
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                if (element instanceof N4MethodDeclaration) {
                    IChange _addModifier = N4JSQuickfixProvider.this._semanticChangeProvider.addModifier(context.getXtextDocument(), (ModifiableElement)element, N4Modifier.ABSTRACT);
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_addModifier}));
                }
                if (element instanceof N4FieldAccessor) {
                    IChange _addModifier_1 = N4JSQuickfixProvider.this._semanticChangeProvider.addModifier(context.getXtextDocument(), (ModifiableElement)element, N4Modifier.ABSTRACT);
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_addModifier_1}));
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }
        };
        this.accept(acceptor, issue, "Declare member as abstract", "", null, _function);
    }

    @Fix(value="VIS_ILLEGAL_MEMBER_ACCESS")
    public void changeAccessModifierOfMemberDeclaration(Issue issue, IssueResolutionAcceptor acceptor) {
        boolean _not;
        String declarationURI = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.scoping.accessModifiers.InvisibleMemberDescription.declarationObjectUri");
        String accessorSuggestion = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.scoping.accessModifiers.InvisibleMemberDescription.accessModifierSuggestion");
        if (declarationURI == null || accessorSuggestion == null) {
            return;
        }
        boolean _isContainingResourceModifiable = QuickfixUtil.isContainingResourceModifiable(declarationURI);
        boolean bl = _not = !_isContainingResourceModifiable;
        if (_not) {
            return;
        }
        final N4Modifier fixModifier = QuickfixUtil.modifierForSuggestion(accessorSuggestion);
        final boolean fixAddInternal = QuickfixUtil.modifierSuggestionIsInternal(accessorSuggestion);
        String _readableStringForSuggestion = QuickfixUtil.readableStringForSuggestion(accessorSuggestion);
        String quickFixLabel = "Declare member as " + _readableStringForSuggestion;
        this.accept(acceptor, issue, quickFixLabel, "", null, new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                IdentifiableElement propertyDeclaration;
                if (element instanceof ParameterizedPropertyAccessExpression && ((propertyDeclaration = ((ParameterizedPropertyAccessExpression)element).getProperty()) instanceof Type || propertyDeclaration instanceof TMember) && propertyDeclaration instanceof SyntaxRelatedTElement && propertyDeclaration instanceof TAnnotableElement) {
                    IXtextDocument doc = context.getXtextDocument(propertyDeclaration.eResource().getURI());
                    EObject astElement = ((SyntaxRelatedTElement)propertyDeclaration).getAstElement();
                    if (astElement instanceof N4MemberDeclaration) {
                        ArrayList<IChange> changes = new ArrayList<IChange>();
                        changes.add(N4JSQuickfixProvider.this._semanticChangeProvider.setAccessModifiers(doc, (ModifiableElement)astElement, fixModifier));
                        if (fixAddInternal) {
                            changes.add(N4JSQuickfixProvider.this._semanticChangeProvider.addAnnotation(doc, (AnnotableElement)astElement, INTERNAL_ANNOTATION));
                        } else {
                            changes.add(N4JSQuickfixProvider.this._semanticChangeProvider.removeAnnotation(doc, (AnnotableElement)astElement, INTERNAL_ANNOTATION));
                        }
                        return changes;
                    }
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }

            @Override
            public boolean supportsMultiApply() {
                return false;
            }
        });
    }

    @Fix(value="VIS_ILLEGAL_TYPE_ACCESS")
    public void changeAccessModifierOfTypeDeclaration(Issue issue, IssueResolutionAcceptor acceptor) {
        boolean _not;
        String accessModifierSuggestion = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.scoping.accessModifiers.InvisibleTypeOrVariableDescription.accessModifierSuggestion");
        final String declarationObjectUri = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.scoping.accessModifiers.InvisibleTypeOrVariableDescription.declarationObjectUri");
        if (accessModifierSuggestion == null || declarationObjectUri == null) {
            return;
        }
        boolean _isContainingResourceModifiable = QuickfixUtil.isContainingResourceModifiable(declarationObjectUri);
        boolean bl = _not = !_isContainingResourceModifiable;
        if (_not) {
            return;
        }
        TopLevelVisibilityFixProvider.TopLevelVisibilityFix fix = null;
        try {
            fix = this.topLevelVisibilityFixProvider.provideFixFor("type", accessModifierSuggestion);
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                return;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        final TopLevelVisibilityFixProvider.TopLevelVisibilityFix finalFix = fix;
        String _description = fix.getDescription();
        this.accept(acceptor, issue, _description, "", null, new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                IdentifiableElement typeDeclaration = null;
                if (element instanceof ParameterizedPropertyAccessExpression) {
                    typeDeclaration = ((ParameterizedPropertyAccessExpression)element).getProperty();
                } else if (element instanceof TypeRef) {
                    typeDeclaration = ((TypeRef)element).getDeclaredType();
                } else if (element instanceof NamedImportSpecifier) {
                    typeDeclaration = ((NamedImportSpecifier)element).getImportedElement();
                } else if (element instanceof IdentifierRef) {
                    typeDeclaration = ((IdentifierRef)element).getId();
                }
                if (typeDeclaration == null) {
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList());
                }
                if (typeDeclaration instanceof Type && typeDeclaration instanceof SyntaxRelatedTElement && typeDeclaration instanceof TAnnotableElement) {
                    EObject declarationAstElement = ((SyntaxRelatedTElement)typeDeclaration).getAstElement();
                    IXtextDocument doc = context.getXtextDocument(URI.createURI((String)declarationObjectUri));
                    return (Collection)Conversions.doWrapArray((Object)finalFix.changes(declarationAstElement, doc));
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }

            @Override
            public boolean supportsMultiApply() {
                return false;
            }
        });
    }

    @Fix(value="VIS_ILLEGAL_VARIABLE_ACCESS")
    public void changeAccessModifierOfVariableDeclaration(Issue issue, IssueResolutionAcceptor acceptor) {
        boolean _not;
        String accessModifierSuggestion = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.scoping.accessModifiers.InvisibleTypeOrVariableDescription.accessModifierSuggestion");
        final String declarationObjectURI = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.scoping.accessModifiers.InvisibleTypeOrVariableDescription.declarationObjectUri");
        if (accessModifierSuggestion == null || declarationObjectURI == null) {
            return;
        }
        boolean _isContainingResourceModifiable = QuickfixUtil.isContainingResourceModifiable(declarationObjectURI);
        boolean bl = _not = !_isContainingResourceModifiable;
        if (_not) {
            return;
        }
        TopLevelVisibilityFixProvider.TopLevelVisibilityFix fix = null;
        try {
            fix = this.topLevelVisibilityFixProvider.provideFixFor("variable", accessModifierSuggestion);
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                return;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        final TopLevelVisibilityFixProvider.TopLevelVisibilityFix finalFix = fix;
        String _description = fix.getDescription();
        this.accept(acceptor, issue, _description, "", null, new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                TExportableElement _importedElement;
                IdentifiableElement variableDeclaration = null;
                if (element instanceof IdentifierRef) {
                    variableDeclaration = ((IdentifierRef)element).getId();
                } else if (element instanceof ParameterizedPropertyAccessExpression) {
                    variableDeclaration = ((ParameterizedPropertyAccessExpression)element).getProperty();
                } else if (element instanceof NamedImportSpecifier && (_importedElement = ((NamedImportSpecifier)element).getImportedElement()) instanceof TVariable) {
                    variableDeclaration = ((NamedImportSpecifier)element).getImportedElement();
                }
                if (variableDeclaration == null) {
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList());
                }
                if (variableDeclaration instanceof TVariable) {
                    EObject variableNode = ((TVariable)variableDeclaration).getAstElement();
                    IXtextDocument doc = context.getXtextDocument(URI.createURI((String)declarationObjectURI));
                    if (variableNode instanceof ExportedVariableDeclaration) {
                        EObject statement = ((ExportedVariableDeclaration)variableNode).eContainer();
                        return (Collection)Conversions.doWrapArray((Object)finalFix.changes(statement, doc));
                    }
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }

            @Override
            public boolean supportsMultiApply() {
                return false;
            }
        });
    }

    @Fix(value="VIS_ILLEGAL_FUN_ACCESS")
    public void changeAccessModifierOfFunctionDeclaration(Issue issue, IssueResolutionAcceptor acceptor) {
        boolean _not;
        String accessModifierSuggestion = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.scoping.accessModifiers.InvisibleTypeOrVariableDescription.accessModifierSuggestion");
        final String declarationObjectUri = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.scoping.accessModifiers.InvisibleTypeOrVariableDescription.declarationObjectUri");
        if (accessModifierSuggestion == null || declarationObjectUri == null) {
            return;
        }
        boolean _isContainingResourceModifiable = QuickfixUtil.isContainingResourceModifiable(declarationObjectUri);
        boolean bl = _not = !_isContainingResourceModifiable;
        if (_not) {
            return;
        }
        TopLevelVisibilityFixProvider.TopLevelVisibilityFix fix = null;
        try {
            fix = this.topLevelVisibilityFixProvider.provideFixFor("function", accessModifierSuggestion);
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                return;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        final TopLevelVisibilityFixProvider.TopLevelVisibilityFix finalFix = fix;
        String _description = fix.getDescription();
        this.accept(acceptor, issue, _description, "", null, new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                IdentifiableElement functionImpl = null;
                if (element instanceof IdentifierRef) {
                    functionImpl = ((IdentifierRef)element).getId();
                } else if (element instanceof ParameterizedPropertyAccessExpression) {
                    functionImpl = ((ParameterizedPropertyAccessExpression)element).getProperty();
                } else if (element instanceof NamedImportSpecifier) {
                    functionImpl = ((NamedImportSpecifier)element).getImportedElement();
                }
                if (functionImpl == null) {
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList());
                }
                if (functionImpl instanceof TFunction) {
                    EObject functionAstElement = ((TFunction)functionImpl).getAstElement();
                    IXtextDocument doc = context.getXtextDocument(URI.createURI((String)declarationObjectUri));
                    return (Collection)Conversions.doWrapArray((Object)finalFix.changes(functionAstElement, doc));
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }

            @Override
            public boolean supportsMultiApply() {
                return false;
            }
        });
    }

    @Fix(value="CLF_OVERRIDE_VISIBILITY")
    public void changeOverriddenMemberAccessModifier(Issue issue, IssueResolutionAcceptor acceptor) {
        final String accessSuggestion = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.validation.validators.N4JSMemberRedefinitationValidator.overridden_member_modifier");
        String memberName = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.validation.validators.N4JSMemberRedefinitationValidator.overridden_member_name");
        String superClassName = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.validation.validators.N4JSMemberRedefinitationValidator.super_class_name");
        if (accessSuggestion == null || memberName == null || superClassName == null) {
            return;
        }
        String _readableStringForSuggestion = QuickfixUtil.readableStringForSuggestion(accessSuggestion);
        String _plus = "Set access modifier to \"" + _readableStringForSuggestion;
        String _plus_1 = String.valueOf(_plus) + "\" (align with ";
        String _plus_2 = String.valueOf(_plus_1) + superClassName;
        String _plus_3 = String.valueOf(_plus_2) + ".";
        String _plus_4 = String.valueOf(_plus_3) + memberName;
        String msg = String.valueOf(_plus_4) + ")";
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                if (element instanceof N4MemberDeclaration) {
                    ArrayList<IChange> changes = new ArrayList<IChange>();
                    changes.add(N4JSQuickfixProvider.this._semanticChangeProvider.setAccessModifiers(context.getXtextDocument(), (ModifiableElement)element, QuickfixUtil.modifierForSuggestion(accessSuggestion)));
                    boolean _modifierSuggestionIsInternal = QuickfixUtil.modifierSuggestionIsInternal(accessSuggestion);
                    if (_modifierSuggestionIsInternal) {
                        changes.add(N4JSQuickfixProvider.this._semanticChangeProvider.addAnnotation(context.getXtextDocument(), (AnnotableElement)element, INTERNAL_ANNOTATION));
                    } else {
                        changes.add(N4JSQuickfixProvider.this._semanticChangeProvider.removeAnnotation(context.getXtextDocument(), (AnnotableElement)element, INTERNAL_ANNOTATION));
                    }
                    return changes;
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }
        };
        this.accept(acceptor, issue, msg, "", null, _function);
    }

    @Fix(value="CLF_NOT_EXPORTED_NOT_PRIVATE")
    public void markElementAsExported(Issue issue, IssueResolutionAcceptor acceptor) {
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                if (N4JSQuickfixProvider.this.jsVariantHelper.isExternalMode(element) && element instanceof ModifiableElement) {
                    IChange _addCustomModifier = N4JSQuickfixProvider.this._semanticChangeProvider.addCustomModifier(context.getXtextDocument(), (ModifiableElement)element, "export external");
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_addCustomModifier}));
                }
                if (element instanceof ModifiableElement) {
                    IChange _addCustomModifier_1 = N4JSQuickfixProvider.this._semanticChangeProvider.addCustomModifier(context.getXtextDocument(), (ModifiableElement)element, "export");
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_addCustomModifier_1}));
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }
        };
        this.accept(acceptor, issue, "Declare element as exported", "", null, _function);
    }

    @Fix(value="CLF_EXTEND_FINAL")
    public void unmarkSuperTypeAsFinal(Issue issue, IssueResolutionAcceptor acceptor) {
        boolean _not;
        final String superTypeDeclarationUri = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.validation.validators.N4JSClassValidator.super_type_declaration_uri");
        if (superTypeDeclarationUri == null) {
            return;
        }
        boolean _isContainingResourceModifiable = QuickfixUtil.isContainingResourceModifiable(superTypeDeclarationUri);
        boolean bl = _not = !_isContainingResourceModifiable;
        if (_not) {
            return;
        }
        this.accept(acceptor, issue, "Remove @Final annotation from super type", "", null, new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                if (element instanceof ParameterizedTypeRef) {
                    EObject astDeclaration;
                    Type superClassDeclaration = ((ParameterizedTypeRef)element).getDeclaredType();
                    if (superClassDeclaration instanceof TClassifier && (astDeclaration = ((TClassifier)superClassDeclaration).getAstElement()) instanceof N4ClassifierDeclaration) {
                        IXtextDocument doc = context.getXtextDocument(URI.createURI((String)superTypeDeclarationUri));
                        IChange _removeAnnotation = N4JSQuickfixProvider.this._semanticChangeProvider.removeAnnotation(doc, (AnnotableElement)astDeclaration, FINAL_ANNOTATION);
                        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_removeAnnotation}));
                    }
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList());
                }
                return null;
            }

            @Override
            public boolean supportsMultiApply() {
                return false;
            }
        });
    }

    @Fix(value="CLF_OVERRIDE_FINAL")
    public void removeFinalAnnotationFromMember(Issue issue, IssueResolutionAcceptor acceptor) {
        boolean _not;
        final String overriddenMemberDeclarationUri = this._issueUserDataKeysExtension.getUserData(issue, "org.eclipse.n4js.validation.validators.N4JSMemberRedefinitionValidator.overridden_member_uri");
        if (overriddenMemberDeclarationUri == null) {
            return;
        }
        boolean _isContainingResourceModifiable = QuickfixUtil.isContainingResourceModifiable(overriddenMemberDeclarationUri);
        boolean bl = _not = !_isContainingResourceModifiable;
        if (_not) {
            return;
        }
        this.accept(acceptor, issue, "Remove @Final annotation from overridden member", "", null, new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                EObject astMemberDeclaration;
                Resource resource = element.eResource();
                EObject overriddenMemberDeclaration = QuickfixUtil.getEObjectForUri(resource.getResourceSet(), overriddenMemberDeclarationUri);
                if (overriddenMemberDeclaration == null) {
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList());
                }
                if (overriddenMemberDeclaration instanceof SyntaxRelatedTElement && (astMemberDeclaration = ((SyntaxRelatedTElement)overriddenMemberDeclaration).getAstElement()) instanceof N4MemberDeclaration) {
                    IXtextDocument doc = context.getXtextDocument(URI.createURI((String)overriddenMemberDeclarationUri));
                    IChange _removeAnnotation = N4JSQuickfixProvider.this._semanticChangeProvider.removeAnnotation(doc, (AnnotableElement)astMemberDeclaration, FINAL_ANNOTATION);
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_removeAnnotation}));
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }

            @Override
            public boolean supportsMultiApply() {
                return false;
            }
        });
    }

    @Fix(value="NON_EXISTING_PROJECT")
    public void tryInstallMissingDependencyFromNpm(final Issue issue, IssueResolutionAcceptor acceptor) {
        abstract class __N4JSQuickfixProvider_9
        extends N4Modification {
            boolean multipleInvocations;

            __N4JSQuickfixProvider_9() {
            }

            public abstract Collection<? extends IChange> invokeLibraryManager(EObject var1) throws Exception;
        }
        __N4JSQuickfixProvider_9 modification = new __N4JSQuickfixProvider_9(this){
            {
            }

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                return this.invokeLibraryManager(element);
            }

            @Override
            public Collection<? extends IChange> computeOneOfMultipleChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                return this.invokeLibraryManager(element);
            }

            @Override
            public void computeFinalChanges() throws Exception {
                if (this.multipleInvocations) {
                    Shell _shell = UIUtils.getShell();
                    IRunnableWithProgress _function = monitor -> {
                        block2: {
                            try {
                                ResourcesPlugin.getWorkspace().build(15, monitor);
                            }
                            catch (Throwable _t) {
                                if (_t instanceof IllegalBinaryStateException || _t instanceof CoreException) break block2;
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                        }
                    };
                    new ProgressMonitorDialog(_shell).run(true, true, _function);
                }
            }

            @Override
            public Collection<? extends IChange> invokeLibraryManager(EObject element) throws Exception {
                boolean _tripleNotEquals;
                ProjectReference dependency = (ProjectReference)element;
                String packageName = dependency.getProjectName();
                NPMVersionRequirement _xifexpression = null;
                _xifexpression = dependency instanceof ProjectDependency ? ((ProjectDependency)dependency).getVersionRequirement() : SemverUtils.createEmptyVersionRequirement();
                NPMVersionRequirement packageVersion = _xifexpression;
                AtomicReference illegalBinaryExcRef = new AtomicReference();
                MultiStatus multiStatus = _statusHelper.createMultiStatus("Installing npm package '" + packageName + "'.");
                Shell _shell = UIUtils.getShell();
                IRunnableWithProgress _function = monitor -> {
                    try {
                        Map<String, NPMVersionRequirement> package_ = Collections.singletonMap(packageName, packageVersion);
                        multiStatus.merge(libraryManager.installNPMs(package_, false, issue.getUriToProblem(), monitor));
                    }
                    catch (Throwable _t) {
                        if (_t instanceof IllegalBinaryStateException) {
                            IllegalBinaryStateException e = (IllegalBinaryStateException)_t;
                            illegalBinaryExcRef.set(e);
                        }
                        if (_t instanceof Exception) {
                            Exception e_1 = (Exception)_t;
                            String msg = "Error while uninstalling npm package: '" + packageName + "'.";
                            multiStatus.merge(_statusHelper.createError(msg, (Throwable)e_1));
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                };
                new ProgressMonitorDialog(_shell).run(true, false, _function);
                IllegalBinaryStateException _get = (IllegalBinaryStateException)illegalBinaryExcRef.get();
                boolean bl = _tripleNotEquals = _get != null;
                if (_tripleNotEquals) {
                    IllegalBinaryStateException _get_1 = (IllegalBinaryStateException)illegalBinaryExcRef.get();
                    new IllegalBinaryStateDialog(_get_1).open();
                } else {
                    boolean _not;
                    boolean _isOK = multiStatus.isOK();
                    boolean bl2 = _not = !_isOK;
                    if (_not) {
                        N4JSActivator.getInstance().getLog().log((IStatus)multiStatus);
                        Runnable _function_1 = () -> {
                            String title = "NPM Install Failed";
                            String descr = StatusUtils.getErrorMessage((IStatus)multiStatus, (boolean)true);
                            ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Install Failed", (String)descr, (IStatus)multiStatus);
                        };
                        UIUtils.getDisplay().asyncExec(_function_1);
                    }
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }
        };
        this.accept(acceptor, issue, "Install npm package to workspace", "Download and install missing dependency from npm.", null, modification);
    }

    @Fix(value="IDL_VERSIONED_ELEMENT_MISSING_VERSION")
    public void addVersionAwareAnnotation(Issue issue, IssueResolutionAcceptor acceptor) {
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                IChange _insertLineAbove = ChangeProvider.insertLineAbove(context.getXtextDocument(), offset, "@" + AnnotationDefinition.VERSION_AWARE.name, true);
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_insertLineAbove}));
            }
        };
        this.accept(acceptor, issue, "Declare this type as @VersionAware", "Add @VersionAware annotation.", "annotation_add.png", _function);
    }

    @Fix(value="TEMP_DEPRECATED_OLD_ARRAY_SYNTAX")
    public void convertToNewArraySyntax(Issue issue, IssueResolutionAcceptor acceptor) {
        N4Modification _function = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                String old = context.getXtextDocument().get(offset, length).trim();
                if (old.startsWith("[") && old.endsWith("]")) {
                    int _length = old.length();
                    int _minus = _length - 1;
                    String _new = old.substring(1, _minus).trim();
                    boolean _needsParentheses = N4JSQuickfixProvider.this.needsParentheses(element);
                    if (_needsParentheses) {
                        _new = "(" + _new + ")";
                    }
                    String __new = _new;
                    _new = String.valueOf(__new) + "[]";
                    IChange _replace = ChangeProvider.replace(context.getXtextDocument(), offset, length, _new);
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IChange[]{_replace}));
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList());
            }
        };
        this.accept(acceptor, issue, "Convert to new array syntax", "The short-hand syntax for array types has changed. This will convert to the new syntax.", "reorder.gif", _function);
    }

    private boolean needsParentheses(EObject element) {
        if (element instanceof ParameterizedTypeRef) {
            TypeArgument typeArg = (TypeArgument)IterableExtensions.head((Iterable)((ParameterizedTypeRef)element).getTypeArgs());
            if (typeArg instanceof ComposedTypeRef) {
                return true;
            }
            if (typeArg instanceof Wildcard && (((Wildcard)typeArg).getDeclaredLowerBound() != null || ((Wildcard)typeArg).getDeclaredUpperBound() != null)) {
                return true;
            }
        }
        return false;
    }
}

