/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.FlowEdge;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public abstract class BranchWalker
extends BranchWalkerInternal {
    private Node lastRN;
    Set<ControlFlowType> pEdgeTypes = new HashSet<ControlFlowType>();

    @Override
    protected final void visit(Node node) {
        if (node instanceof RepresentingNode) {
            this.lastRN = node;
            ControlFlowElement cfe = node.getRepresentedControlFlowElement();
            this.visit(cfe);
            return;
        }
        if (this.getContainer() == node.getControlFlowElement()) {
            ControlFlowElement cfe = node.getControlFlowElement();
            if (this.lastRN == null) {
                this.enterContainer(cfe);
            } else {
                this.exitContainer(cfe);
            }
            this.lastRN = node;
        }
    }

    @Override
    protected final void visit(Node start, Node end, ControlFlowEdge edge) {
        this.pEdgeTypes.add(edge.cfType);
        if (end instanceof RepresentingNode || this.getContainer() == end.getControlFlowElement()) {
            ControlFlowElement endCFE = end.getRepresentedControlFlowElement();
            ControlFlowElement controlFlowElement = endCFE = endCFE == null ? end.getControlFlowElement() : endCFE;
            if (this.lastRN != null) {
                ControlFlowElement startCFE = this.lastRN.getRepresentedControlFlowElement();
                startCFE = startCFE == null ? this.lastRN.getControlFlowElement() : startCFE;
                FlowEdge flowEdge = new FlowEdge(startCFE, endCFE, this.pEdgeTypes);
                this.visit(flowEdge);
                this.pEdgeTypes.clear();
            } else {
                HashSet<EdgeInfo> edgeInfos = new HashSet<EdgeInfo>();
                BranchWalker.addPredecedingRepNodes(this, edgeInfos, new EdgeInfo(this));
                for (EdgeInfo edgeInfo : edgeInfos) {
                    ControlFlowElement startCFE = edgeInfo.startNode.getRepresentedControlFlowElement();
                    startCFE = startCFE == null ? edgeInfo.startNode.getControlFlowElement() : startCFE;
                    FlowEdge flowEdge = new FlowEdge(startCFE, endCFE, edgeInfo.pEdgeTypes);
                    edgeInfo.edgeOwner.visit(flowEdge);
                }
                this.pEdgeTypes.clear();
            }
        }
    }

    static void addPredecedingRepNodes(BranchWalker bw, HashSet<EdgeInfo> edgeInfos, EdgeInfo incompleteInfo) {
        if (bw.lastRN != null) {
            incompleteInfo.startNode = bw.lastRN;
            if (incompleteInfo.edgeOwner == null) {
                incompleteInfo.edgeOwner = bw;
            }
            edgeInfos.add(incompleteInfo);
        } else {
            for (BranchWalkerInternal predBWI : bw.getPathPredecessors()) {
                boolean omitUpdate;
                BranchWalker predBW = (BranchWalker)predBWI;
                EdgeInfo incompleteInfoCpy = new EdgeInfo(incompleteInfo);
                boolean bl = omitUpdate = !predBW.isDeadCodeBranch() && bw.isDeadCodeBranch();
                if (!omitUpdate) {
                    incompleteInfoCpy.update(predBW);
                }
                BranchWalker.addPredecedingRepNodes(predBW, edgeInfos, incompleteInfoCpy);
            }
        }
    }

    protected void enterContainer(ControlFlowElement cfContainer) {
    }

    protected void exitContainer(ControlFlowElement cfContainer) {
    }

    protected void visit(ControlFlowElement cfe) {
    }

    protected void visit(FlowEdge edge) {
    }

    protected abstract BranchWalker forkPath();

    @Override
    protected final BranchWalker fork() {
        BranchWalker forkedPath = this.forkPath();
        if (forkedPath != null) {
            forkedPath.lastRN = this.lastRN;
            forkedPath.pEdgeTypes.addAll(this.pEdgeTypes);
        }
        return forkedPath;
    }

    public final List<BranchWalker> getPredecessors() {
        return this.getPathPredecessors();
    }

    public final List<BranchWalker> getSuccessors() {
        return this.getPathSuccessors();
    }

    static class EdgeInfo {
        Node startNode = null;
        boolean isDead = false;
        Set<ControlFlowType> pEdgeTypes = new HashSet<ControlFlowType>();
        BranchWalker edgeOwner = null;

        EdgeInfo(BranchWalker bw) {
            this.update(bw);
        }

        EdgeInfo(EdgeInfo edgeInfo) {
            this.startNode = edgeInfo.startNode;
            this.isDead = edgeInfo.isDead;
            this.edgeOwner = edgeInfo.edgeOwner;
            this.pEdgeTypes.addAll(edgeInfo.pEdgeTypes);
        }

        EdgeInfo(EdgeInfo edgeInfo, RepresentingNode startNode) {
            this.startNode = startNode;
            this.isDead = edgeInfo.isDead;
            this.pEdgeTypes.addAll(edgeInfo.pEdgeTypes);
        }

        void update(BranchWalker bw) {
            this.pEdgeTypes.addAll(bw.pEdgeTypes);
            if (bw.pEdgeTypes.contains((Object)ControlFlowType.DeadCode)) {
                this.isDead = true;
                if (this.edgeOwner == null) {
                    this.edgeOwner = bw;
                }
            }
        }
    }
}

