/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;

public class SourceEntry {
    public final String property;
    public final String delimiter;
    public final String element;
    public final String module;
    public final String extension;
    public final String folder;
    public final boolean isStaticPolyfillAware;
    public final String trueFolder;
    public final String project;
    public final String path;
    public final String repository;
    public final int sourceLine;
    public final String packageName;
    public final String moduleName;
    public final int modulePackageCount;
    public final String[] adocPathElems;
    public final String adocPath;
    private String toString;

    SourceEntry(String repository, String path, String project, String folder, boolean isStaticPolyfillAware, String trueFolder, String module, String extension, String element, String delimiter, String property, String packageName, String moduleName, int sourceLine, int modulePackageCount, String[] fileNames, String fileName) {
        this.repository = repository;
        this.path = path;
        this.project = project;
        this.folder = folder;
        this.isStaticPolyfillAware = isStaticPolyfillAware;
        this.trueFolder = trueFolder;
        this.module = module;
        this.extension = extension;
        this.element = element;
        this.delimiter = delimiter;
        this.property = property;
        this.packageName = packageName;
        this.moduleName = moduleName;
        this.sourceLine = sourceLine;
        this.modulePackageCount = modulePackageCount;
        this.adocPathElems = fileNames;
        this.adocPath = fileName;
    }

    protected SourceEntry(SourceEntry se) {
        this.repository = se.repository;
        this.path = se.path;
        this.project = se.project;
        this.folder = se.folder;
        this.isStaticPolyfillAware = se.isStaticPolyfillAware;
        this.trueFolder = se.trueFolder;
        this.module = se.module;
        this.extension = se.extension;
        this.element = se.element;
        this.delimiter = se.delimiter;
        this.property = se.property;
        this.sourceLine = se.sourceLine;
        this.packageName = se.packageName;
        this.moduleName = se.moduleName;
        this.modulePackageCount = se.modulePackageCount;
        this.adocPathElems = se.adocPathElems;
        this.adocPath = se.adocPath;
    }

    public boolean hasProperty() {
        return !this.delimiter.isEmpty() && !this.property.isEmpty();
    }

    public String toPQN() {
        String s = this.repository;
        s = String.valueOf(s) + ":" + this.path;
        s = String.valueOf(s) + ":" + this.project;
        s = String.valueOf(s) + ":" + this.folder;
        s = String.valueOf(s) + "/" + this.module;
        s = String.valueOf(s) + ":" + this.element;
        s = String.valueOf(s) + this.delimiter;
        s = String.valueOf(s) + this.property;
        return s;
    }

    public String getAdocCompatibleAnchorID() {
        String id = this.module.replace("/", ".");
        id = String.valueOf(id) + "." + this.element;
        switch (this.delimiter) {
            case "#<": {
                id = String.valueOf(id) + ".getter.";
                break;
            }
            case "#>": {
                id = String.valueOf(id) + ".setter.";
                break;
            }
            case "@<": {
                id = String.valueOf(id) + ".static.getter.";
                break;
            }
            case "@>": {
                id = String.valueOf(id) + ".static.setter.";
                break;
            }
            case "#": {
                id = String.valueOf(id) + ".";
                break;
            }
            case "@": {
                id = String.valueOf(id) + ".static.";
            }
        }
        id = String.valueOf(id) + SourceEntry.getEscapedAdocAnchorString(this.property);
        return id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SourceEntry)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = this.repository;
            this.toString = String.valueOf(this.toString) + ":" + this.path;
            this.toString = String.valueOf(this.toString) + ":" + this.project;
            this.toString = String.valueOf(this.toString) + ":" + this.folder;
            if (!this.folder.equals(this.trueFolder)) {
                this.toString = String.valueOf(this.toString) + "(->" + this.trueFolder + ")";
            }
            this.toString = String.valueOf(this.toString) + ":" + this.module;
            this.toString = String.valueOf(this.toString) + ":" + this.element;
            this.toString = String.valueOf(this.toString) + this.delimiter;
            this.toString = String.valueOf(this.toString) + this.property;
            this.toString = String.valueOf(this.toString) + ":" + this.sourceLine;
        }
        return this.toString;
    }

    public static String getEscapedAdocAnchorString(String str) {
        String htmlEscaped = "";
        try {
            htmlEscaped = URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            htmlEscaped = "String.could.not.be.escaped";
        }
        String adocEscaped = htmlEscaped.replace("%", ":");
        return adocEscaped;
    }
}

