/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.utilities.Association;
import org.eclipse.wst.common.internal.emf.utilities.CloneablePublic;
import org.eclipse.wst.common.internal.emf.utilities.CopyGroup;
import org.eclipse.wst.common.internal.emf.utilities.DeferredReferenceUtilityAction;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopySession;

public class EtoolsCopyUtility {
    protected static final String REFENUMLITERAL_TYPE_NAME = "EEnumLiteral";
    private final EcorePackage pkg = EcorePackage.eINSTANCE;
    private final ETypedElement METAENAME = this.pkg.getENamedElement_Name();
    protected HashMap copiedObjects;
    protected List deferredReferenceCopies;
    protected boolean preserveIds = false;
    protected boolean copyAdapters = false;
    protected HashMap copiedAdapters;

    protected void addDeferredManyReferenceCopy(EReference reference, List aValue, String idSuffix, EObject aCopyContainer) {
        this.getDeferredReferenceCopies().add(new DeferredManyReferenceCopyAction(reference, aValue, idSuffix, aCopyContainer));
    }

    protected void addDeferredSingleReferenceCopy(EReference reference, EObject aValue, String idSuffix, EObject aCopyContainer) {
        this.getDeferredReferenceCopies().add(new DeferredSingleReferenceCopyAction(reference, aValue, idSuffix, aCopyContainer));
    }

    protected EObject containmentCopy(EObject anObject, String idSuffix) {
        EObject copied = this.getCopy(anObject);
        if (copied == null) {
            copied = this.primCopy(anObject, idSuffix);
        }
        return copied;
    }

    protected EObject containmentCopyObject(EObject anObject, String idSuffix) {
        EObject copied = this.getCopy(anObject);
        if (copied == null) {
            copied = this.primCopyObject(anObject, idSuffix);
        }
        return copied;
    }

    protected Resource containmentCopy(Resource aResource, String newUri) {
        return this.primCopy(aResource, newUri);
    }

    public void copy(CopyGroup aGroup) {
        if (aGroup != null) {
            EtoolsCopySession session = new EtoolsCopySession(this);
            session.setPreserveIds(aGroup.getPreserveIds());
            session.copy(aGroup);
            session.flush();
        }
    }

    public EObject copy(EObject aRefObject) {
        return this.copy(aRefObject, null);
    }

    public EObject copy(EObject aRefObject, String idSuffix) {
        EtoolsCopySession session = new EtoolsCopySession(this);
        EObject copied = session.copy(aRefObject, idSuffix);
        session.flush();
        return copied;
    }

    public EObject copyObject(EObject aRefObject, String idSuffix) {
        EtoolsCopySession session = new EtoolsCopySession(this);
        EObject copied = session.copyObject(aRefObject, idSuffix);
        session.flush();
        return copied;
    }

    public Resource copy(Resource aResource, String newUri) {
        EtoolsCopySession session = new EtoolsCopySession(this);
        Resource copied = session.copy(aResource, newUri);
        session.flush();
        return copied;
    }

    protected void copyAttribute(EAttribute attribute, EObject aRefObject, String idSuffix, EObject copyRef) {
        if (!attribute.isChangeable()) {
            return;
        }
        if (attribute.isMany()) {
            List value = (List)aRefObject.eGet((EStructuralFeature)attribute);
            if (value != null) {
                this.copyManyAttribute(attribute, value, aRefObject, idSuffix, copyRef);
            }
        } else if (aRefObject.eIsSet((EStructuralFeature)attribute)) {
            Object value = aRefObject.eGet((EStructuralFeature)attribute);
            if (value == null) {
                copyRef.eSet((EStructuralFeature)attribute, value);
            } else {
                this.copySingleAttribute(attribute, value, aRefObject, idSuffix, copyRef);
            }
        } else if (attribute == this.METAENAME) {
            copyRef.eSet((EStructuralFeature)attribute, aRefObject.eGet((EStructuralFeature)attribute));
        }
    }

    protected void copyCurrentAttributes(EObject aRefObject, String idSuffix, EObject copyRef) {
        EList attributes = aRefObject.eClass().getEAllAttributes();
        if (attributes != null) {
            for (EAttribute ra : attributes) {
                this.copyAttribute(ra, aRefObject, idSuffix, copyRef);
            }
        }
    }

    protected void copyCurrentReferences(EObject aRefObject, String idSuffix, EObject copyRef) {
        EList references = aRefObject.eClass().getEAllReferences();
        if (references != null) {
            for (EReference rr : references) {
                if (!this.shouldCopyReference(rr)) continue;
                this.copyReference(rr, aRefObject, idSuffix, copyRef);
            }
        }
    }

    protected void copyExtent(EList anExtent, EList copyExtent) {
        for (EObject refObject : anExtent) {
            copyExtent.add((Object)this.containmentCopy(refObject, null));
        }
    }

    protected void copyManyAttribute(EAttribute attribute, List aValue, EObject aRefObject, String idSuffix, EObject copyRef) {
        if (attribute.getEType() == null) {
            copyRef.eSet((EStructuralFeature)attribute, (Object)aValue);
        } else {
            List copyList = (List)copyRef.eGet((EStructuralFeature)attribute);
            for (Object next : aValue) {
                if (next instanceof EObject) {
                    copyList.add(this.containmentCopy((EObject)next, idSuffix));
                    continue;
                }
                copyList.add(next);
            }
        }
    }

    protected void copyManyReference(EReference aReference, List aList, EObject aRefObject, String idSuffix, EObject copyRef) {
        if (!aList.isEmpty()) {
            if (aReference.isContainment()) {
                List copyList = (List)copyRef.eGet((EStructuralFeature)aReference);
                for (EObject targetValue : aList) {
                    copyList.add(this.containmentCopy(targetValue, idSuffix));
                }
            } else {
                this.addDeferredManyReferenceCopy(aReference, aList, idSuffix, copyRef);
            }
        }
    }

    protected void copyReference(EReference aReference, EObject aRefObject, String idSuffix, EObject copyRef) {
        if (aReference.isMany()) {
            List value = (List)aRefObject.eGet((EStructuralFeature)aReference);
            if (value != null) {
                this.copyManyReference(aReference, value, aRefObject, idSuffix, copyRef);
            }
        } else if (aRefObject.eIsSet((EStructuralFeature)aReference)) {
            Object value = aRefObject.eGet((EStructuralFeature)aReference);
            this.copySingleReference(aReference, (EObject)value, aRefObject, idSuffix, copyRef);
        }
    }

    protected void copyRefObjects(CopyGroup aGroup) {
        if (aGroup.primGetRefObjects() != null) {
            for (Association association : aGroup.primGetRefObjects()) {
                EObject refObject = (EObject)association.getKey();
                String idSuffix = (String)association.getValue();
                if (idSuffix == null) {
                    idSuffix = aGroup.getDefaultIdSuffix();
                }
                aGroup.addCopied(this.containmentCopy(refObject, idSuffix));
            }
        }
    }

    protected void copyResources(CopyGroup aGroup) {
        if (aGroup.primGetResources() != null) {
            for (Association association : aGroup.primGetResources()) {
                Resource resource = (Resource)association.getKey();
                String uri = (String)association.getValue();
                Resource copied = this.containmentCopy(resource, uri);
                this.copyModificationFlag(resource, copied);
                aGroup.addCopied(copied);
            }
        }
    }

    protected void copySingleAttribute(EAttribute attribute, Object aValue, EObject aRefObject, String idSuffix, EObject copyRef) {
        if (attribute.getEType() == null) {
            copyRef.eSet((EStructuralFeature)attribute, aValue);
        } else if (attribute.getEType() instanceof EClass) {
            copyRef.eSet((EStructuralFeature)attribute, (Object)this.containmentCopy((EObject)aValue, idSuffix));
        } else {
            copyRef.eSet((EStructuralFeature)attribute, aValue);
        }
    }

    protected void copySingleReference(EReference aReference, EObject aValue, EObject aRefObject, String idSuffix, EObject copyRef) {
        if (aValue != aRefObject.eContainer() || aReference.getEOpposite() == null) {
            if (aReference.isContainment()) {
                copyRef.eSet((EStructuralFeature)aReference, (Object)this.containmentCopy(aValue, idSuffix));
            } else {
                this.addDeferredSingleReferenceCopy(aReference, aValue, idSuffix, copyRef);
            }
        }
    }

    public static void createCopy(CopyGroup aGroup) {
        EtoolsCopyUtility utility = new EtoolsCopyUtility();
        utility.copy(aGroup);
    }

    public static void createAttributeCopy(EObject aRefObject, EObject copyObject) {
        EtoolsCopyUtility utility = new EtoolsCopyUtility();
        utility.copyCurrentAttributes(aRefObject, null, copyObject);
    }

    public static EObject createCopy(EObject aRefObject) {
        return EtoolsCopyUtility.createCopy(aRefObject, null);
    }

    public static EObject createCopy(EObject aRefObject, String idSuffix) {
        EtoolsCopyUtility utility = new EtoolsCopyUtility();
        return utility.copy(aRefObject, idSuffix);
    }

    public static Resource createCopy(Resource aResource, String newUri) {
        EtoolsCopyUtility utility = new EtoolsCopyUtility();
        return utility.copy(aResource, newUri);
    }

    protected void executeDeferredCopyActions() {
        if (this.primGetDeferredReferenceCopies() != null) {
            for (DeferredReferenceUtilityAction action : this.primGetDeferredReferenceCopies()) {
                action.performAction();
            }
            this.primGetDeferredReferenceCopies().clear();
        }
    }

    protected HashMap getCopiedObjects() {
        if (this.copiedObjects == null) {
            this.copiedObjects = new HashMap(200);
        }
        return this.copiedObjects;
    }

    protected HashMap getCopiedAdapters() {
        if (this.copiedAdapters == null) {
            this.copiedAdapters = new HashMap(200);
        }
        return this.copiedAdapters;
    }

    public EObject getCopy(EObject anObject) {
        if (anObject == null) {
            return null;
        }
        return (EObject)this.getCopiedObjects().get(anObject);
    }

    public EObject getCopyIfFound(EObject anObject) {
        EObject copied = this.getCopy(anObject);
        return copied == null ? anObject : copied;
    }

    protected List getDeferredReferenceCopies() {
        if (this.deferredReferenceCopies == null) {
            this.deferredReferenceCopies = new ArrayList(100);
        }
        return this.deferredReferenceCopies;
    }

    public EObject newInstance(EObject aRefObject) {
        if (aRefObject == null) {
            return null;
        }
        EPackage epkg = (EPackage)aRefObject.eClass().eContainer();
        EFactory factory = epkg.getEFactoryInstance();
        EClass refObj = aRefObject.eClass();
        return factory.create(refObj);
    }

    public Resource newInstance(Resource aResource, String newUri) {
        if (aResource == null) {
            return null;
        }
        String innerNewUri = newUri;
        String originalUri = aResource.getURI().toString();
        innerNewUri = innerNewUri == null ? originalUri : innerNewUri;
        Resource.Factory factory = null;
        factory = aResource.getResourceSet() == null ? Resource.Factory.Registry.INSTANCE.getFactory(URI.createURI((String)originalUri)) : aResource.getResourceSet().getResourceFactoryRegistry().getFactory(URI.createURI((String)originalUri));
        Resource newResource = factory.createResource(URI.createURI((String)innerNewUri));
        return newResource;
    }

    public boolean preserveIds() {
        return this.preserveIds;
    }

    protected EObject primCopy(EObject aRefObject, String idSuffix) {
        if (aRefObject == null) {
            return null;
        }
        EObject copyRef = this.primCopyObject(aRefObject, idSuffix);
        this.copyCurrentReferences(aRefObject, idSuffix, copyRef);
        return copyRef;
    }

    protected EObject primCopyObject(EObject aRefObject, String idSuffix) {
        if (aRefObject == null) {
            return null;
        }
        EObject copyRef = this.newInstance(aRefObject);
        this.recordCopy(aRefObject, copyRef);
        this.copyCurrentAttributes(aRefObject, idSuffix, copyRef);
        if (this.isCopyAdapters()) {
            this.copyAdapters(aRefObject, copyRef);
        }
        return copyRef;
    }

    protected void copyAdapters(EObject aRefObject, EObject copyRef) {
        EList adapters = aRefObject.eAdapters();
        int i = 0;
        while (i < adapters.size()) {
            Adapter adapter = (Adapter)adapters.get(i);
            this.copyAdapter(aRefObject, copyRef, adapter);
            ++i;
        }
    }

    protected void copyAdapter(EObject aRefObject, EObject copyRef, Adapter adapter) {
        if (!(adapter instanceof CloneablePublic)) {
            return;
        }
        CloneablePublic copyAdapter = (CloneablePublic)this.getCopiedAdapters().get(adapter);
        if (copyAdapter == null) {
            copyAdapter = (CloneablePublic)((CloneablePublic)adapter).clone();
            this.getCopiedAdapters().put(adapter, copyAdapter);
        }
        if (copyAdapter != null) {
            copyRef.eAdapters().add((Object)copyAdapter);
        }
    }

    protected Resource primCopy(Resource aResource, String newUri) {
        if (aResource == null) {
            return null;
        }
        Resource copyResource = this.newInstance(aResource, newUri);
        this.copyExtent(aResource.getContents(), copyResource.getContents());
        return copyResource;
    }

    protected void copyModificationFlag(Resource aResource, Resource copied) {
        if (aResource.isModified()) {
            copied.setModified(true);
        }
    }

    private List primGetDeferredReferenceCopies() {
        return this.deferredReferenceCopies;
    }

    public void recordCopy(EObject aSource, EObject aCopy) {
        this.getCopiedObjects().put(aSource, aCopy);
    }

    public void recordCopy(Adapter aSource, Adapter aCopy) {
        this.getCopiedAdapters().put(aSource, aCopy);
    }

    public void setPreserveIds(boolean value) {
        this.preserveIds = value;
    }

    protected boolean shouldCopyReference(EReference aReference) {
        return aReference.isChangeable();
    }

    public boolean isCopyAdapters() {
        return this.copyAdapters;
    }

    public void setCopyAdapters(boolean b) {
        this.copyAdapters = b;
    }

    protected class DeferredManyReferenceCopyAction
    extends DeferredReferenceUtilityAction {
        public DeferredManyReferenceCopyAction(EReference aReference, List aValue, String aSuffix, EObject aCopyContainer) {
            super(aReference, aValue, aSuffix, aCopyContainer);
        }

        @Override
        public void performAction() {
            List copyList = (List)this.getCopyContainer().eGet((EStructuralFeature)this.getReference());
            for (EObject next : (List)this.getReferenceValue()) {
                copyList.add(EtoolsCopyUtility.this.getCopyIfFound(next));
            }
        }
    }

    protected class DeferredSingleReferenceCopyAction
    extends DeferredReferenceUtilityAction {
        public DeferredSingleReferenceCopyAction(EReference aReference, Object aValue, String aSuffix, EObject aCopyContainer) {
            super(aReference, aValue, aSuffix, aCopyContainer);
        }

        @Override
        public void performAction() {
            EObject value = (EObject)this.getReferenceValue();
            this.getCopyContainer().eSet((EStructuralFeature)this.getReference(), (Object)EtoolsCopyUtility.this.getCopyIfFound(value));
        }
    }
}

