/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Equivalence;
import java.util.Collection;
import org.eclipse.n4js.utils.DependencyCycle;
import org.eclipse.n4js.utils.RecursionGuard;

public class DependencyTraverser<T> {
    private final T rootNode;
    private final RecursionGuard<T> guard;
    private final RecursionGuard<T> pathGuard;
    private DependencyVisitor<T> visitor;
    private DependencyProvider<T> dependencyProvider;
    private DependencyCycle<T> firstDiscoveredCycle;
    private final boolean ignoreCycles;

    public DependencyTraverser(T rootNode, DependencyProvider<T> dependencyProvider, boolean ignoreCycles) {
        this(rootNode, Equivalence.equals(), DependencyTraverser.nopVisitor(), dependencyProvider, ignoreCycles);
    }

    public DependencyTraverser(T rootNode, DependencyVisitor<T> visitor, DependencyProvider<T> dependencyProvider, boolean ignoreCycles) {
        this(rootNode, Equivalence.equals(), visitor, dependencyProvider, ignoreCycles);
    }

    public DependencyTraverser(T rootNode, Equivalence<? super T> equivalence, DependencyVisitor<T> visitor, DependencyProvider<T> dependencyProvider, boolean ignoreCycles) {
        this.rootNode = rootNode;
        this.visitor = visitor;
        this.dependencyProvider = dependencyProvider;
        this.ignoreCycles = ignoreCycles;
        this.guard = new RecursionGuard<T>(equivalence);
        this.pathGuard = new RecursionGuard<T>(equivalence);
    }

    public DependencyCycle<T> findCycle() {
        this.firstDiscoveredCycle = null;
        this.traverse();
        if (this.firstDiscoveredCycle != null) {
            return this.firstDiscoveredCycle;
        }
        return DependencyCycle.noCycle();
    }

    public boolean traverse() {
        return this.doTraverse(this.rootNode);
    }

    private boolean doTraverse(T node) {
        if (node == null) {
            return false;
        }
        if (this.pathGuard.tryNext(node)) {
            if (this.guard.tryNext(node)) {
                this.visitor.accept(node);
                Collection<T> dependencies = this.dependencyProvider.getDependencies(node);
                if (dependencies != null) {
                    for (T dependency : dependencies) {
                        if (!this.doTraverse(dependency)) continue;
                        return true;
                    }
                }
            }
            this.pathGuard.done(node);
            return false;
        }
        if (this.firstDiscoveredCycle == null) {
            this.firstDiscoveredCycle = new DependencyCycle<T>(this.pathGuard.getElements(), node);
        }
        return !this.ignoreCycles;
    }

    private static <T> DependencyVisitor<T> nopVisitor() {
        return new DependencyVisitor<T>(){

            @Override
            public void accept(T node) {
            }
        };
    }

    @FunctionalInterface
    public static interface DependencyProvider<NodeT> {
        public Collection<? extends NodeT> getDependencies(NodeT var1);
    }

    @FunctionalInterface
    public static interface DependencyVisitor<NodeT> {
        public void accept(NodeT var1);
    }
}

