/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.utils;

import com.google.common.collect.LinkedHashMultimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.compare.ProjectCompareHelper;
import org.eclipse.n4js.compare.ProjectComparisonEntry;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.impl.TFieldImpl;
import org.eclipse.n4js.ts.types.impl.TGetterImpl;
import org.eclipse.n4js.ts.types.impl.TMethodImpl;
import org.eclipse.n4js.ts.types.impl.TSetterImpl;
import org.eclipse.n4js.ts.types.util.AccessorTuple;
import org.eclipse.n4js.ts.types.util.MemberList;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class ScriptApiTracker {
    private static Logger logger = Logger.getLogger(ScriptApiTracker.class);
    @Inject
    ProjectCompareHelper projectCompareHelper;

    public void initApiCompare(Script script) {
        if (!ScriptApiTracker.firstProjectComparisonAdapter(script.eResource()).isPresent()) {
            this.doApiCompare(script);
        }
    }

    public void doApiCompare(Script script) {
        ProjectComparisonAdapter projectComparisonAdapter = new ProjectComparisonAdapter(script.getModule());
        if (projectComparisonAdapter.hasOriginalCompareResult()) {
            if (script.eResource().eAdapters().stream().anyMatch(a -> a instanceof ProjectComparisonAdapter)) {
                IllegalStateException toThrow = new IllegalStateException("Already have a ProjectComparisonAdapter attached.");
                logger.warn((Object)toThrow.getMessage(), (Throwable)toThrow);
                throw toThrow;
            }
            script.eResource().eAdapters().add((Object)projectComparisonAdapter);
        }
    }

    public void cleanApiCompare(Script script) {
        script.eResource().eAdapters().removeIf(a -> a instanceof ProjectComparisonAdapter);
    }

    public static Optional<ProjectComparisonAdapter> firstProjectComparisonAdapter(Resource eResource) {
        if (eResource == null) {
            return Optional.empty();
        }
        return eResource.eAdapters().stream().filter(a -> a instanceof ProjectComparisonAdapter).map(a -> (ProjectComparisonAdapter)((Object)a)).findFirst();
    }

    public List<TMethod> computeMissingApiMethods(TClass type, EObject context) {
        ProjectComparisonEntry compareEntry;
        ProjectComparisonEntry typeCompare;
        Optional<ProjectComparisonAdapter> optAdapt = ScriptApiTracker.firstProjectComparisonAdapter(context.eResource());
        if (optAdapt.isPresent() && (typeCompare = (compareEntry = optAdapt.get().getEntryFor((TModule)EcoreUtil2.getContainerOfType((EObject)type, TModule.class))).getChildForElementImpl((EObject)type)) != null) {
            return typeCompare.allChildren().filter(pce -> pce.getElementAPI() instanceof TMethod).filter(pce -> pce.getElementImpl()[0] == null).map(pce -> {
                TMethod apiMethod = (TMethod)pce.getElementAPI();
                TMethod copy = (TMethod)TypeUtils.copyPartial((EObject)apiMethod, (EReference[])new EReference[]{TypesPackage.Literals.SYNTAX_RELATED_TELEMENT__AST_ELEMENT});
                VirtualApiTMethod ret = new VirtualApiTMethod(apiMethod.getName(), copy);
                return ret;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<TMethod> computeMissingApiMethods(TInterface type, EObject context) {
        Optional<ProjectComparisonAdapter> optAdapt = ScriptApiTracker.firstProjectComparisonAdapter(context.eResource());
        if (optAdapt.isPresent()) {
            ProjectComparisonAdapter projectComparisonAdapter = optAdapt.get();
            ProjectComparisonEntry compareEntry = projectComparisonAdapter.getEntryFor((TModule)EcoreUtil2.getContainerOfType((EObject)type, TModule.class));
            ProjectComparisonEntry typeCompare = compareEntry.getChildForElementImpl((EObject)type);
            if (typeCompare == null) {
                typeCompare = compareEntry.getChildForElementAPI((EObject)type);
            }
            if (typeCompare == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(" want to throw new IllegalstateException() --> comparison for implementation not found type=" + type.getTypeAsString() + " in Implementation " + compareEntry.getElementImpl()[0]));
                }
                return Collections.emptyList();
            }
            LinkedHashMultimap lhmmMehodInterface = LinkedHashMultimap.create();
            Predicate<ProjectComparisonEntry> filter = pce -> pce.getElementAPI() instanceof TMethod;
            filter = filter.and(pce -> pce.getElementImpl()[0] == null).and(pce -> AnnotationDefinition.PROVIDES_DEFAULT_IMPLEMENTATION.hasAnnotation((TAnnotableElement)((TMethod)pce.getElementAPI())));
            Function<TInterface, Consumer> actionProvider = pivot -> pce -> {
                TMethod method = (TMethod)pce.getElementAPI();
                lhmmMehodInterface.put((Object)method, pivot);
            };
            if (!this.checkInterfaceImplementsInterface(type, typeCompare.getElementAPI())) {
                return Collections.emptyList();
            }
            this.interfaceApiSupertypeWalker(filter, actionProvider, projectComparisonAdapter, (TInterface)typeCompare.getElementAPI(), TInterface.class);
            return lhmmMehodInterface.keySet().stream().map(m -> new VirtualApiTMethod(m.getName(), (TMethod)TypeUtils.copyPartial((EObject)m, (EReference[])new EReference[]{TypesPackage.Literals.SYNTAX_RELATED_TELEMENT__AST_ELEMENT}))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean checkInterfaceImplementsInterface(TInterface implType, EObject elementAPI) {
        if (elementAPI instanceof TInterface) {
            return true;
        }
        if (elementAPI != null && logger.isDebugEnabled()) {
            logger.debug((Object)("implementation uses interface to implement some API that is not an interface Impl=" + implType.getTypeAsString() + "  API=" + elementAPI));
        }
        return false;
    }

    public <T extends TClassifier> void interfaceApiSupertypeWalker(Predicate<? super ProjectComparisonEntry> filter, Function<T, Consumer<? super ProjectComparisonEntry>> actionProvider, ProjectComparisonAdapter projectComparisonAdapter, T apiElement, Class<T> castGuard) {
        if (apiElement == null) {
            return;
        }
        LinkedHashSet<T> toBeProcessedSuperInterfaces = new LinkedHashSet<T>();
        LinkedHashSet processedSuperInterfaces = new LinkedHashSet();
        toBeProcessedSuperInterfaces.add(apiElement);
        while (!toBeProcessedSuperInterfaces.isEmpty()) {
            Iterator iter = toBeProcessedSuperInterfaces.iterator();
            TClassifier pivot = (TClassifier)iter.next();
            iter.remove();
            if (TypeUtils.isBuiltIn((Type)pivot)) continue;
            this.includeAdditionsSuperInterfaces2(toBeProcessedSuperInterfaces, processedSuperInterfaces, pivot, castGuard);
            TModule superModule = pivot.getContainingModule();
            if (superModule != null) {
                ProjectComparisonEntry useCompareEntry = projectComparisonAdapter.getEntryFor(superModule);
                if (useCompareEntry == null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("No comparison found for pivot = " + pivot.getName()));
                    continue;
                }
                ProjectComparisonEntry superInterfaceCompareEntry = useCompareEntry.getChildForElementAPI((EObject)pivot);
                if (superInterfaceCompareEntry == null || !superInterfaceCompareEntry.hasChildren()) continue;
                superInterfaceCompareEntry.allChildren().filter(filter).forEach(actionProvider.apply(pivot));
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("-#- could not get module for super-classifier: " + pivot.getName() + " of type " + pivot.getTypeAsString() + " providedByRuntime=" + pivot.isProvidedByRuntime()));
        }
    }

    private <T extends TClassifier> void includeAdditionsSuperInterfaces2(LinkedHashSet<T> acceptor, LinkedHashSet<T> exclude, T pivot, Class<T> castGuard) {
        for (ParameterizedTypeRef superApiClassifier : pivot.getSuperClassifierRefs()) {
            Type superApiDeclaredType = superApiClassifier.getDeclaredType();
            if (castGuard.isAssignableFrom(superApiDeclaredType.getClass())) {
                TClassifier superInterface = (TClassifier)superApiClassifier.getDeclaredType();
                if (exclude.contains(superInterface)) continue;
                acceptor.add(superInterface);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Oopss ... Casting could not be performed Guard = " + castGuard.getName() + " DeclaredType of superApiClassifier '" + superApiDeclaredType.getClass().getName() + "' "));
        }
    }

    boolean isSameProject(TModule m1, TModule m2) {
        return m1 != null && m1.getProjectName().equals(m2.getProjectName()) && m1.getVendorID().equals(m2.getVendorID());
    }

    public List<VirtualApiTMethod> computeMethodDiff(TClass implType, ContainerTypesHelper.MemberCollector collector, List<TMember> ownedAndMixedInConcreteMember, MemberList<TMethod> missingApiMethods2) {
        ProjectComparisonEntry compareEntry;
        ProjectComparisonEntry typeCompare;
        Optional<ProjectComparisonAdapter> optAdapt = ScriptApiTracker.firstProjectComparisonAdapter(implType.eResource());
        if (optAdapt.isPresent() && (typeCompare = (compareEntry = optAdapt.get().getEntryFor((TModule)EcoreUtil2.getContainerOfType((EObject)implType, TModule.class))).getChildForElementImpl((EObject)implType)) != null && typeCompare.getElementAPI() != null) {
            TClass apiType = (TClass)typeCompare.getElementAPI();
            MemberList implMembers = collector.allMembers((ContainerType)implType, false, true);
            MemberList apiMembers = collector.allMembers((ContainerType)apiType, false, true);
            HashSet methodNamesAlreadyDefined = new HashSet();
            Stream.concat(implMembers.stream(), Stream.concat(ownedAndMixedInConcreteMember.stream(), missingApiMethods2.stream())).forEach(m -> {
                if (m instanceof TMethod) {
                    methodNamesAlreadyDefined.add(m.getName());
                }
            });
            return apiMembers.stream().filter(t -> t instanceof TMethod).filter(m -> !methodNamesAlreadyDefined.contains(((TMethod)m).getName())).map(m2 -> {
                TMethod m = (TMethod)m2;
                VirtualApiTMethod vMethod = new VirtualApiTMethod(m.getName(), (TMethod)TypeUtils.copyPartial((EObject)m, (EReference[])new EReference[]{TypesPackage.Literals.SYNTAX_RELATED_TELEMENT__AST_ELEMENT}));
                return vMethod;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<AccessorTuple> computeMissingApiFields(TN4Classifier declaration) {
        if (declaration instanceof TClass) {
            return this.computeMissingApiFields((TClass)declaration);
        }
        if (declaration instanceof TInterface) {
            return this.computeMissingApiFields((TInterface)declaration);
        }
        throw new IllegalStateException("Called for unhandled type.");
    }

    private List<AccessorTuple> computeMissingApiFields(TClass declaration) {
        ProjectComparisonEntry compareEntry;
        ProjectComparisonEntry typeCompare;
        Optional<ProjectComparisonAdapter> optAdapt = ScriptApiTracker.firstProjectComparisonAdapter(declaration.eResource());
        if (optAdapt.isPresent() && (typeCompare = (compareEntry = optAdapt.get().getEntryFor((TModule)EcoreUtil2.getContainerOfType((EObject)declaration, TModule.class))).getChildForElementImpl((EObject)declaration)) != null) {
            return typeCompare.allChildren().filter(pce -> pce.getElementAPI() instanceof TField).filter(pce -> pce.getElementImpl()[0] == null).map(pce -> {
                TField apiField = (TField)pce.getElementAPI();
                VirtualApiMissingFieldAccessorTuple ret = this.createVirtFieldAccessorTuple(apiField);
                return ret;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private VirtualApiMissingFieldAccessorTuple createVirtFieldAccessorTuple(TField apiField) {
        boolean statiC = apiField.isStatic();
        String name = apiField.getName();
        AccessorTuple copy = new AccessorTuple(name, statiC);
        TSetter tset = TypesFactory.eINSTANCE.createTSetter();
        tset.setName(name);
        tset.setDeclaredStatic(statiC);
        copy.setSetter(tset);
        TGetter tget = TypesFactory.eINSTANCE.createTGetter();
        tget.setName(name);
        tget.setDeclaredStatic(statiC);
        copy.setGetter(tget);
        VirtualApiMissingFieldAccessorTuple ret = new VirtualApiMissingFieldAccessorTuple(copy);
        ret.setGetter((TGetter)new VirtualApiTGetter(name, tget));
        ret.setSetter((TSetter)new VirtualApiTSetter(name, tset));
        return ret;
    }

    private List<AccessorTuple> computeMissingApiFields(TInterface declaration) {
        ProjectComparisonAdapter projectComparisonAdapter;
        ProjectComparisonEntry compareEntry;
        ProjectComparisonEntry typeCompare;
        Optional<ProjectComparisonAdapter> optAdapt = ScriptApiTracker.firstProjectComparisonAdapter(declaration.eResource());
        if (optAdapt.isPresent() && (typeCompare = (compareEntry = (projectComparisonAdapter = optAdapt.get()).getEntryFor((TModule)EcoreUtil2.getContainerOfType((EObject)declaration, TModule.class))).getChildForElementImpl((EObject)declaration)) != null) {
            ArrayList<AccessorTuple> collectedMissingFields = new ArrayList<AccessorTuple>();
            Predicate<ProjectComparisonEntry> filter = pce -> pce.getElementAPI() instanceof TField;
            filter = filter.and(pce -> pce.getElementImpl()[0] == null).and(pce -> AnnotationDefinition.PROVIDES_INITIALZER.hasAnnotation((TAnnotableElement)((TField)pce.getElementAPI())));
            Function<TInterface, Consumer> actionProvider = pivot -> pce -> {
                TField apiField = (TField)pce.getElementAPI();
                VirtualApiMissingFieldAccessorTuple ret = this.createVirtFieldAccessorTuple(apiField);
                collectedMissingFields.add(ret);
            };
            if (!this.checkInterfaceImplementsInterface(declaration, typeCompare.getElementAPI())) {
                return Collections.emptyList();
            }
            this.interfaceApiSupertypeWalker(filter, actionProvider, projectComparisonAdapter, (TInterface)typeCompare.getElementAPI(), TInterface.class);
            return collectedMissingFields;
        }
        return Collections.emptyList();
    }

    public List<AccessorTuple> computeMissingApiGetterSetter(TN4Classifier declaration, List<AccessorTuple> concreteAccessorTuples) {
        if (declaration instanceof TClass) {
            return this.computeMissingApiGetterSetter((TClass)declaration, concreteAccessorTuples);
        }
        if (declaration instanceof TInterface) {
            return this.computeMissingApiGetterSetter((TInterface)declaration, concreteAccessorTuples);
        }
        throw new IllegalStateException("Called for unhandled type.");
    }

    private List<AccessorTuple> computeMissingApiGetterSetter(TClass declaration, List<AccessorTuple> concreteAccessorTuples) {
        return this._computeMissingApiGetterSetter((TN4Classifier)declaration, concreteAccessorTuples, pce -> true, true);
    }

    private List<AccessorTuple> computeMissingApiGetterSetter(TInterface declaration, List<AccessorTuple> concreteAccessorTuples) {
        return this._computeMissingApiGetterSetter((TN4Classifier)declaration, concreteAccessorTuples, pce -> {
            TAnnotableElement ta = (TAnnotableElement)pce.getElementAPI();
            return AnnotationDefinition.PROVIDES_DEFAULT_IMPLEMENTATION.hasAnnotation(ta);
        }, true);
    }

    private List<AccessorTuple> _computeMissingApiGetterSetter(TN4Classifier declaration, List<AccessorTuple> concreteAccessorTuples, Predicate<ProjectComparisonEntry> filterPredicate, boolean recursive) {
        Optional<ProjectComparisonAdapter> optAdapt = ScriptApiTracker.firstProjectComparisonAdapter(declaration.eResource());
        if (optAdapt.isPresent()) {
            ProjectComparisonAdapter projectComparisonAdapter = optAdapt.get();
            ProjectComparisonEntry compareEntry = projectComparisonAdapter.getEntryFor((TModule)EcoreUtil2.getContainerOfType((EObject)declaration, TModule.class));
            ProjectComparisonEntry typeCompare = compareEntry.getChildForElementImpl((EObject)declaration);
            if (typeCompare == null) {
                return Collections.emptyList();
            }
            Predicate<ProjectComparisonEntry> filter = pce -> pce.getElementAPI() instanceof TGetter || pce.getElementAPI() instanceof TSetter;
            filter = filter.and(pce -> pce.getElementImpl()[0] == null).and(filterPredicate);
            ArrayList collectedPCEofGetterOrSetter = new ArrayList();
            Function<TN4Classifier, Consumer> actionProvider = pivot -> pce -> collectedPCEofGetterOrSetter.add(pce);
            if (recursive) {
                this.interfaceApiSupertypeWalker(filter, actionProvider, projectComparisonAdapter, (TN4Classifier)typeCompare.getElementAPI(), TN4Classifier.class);
            }
            List<Object> getSetList = recursive ? collectedPCEofGetterOrSetter : typeCompare.allChildren().filter(pce -> pce.getElementAPI() instanceof TGetter || pce.getElementAPI() instanceof TSetter).filter(filterPredicate).collect(Collectors.toList());
            HashMap<Pair, GetSetGroup> hmName2getset = new HashMap<Pair, GetSetGroup>();
            for (ProjectComparisonEntry pce2 : getSetList) {
                boolean staticCase;
                TMember apiAsMember = (TMember)pce2.getElementAPI();
                String name = apiAsMember.getName();
                Pair key = Pair.of((Object)name, (Object)(staticCase = apiAsMember.isStatic()));
                GetSetGroup group = (GetSetGroup)hmName2getset.get(key);
                if (group == null) {
                    group = new GetSetGroup(name, staticCase);
                    hmName2getset.put(key, group);
                }
                if (pce2.getElementAPI() instanceof TGetter) {
                    TGetter apiGetter = (TGetter)pce2.getElementAPI();
                    if (pce2.getElementImpl(0) != null) {
                        group.getterIsInAST = true;
                        continue;
                    }
                    group.getterIsInAST = false;
                    group.getter = new VirtualApiTGetter(name, apiGetter);
                    continue;
                }
                if (!(pce2.getElementAPI() instanceof TSetter)) continue;
                TSetter apiSetter = (TSetter)pce2.getElementAPI();
                if (pce2.getElementImpl(0) != null) {
                    group.setterIsInAST = true;
                    continue;
                }
                group.setterIsInAST = false;
                group.setter = new VirtualApiTSetter(name, apiSetter);
            }
            for (AccessorTuple conAccTupel : concreteAccessorTuples) {
                GetSetGroup getset = (GetSetGroup)hmName2getset.remove(Pair.of((Object)conAccTupel.getName(), (Object)conAccTupel.isStatic()));
                if (getset == null) continue;
                if (getset.hasGetter() && !getset.getterIsInAST && conAccTupel.getGetter() == null) {
                    conAccTupel.setGetter((TGetter)getset.getter);
                }
                if (!getset.hasSetter() || getset.setterIsInAST || conAccTupel.getSetter() != null) continue;
                conAccTupel.setSetter((TSetter)getset.setter);
            }
            ArrayList<AccessorTuple> ret = new ArrayList<AccessorTuple>();
            for (GetSetGroup getset : hmName2getset.values()) {
                VirtualApiAccessorTuple vAccessTupel = new VirtualApiAccessorTuple(getset.name, getset.staticCases);
                if (getset.getter != null) {
                    vAccessTupel.setGetter((TGetter)getset.getter);
                }
                if (getset.setter != null) {
                    vAccessTupel.setSetter((TSetter)getset.setter);
                }
                ret.add(vAccessTupel);
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public List<TField> computeMissingApiFields(N4InterfaceDeclaration declaration) {
        ProjectComparisonEntry compareEntry;
        ProjectComparisonEntry typeCompare;
        Optional<ProjectComparisonAdapter> optAdapt = ScriptApiTracker.firstProjectComparisonAdapter(declaration.eResource());
        if (optAdapt.isPresent() && (typeCompare = (compareEntry = optAdapt.get().getEntryFor((TModule)EcoreUtil2.getContainerOfType((EObject)declaration.getDefinedType(), TModule.class))).getChildForElementImpl((EObject)declaration.getDefinedTypeAsInterface())) != null) {
            return typeCompare.allChildren().filter(pce -> pce.getElementAPI() instanceof TField).filter(pce -> pce.getElementImpl()[0] == null).map(pce -> {
                TField apiMethod = (TField)pce.getElementAPI();
                TField copy = (TField)TypeUtils.copyPartial((EObject)apiMethod, (EReference[])new EReference[]{TypesPackage.Literals.SYNTAX_RELATED_TELEMENT__AST_ELEMENT});
                VirtualApiTField ret = new VirtualApiTField(apiMethod.getName(), copy);
                return ret;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static class GetSetGroup {
        final boolean staticCases;
        final String name;
        VirtualApiTGetter getter;
        VirtualApiTSetter setter;
        boolean getterIsInAST;
        boolean setterIsInAST;

        public GetSetGroup(String name, boolean staticCase) {
            this.name = name;
            this.staticCases = staticCase;
        }

        boolean hasGetter() {
            return this.getter != null;
        }

        boolean hasSetter() {
            return this.setter != null;
        }
    }

    public class ProjectComparisonAdapter
    extends AdapterImpl {
        private final HashMap<String, ProjectComparisonEntry> hmModuleToPCE;
        private final TModule tModule;
        private final String implementationID;

        public ProjectComparisonAdapter(TModule tModule) {
            this.tModule = tModule;
            this.hmModuleToPCE = new HashMap();
            this.implementationID = (String)ScriptApiTracker.this.projectCompareHelper.getImplementationID(tModule).orNull();
            this.getEntryFor(tModule);
        }

        public ProjectComparisonEntry getEntryFor(TModule module) {
            String qname = module.getQualifiedName();
            if (!this.hmModuleToPCE.containsKey(qname)) {
                ProjectComparisonEntry comparator = ScriptApiTracker.this.projectCompareHelper.compareModules(module, this.implementationID, true);
                this.hmModuleToPCE.put(qname, comparator);
            }
            ProjectComparisonEntry ret = this.hmModuleToPCE.get(qname);
            return ret;
        }

        public boolean hasOriginalCompareResult() {
            return this.implementationID != null && this.getEntryFor(this.tModule) != null;
        }
    }

    public static class VirtualApiAccessorTuple
    extends AccessorTuple {
        public VirtualApiAccessorTuple(String name, boolean isStatic) {
            super(name, isStatic);
        }
    }

    public static class VirtualApiMissingFieldAccessorTuple
    extends AccessorTuple {
        private final AccessorTuple apiRef;

        public AccessorTuple getApiRef() {
            return this.apiRef;
        }

        public VirtualApiMissingFieldAccessorTuple(AccessorTuple apiRef) {
            super(apiRef.getName(), apiRef.isStatic());
            this.apiRef = apiRef;
        }
    }

    public static class VirtualApiTField
    extends TFieldImpl {
        private final TField apiRef;

        public TField getApiRef() {
            return this.apiRef;
        }

        public VirtualApiTField(String name, TField apiRef) {
            this.name = name;
            this.apiRef = apiRef;
            this.declaredStatic = apiRef.isStatic();
        }
    }

    public static class VirtualApiTGetter
    extends TGetterImpl {
        private final TGetter apiGetter;

        public VirtualApiTGetter(String name, TGetter apiGetter) {
            this.name = name;
            this.apiGetter = apiGetter;
            this.declaredStatic = apiGetter.isStatic();
        }

        public TGetter getApiRef() {
            return this.apiGetter;
        }
    }

    public static class VirtualApiTMethod
    extends TMethodImpl {
        private final TMethod apiRef;

        public TMethod getApiRef() {
            return this.apiRef;
        }

        public VirtualApiTMethod(String name, TMethod apiRef) {
            this.name = name;
            this.apiRef = apiRef;
            this.declaredStatic = apiRef.isStatic();
        }
    }

    public static class VirtualApiTSetter
    extends TSetterImpl {
        private final TSetter apiSetter;

        public VirtualApiTSetter(String name, TSetter apiSetter) {
            this.name = name;
            this.apiSetter = apiSetter;
            this.declaredStatic = apiSetter.isStatic();
        }

        public TSetter getApiRef() {
            return this.apiSetter;
        }
    }
}

