/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.model;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;

public abstract class AbstractRefactoringDescriptorResourceMapping
extends ResourceMapping {
    private final RefactoringDescriptorProxy fDescriptor;
    private ResourceTraversal[] fResourceTraversals = null;

    protected AbstractRefactoringDescriptorResourceMapping(RefactoringDescriptorProxy descriptor) {
        Assert.isNotNull((Object)descriptor);
        this.fDescriptor = descriptor;
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractRefactoringDescriptorResourceMapping) {
            AbstractRefactoringDescriptorResourceMapping mapping = (AbstractRefactoringDescriptorResourceMapping)((Object)object);
            return mapping.fDescriptor.equals(this.fDescriptor);
        }
        return false;
    }

    public final Object getModelObject() {
        return this.fDescriptor;
    }

    public final IProject[] getProjects() {
        String project = this.fDescriptor.getProject();
        if (project != null && !"".equals(project)) {
            return new IProject[]{ResourcesPlugin.getWorkspace().getRoot().getProject(project)};
        }
        return new IProject[0];
    }

    public final IResource getResource() {
        try {
            IResource[] resources;
            ResourceTraversal[] traversals = this.getTraversals(null, null);
            if (traversals.length > 0 && (resources = traversals[0].getResources()).length > 0) {
                return resources[0];
            }
        }
        catch (CoreException exception) {
            RefactoringCorePlugin.log(exception);
        }
        return null;
    }

    public final ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        if (this.fResourceTraversals == null) {
            IProject[] projects;
            IPath path;
            this.fResourceTraversals = new ResourceTraversal[0];
            long stamp = this.fDescriptor.getTimeStamp();
            if (stamp >= 0L && (path = RefactoringHistoryManager.stampToPath(stamp)) != null && (projects = this.getProjects()) != null && projects.length == 1 && projects[0] != null) {
                IFolder folder = projects[0].getFolder(".refactorings").getFolder(path);
                this.fResourceTraversals = new ResourceTraversal[]{new ResourceTraversal(new IResource[]{folder.getFile("refactorings.history")}, 0, 0), new ResourceTraversal(new IResource[]{folder.getFile("refactorings.index")}, 0, 0)};
            }
        }
        ResourceTraversal[] traversals = new ResourceTraversal[this.fResourceTraversals.length];
        System.arraycopy(this.fResourceTraversals, 0, traversals, 0, this.fResourceTraversals.length);
        return traversals;
    }

    public int hashCode() {
        return this.fDescriptor.hashCode();
    }
}

