/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Strings;
import com.google.inject.Injector;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class N4ExecutableExtensionFactory
implements IExecutableExtensionFactory,
IExecutableExtension {
    private static final String GUICE_KEY = "guicekey";
    private String clazzName;
    private IConfigurationElement config;

    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.clazzName = (String)data;
        } else if (data instanceof Map) {
            this.clazzName = Objects.toString(((Map)data).get(GUICE_KEY));
        }
        if (this.clazzName == null) {
            throw new IllegalArgumentException("Couldn't handle passed data : " + data);
        }
        this.config = config;
    }

    public final Object create() throws CoreException {
        try {
            Class<?> clazz = this.getClassLoader().loadClass(this.clazzName);
            Injector injector = this.getInjector();
            Object result = injector.getInstance(clazz);
            if (result instanceof IExecutableExtension) {
                ((IExecutableExtension)result).setInitializationData(this.config, null, null);
            }
            return result;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, this.getBundleId(), String.valueOf(Strings.nullToEmpty((String)e.getMessage())) + " ExtensionFactory: " + this.getClass().getName(), (Throwable)e));
        }
    }

    protected abstract ClassLoader getClassLoader();

    protected abstract Injector getInjector();

    protected String getBundleId() {
        return "";
    }
}

