/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.emf;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.utils.SingleGlobalResourceSet;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.type.impl.java.JavaBeansMetaModel;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.emf.EClassType;
import org.eclipse.xtend.typesystem.emf.EEnumType;
import org.eclipse.xtend.typesystem.emf.EObjectType;
import org.eclipse.xtend.typesystem.emf.EmfListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfRegistryMetaModel
implements MetaModel {
    private final Log log = LogFactory.getLog(this.getClass());
    TypeSystem typeSystem;
    private EObjectType eobjectType = null;
    private JavaBeansMetaModel internalJbmm = new JavaBeansMetaModel();
    private final Cache<EObject, Type> cache = new Cache<EObject, Type>(){

        protected Type createNew(EObject param) {
            if (param == null) {
                return null;
            }
            if (param instanceof EGenericType) {
                EGenericType genericType = (EGenericType)param;
                if (EmfRegistryMetaModel.this.typeSystem != null) {
                    Type innerType = EmfRegistryMetaModel.this.getTypeForEClassifier((EGenericType)genericType.getETypeArguments().get(0));
                    return new EmfListType(innerType, EmfRegistryMetaModel.this.typeSystem, "List");
                }
                param = genericType.getEClassifier();
            }
            if (!(param instanceof EClassifier)) {
                return null;
            }
            EClassifier ele = (EClassifier)param;
            if (ele.getName() == null) {
                return null;
            }
            if (ele instanceof EClass) {
                return new EClassType(EmfRegistryMetaModel.this, EmfRegistryMetaModel.this.getFullyQualifiedName((ENamedElement)ele), (EClass)ele);
            }
            if (ele instanceof EEnum) {
                return new EEnumType(EmfRegistryMetaModel.this, EmfRegistryMetaModel.this.getFullyQualifiedName((ENamedElement)ele), (EEnum)ele);
            }
            if (ele instanceof EDataType) {
                EDataType dataType;
                if (EmfRegistryMetaModel.this.typeSystem != null) {
                    if (EmfRegistryMetaModel.this.stringTypes.contains(ele)) {
                        return EmfRegistryMetaModel.this.typeSystem.getStringType();
                    }
                    if (EmfRegistryMetaModel.this.booleanTypes.contains(ele)) {
                        return EmfRegistryMetaModel.this.typeSystem.getBooleanType();
                    }
                    if (EmfRegistryMetaModel.this.intTypes.contains(ele)) {
                        return EmfRegistryMetaModel.this.typeSystem.getIntegerType();
                    }
                    if (EmfRegistryMetaModel.this.realTypes.contains(ele)) {
                        return EmfRegistryMetaModel.this.typeSystem.getRealType();
                    }
                    if (EmfRegistryMetaModel.this.objectTypes.contains(ele)) {
                        return EmfRegistryMetaModel.this.typeSystem.getObjectType();
                    }
                    if (EmfRegistryMetaModel.this.listTypes.contains(ele)) {
                        return new EmfListType(EmfRegistryMetaModel.this.typeSystem.getObjectType(), EmfRegistryMetaModel.this.typeSystem, "List");
                    }
                }
                if ((dataType = (EDataType)ele).getInstanceClassName() != null) {
                    Type t = EmfRegistryMetaModel.this.internalJbmm.getTypeForName(dataType.getInstanceClassName().replace(".", "::"));
                    if (t == null) {
                        t = EmfRegistryMetaModel.this.typeSystem.getTypeForName(dataType.getInstanceClassName().replace(".", "::"));
                    }
                    return t;
                }
                return EmfRegistryMetaModel.this.typeSystem.getObjectType();
            }
            return null;
        }
    };
    private final HashSet<EClassifier> stringTypes;
    private final HashSet<EClassifier> intTypes;
    private final HashSet<EClassifier> realTypes;
    private final HashSet<EClassifier> booleanTypes;
    private final HashSet<EClassifier> objectTypes;
    private final HashSet<EClassifier> listTypes;
    private final Cache<String, Type> typeForNameCache = new Cache<String, Type>(){

        protected Type createNew(String typeName) {
            if (typeName.equals(EmfRegistryMetaModel.this.eobjectType.getName())) {
                return EmfRegistryMetaModel.this.eobjectType;
            }
            Set ele = EmfRegistryMetaModel.this.getNamedElementRec((ENamedElement[])EmfRegistryMetaModel.this.allPackages(), typeName);
            if (ele.size() > 1) {
                boolean classifiers = true;
                for (ENamedElement element : ele) {
                    boolean bl = classifiers = classifiers && element instanceof EClassifier;
                }
                if (classifiers) {
                    EmfRegistryMetaModel.this.log.warn((Object)("Multiple types (" + ele.size() + ") with name " + typeName + " found!"));
                }
            }
            if (ele.isEmpty()) {
                return null;
            }
            ENamedElement type = (ENamedElement)ele.iterator().next();
            if (type instanceof EClassifier) {
                return (Type)EmfRegistryMetaModel.this.cache.get((Object)type);
            }
            return null;
        }
    };
    private EPackage[] _allPackages;
    private final Set<ResourceSet> resourceSets = new HashSet<ResourceSet>();
    private Set<Type> knownTypes = null;

    public EObjectType getEobjectType() {
        return this.eobjectType;
    }

    public void setUseSingleGlobalResourceSet(boolean b) {
        if (b) {
            this.addResourceSet(SingleGlobalResourceSet.get());
        }
    }

    public void setTypeSystem(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
        this.internalJbmm.setTypeSystem(typeSystem);
        if (this.eobjectType == null) {
            this.eobjectType = new EObjectType(this.getTypeSystem());
        }
    }

    public EmfRegistryMetaModel() {
        this.stringTypes = new HashSet();
        this.stringTypes.add((EClassifier)EcorePackage.eINSTANCE.getEString());
        this.stringTypes.add((EClassifier)EcorePackage.eINSTANCE.getEChar());
        this.stringTypes.add((EClassifier)EcorePackage.eINSTANCE.getECharacterObject());
        this.booleanTypes = new HashSet();
        this.booleanTypes.add((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        this.booleanTypes.add((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject());
        this.intTypes = new HashSet();
        this.intTypes.add((EClassifier)EcorePackage.eINSTANCE.getEInt());
        this.intTypes.add((EClassifier)EcorePackage.eINSTANCE.getEIntegerObject());
        this.intTypes.add((EClassifier)EcorePackage.eINSTANCE.getELong());
        this.intTypes.add((EClassifier)EcorePackage.eINSTANCE.getELongObject());
        this.intTypes.add((EClassifier)EcorePackage.eINSTANCE.getEShort());
        this.intTypes.add((EClassifier)EcorePackage.eINSTANCE.getEShortObject());
        this.intTypes.add((EClassifier)EcorePackage.eINSTANCE.getEByte());
        this.intTypes.add((EClassifier)EcorePackage.eINSTANCE.getEByteObject());
        this.intTypes.add((EClassifier)EcorePackage.eINSTANCE.getEBigInteger());
        this.realTypes = new HashSet();
        this.realTypes.add((EClassifier)EcorePackage.eINSTANCE.getEFloat());
        this.realTypes.add((EClassifier)EcorePackage.eINSTANCE.getEFloatObject());
        this.realTypes.add((EClassifier)EcorePackage.eINSTANCE.getEDouble());
        this.realTypes.add((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject());
        this.realTypes.add((EClassifier)EcorePackage.eINSTANCE.getEBigDecimal());
        this.objectTypes = new HashSet();
        this.objectTypes.add((EClassifier)EcorePackage.eINSTANCE.getEJavaObject());
        this.listTypes = new HashSet();
        this.listTypes.add((EClassifier)EcorePackage.eINSTANCE.getEEList());
    }

    protected EPackage[] allPackages() {
        if (this._allPackages != null) {
            return this._allPackages;
        }
        HashSet<EPackage> packages = new HashSet<EPackage>();
        for (String name : new HashSet(EPackage.Registry.INSTANCE.keySet())) {
            try {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(name);
                if (ePackage == null) continue;
                packages.add(ePackage);
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
        for (ResourceSet rs : this.resourceSets) {
            for (String name : rs.getPackageRegistry().keySet()) {
                try {
                    EPackage ePackage = rs.getPackageRegistry().getEPackage(name);
                    if (ePackage == null) continue;
                    packages.add(ePackage);
                }
                catch (Exception e) {
                    this.log.error((Object)e, (Throwable)e);
                }
            }
        }
        this._allPackages = packages.toArray(new EPackage[packages.size()]);
        return this._allPackages;
    }

    public void addResourceSet(ResourceSet rs) {
        this.resourceSets.add(rs);
    }

    public Type getTypeForName(String typeName) {
        return (Type)this.typeForNameCache.get((Object)typeName);
    }

    private Set<ENamedElement> getNamedElementRec(ENamedElement[] elements, String name) {
        HashSet<ENamedElement> result = new HashSet<ENamedElement>();
        String[] frags = name.split("::");
        String firstFrag = frags[0];
        ENamedElement[] eNamedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ENamedElement ele = eNamedElementArray[n2];
            String eleName = this.getElementName(ele);
            if (eleName != null && eleName.equals(firstFrag)) {
                if (frags.length > 1) {
                    Collection children = EcoreUtil.getObjectsByType((Collection)ele.eContents(), (EClassifier)EcorePackage.eINSTANCE.getENamedElement());
                    result.addAll(this.getNamedElementRec(children.toArray(new ENamedElement[children.size()]), name.substring(name.indexOf("::") + "::".length())));
                } else {
                    result.add(ele);
                }
            }
            ++n2;
        }
        return result;
    }

    public Type getType(Object obj) {
        if (obj instanceof EObject) {
            if (obj instanceof EEnumLiteral && ((EEnumLiteral)obj).getName() != null && ((EEnumLiteral)obj).getEEnum() != null) {
                EEnumLiteral el = (EEnumLiteral)obj;
                return this.getTypeForEClassifier((EClassifier)el.getEEnum());
            }
            EClass clazz = ((EObject)obj).eClass();
            return this.getTypeForEClassifier((EClassifier)clazz);
        }
        Set<Type> types = this.getKnownTypes();
        if (obj instanceof Enumerator) {
            for (Type t : types) {
                if (!(t instanceof EEnumType) || !t.isInstance(obj)) continue;
                return t;
            }
        }
        return null;
    }

    public Set<Type> getKnownTypes() {
        if (this.knownTypes == null) {
            HashSet<Type> result = new HashSet<Type>();
            result.add((Type)this.eobjectType);
            LinkedList<EPackage> waiting = new LinkedList<EPackage>();
            waiting.addAll(Arrays.asList(this.allPackages()));
            while (!waiting.isEmpty()) {
                EObject elem = (EObject)waiting.remove(0);
                if (elem instanceof EPackage) {
                    EPackage pkg = (EPackage)elem;
                    waiting.addAll((Collection<EPackage>)pkg.getESubpackages());
                    waiting.addAll((Collection<EPackage>)pkg.getEClassifiers());
                    continue;
                }
                if (!(elem instanceof EClassifier)) continue;
                EClassifier cls = (EClassifier)elem;
                try {
                    Type t = this.getTypeForEClassifier(cls);
                    if (t == null) continue;
                    result.add(t);
                }
                catch (RuntimeException e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.knownTypes = result;
            return result;
        }
        return this.knownTypes;
    }

    public Type getTypeForEClassifier(EClassifier element) {
        if (element == null) {
            return this.getTypeSystem().getVoidType();
        }
        return (Type)this.cache.get((Object)element);
    }

    public Type getTypeForEClassifier(EGenericType element) {
        EClassifier baseType = null;
        baseType = element.getEClassifier() != null ? element.getEClassifier() : element.getERawType();
        if (baseType == null || !this.listTypes.contains(baseType)) {
            return this.getTypeForEClassifier(baseType);
        }
        if (element.getETypeArguments().size() != 1) {
            throw new RuntimeException("Unexpected number of type arguments");
        }
        return (Type)this.cache.get((Object)element);
    }

    public Type getTypeForETypedElement(ETypedElement typedElement) {
        if (typedElement.getEType() == null) {
            return this.getTypeSystem().getVoidType();
        }
        Type t = null;
        t = typedElement.getEType() instanceof EDataType ? (typedElement.getEGenericType() != null ? this.getTypeForEClassifier(typedElement.getEGenericType()) : this.getTypeForEClassifier(typedElement.getEType())) : (typedElement.getEGenericType() != null ? this.getTypeForEClassifier(typedElement.getEGenericType()) : this.getTypeSystem().getTypeForName(this.getFullyQualifiedName((ENamedElement)typedElement.getEType())));
        if (typedElement.isMany()) {
            return new EmfListType(t, this.typeSystem, "List");
        }
        return t;
    }

    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public String getFullyQualifiedName(ENamedElement ele) {
        return this.getFqnRec(ele.eContainer(), this.getElementName(ele));
    }

    protected String getFqnRec(EObject ele, String suffix) {
        if (ele == null || !(ele instanceof ENamedElement)) {
            return suffix;
        }
        return this.getFqnRec(ele.eContainer(), String.valueOf(this.getElementName((ENamedElement)ele)) + "::" + suffix);
    }

    private void traversePackage(String parentNamespace, Set<String> namespaces, EPackage thePackage) {
        StringBuilder sb = new StringBuilder();
        if (parentNamespace != null) {
            sb.append(parentNamespace);
            sb.append("::");
        }
        sb.append(this.getElementName((ENamedElement)thePackage));
        String namespace = sb.toString();
        namespaces.add(namespace);
        EList subpackages = thePackage.getESubpackages();
        for (EPackage subPackage : subpackages) {
            this.traversePackage(namespace, namespaces, subPackage);
        }
    }

    public Set<String> getNamespaces() {
        EPackage[] allPackages;
        HashSet<String> result = new HashSet<String>();
        EPackage[] ePackageArray = allPackages = this.allPackages();
        int n = allPackages.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage thePackage = ePackageArray[n2];
            this.traversePackage(null, result, thePackage);
            ++n2;
        }
        return result;
    }

    protected String getElementName(ENamedElement ele) {
        return ele == null ? null : ele.getName();
    }
}

