/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.sourcemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.n4js.transpiler.sourcemap.Base64VLQ;
import org.eclipse.n4js.transpiler.sourcemap.MappingEntry;
import org.eclipse.n4js.transpiler.sourcemap.SourceMap;

class SourceMapParser {
    private static final String SP = "\\s*";
    private static final String STR = "(?:\"((?:[^\"]|\\\\\")*)\")";
    private static final String STRING_ARRAY = "\\[\\s*(?:(?:\"((?:[^\"]|\\\\\")*)\"),?)*\\s*\\]";
    private static final String NUM = "([0-9]+)";
    private static final Pattern patternVersion = SourceMapParser.propPattern("version", "([0-9]+)");
    private static final Pattern patternFile = SourceMapParser.propPattern("file", "(?:\"((?:[^\"]|\\\\\")*)\")");
    private static final Pattern patternSourceRoot = SourceMapParser.propPattern("sourceRoot", "(?:\"((?:[^\"]|\\\\\")*)\")");
    private static final Pattern patternSources = SourceMapParser.propPattern("sources", "\\[\\s*(?:(?:\"((?:[^\"]|\\\\\")*)\"),?)*\\s*\\]");
    private static final Pattern patternNames = SourceMapParser.propPattern("names", "\\[\\s*(?:(?:\"((?:[^\"]|\\\\\")*)\"),?)*\\s*\\]");
    private static final Pattern patternMappingsStart = Pattern.compile("\"mappings\"\\s*:\\s*\"");

    SourceMapParser() {
    }

    private static Pattern propPattern(String name, String type) {
        return Pattern.compile("\"" + name + "\"" + SP + ":" + SP + type);
    }

    static SourceMap parse(CharSequence s) {
        SourceMap map = new SourceMap();
        map.version = SourceMapParser.parseString(patternVersion, s);
        map.file = SourceMapParser.parseString(patternFile, s);
        map.sourceRoot = SourceMapParser.parseString(patternSourceRoot, s);
        map.sources.addAll(SourceMapParser.parseStrings(patternSources, s));
        map.names.addAll(SourceMapParser.parseStrings(patternNames, s));
        Matcher m = patternMappingsStart.matcher(s);
        MappingEntry.PreviousEntry prev = new MappingEntry.PreviousEntry();
        if (m.find()) {
            int mappingStart;
            int i = mappingStart = m.end();
            int outLine = 0;
            StringBuilder vlq = new StringBuilder();
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c == ';' || c == '\"' || c == ',') {
                    if (vlq.length() > 0) {
                        int[] nums = Base64VLQ.decode(vlq);
                        MappingEntry entry = new MappingEntry(outLine, nums, prev);
                        entry.updatePrev(prev);
                        map.addMappig(entry);
                        vlq.setLength(0);
                    }
                    if (c == ';') {
                        ++outLine;
                        prev.genColumn = 0;
                    }
                    if (c == '\"') {
                        break;
                    }
                } else {
                    vlq.append(c);
                }
                ++i;
            }
            if (vlq.length() > 0) {
                int[] nums = Base64VLQ.decode(vlq);
                MappingEntry mapping = new MappingEntry(outLine, nums, prev);
                map.addMappig(mapping);
            }
        }
        return map;
    }

    private static String parseString(Pattern pattern, CharSequence s) {
        Matcher matcher = pattern.matcher(s);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private static List<String> parseStrings(Pattern pattern, CharSequence s) {
        Matcher matcher = pattern.matcher(s);
        if (matcher.find()) {
            int n = matcher.groupCount();
            ArrayList<String> list = new ArrayList<String>(n);
            int i = 1;
            while (i <= n) {
                String g = matcher.group(i);
                if (g != null) {
                    list.add(g);
                } else if (n == 1) {
                    return Collections.emptyList();
                }
                ++i;
            }
            return list;
        }
        return Collections.emptyList();
    }
}

