/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor.syntaxcoloring;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;
import org.eclipse.xtext.ui.editor.syntaxcoloring.TokenScanner;

public class TemplateAwareTokenScanner
extends TokenScanner {
    private TemplateToken currentTemplateTextToken;

    protected TemplateToken createTemplateToken(int id, ILexerTokenRegion token) {
        int tokenOffset = token.getOffset();
        int tokenLength = token.getLength();
        TemplateToken result = new TemplateToken();
        switch (id) {
            case 138: {
                result.delimiter = false;
                result.offsets = new int[]{tokenOffset, tokenOffset + tokenLength - 2};
                result.lengths = new int[]{tokenLength - 2, 2};
                break;
            }
            case 141: {
                if (tokenLength == 2) {
                    result.delimiter = true;
                    result.offsets = new int[]{tokenOffset};
                    result.lengths = new int[]{tokenLength};
                    break;
                }
                result.delimiter = false;
                result.offsets = new int[]{tokenOffset, tokenOffset + tokenLength - 2};
                result.lengths = new int[]{tokenLength - 2, 2};
            }
        }
        return result;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.currentTemplateTextToken = null;
        super.setRange(document, offset, length);
    }

    public IToken nextToken() {
        if (this.currentTemplateTextToken != null) {
            if (this.currentTemplateTextToken.hasNext()) {
                return this.currentTemplateTextToken.nextToken();
            }
            this.currentTemplateTextToken = null;
        }
        if (!this.getIterator().hasNext()) {
            return Token.EOF;
        }
        ILexerTokenRegion next = (ILexerTokenRegion)this.getIterator().next();
        int tokenType = next.getLexerTokenType();
        switch (tokenType) {
            case 138: 
            case 141: {
                this.currentTemplateTextToken = this.createTemplateToken(tokenType, next);
                return this.currentTemplateTextToken.nextToken();
            }
        }
        this.setCurrentToken(next);
        return this.createToken(next);
    }

    public int getTokenLength() {
        if (this.currentTemplateTextToken != null) {
            return this.currentTemplateTextToken.getTokenLength();
        }
        return super.getTokenLength();
    }

    public int getTokenOffset() {
        if (this.currentTemplateTextToken != null) {
            return this.currentTemplateTextToken.getTokenOffset();
        }
        return super.getTokenOffset();
    }

    private class TemplateToken {
        private int index = -1;
        private int[] offsets;
        private int[] lengths;
        private boolean delimiter;

        private TemplateToken() {
        }

        public int getTokenLength() {
            return this.lengths[this.index];
        }

        public int getTokenOffset() {
            return this.offsets[this.index];
        }

        public boolean hasNext() {
            return this.index < this.offsets.length - 1;
        }

        public IToken nextToken() {
            IToken result = this.createToken();
            ++this.index;
            this.delimiter = !this.delimiter;
            return result;
        }

        protected IToken createToken() {
            String attributeId = this.delimiter ? "TEMPLATE_DELIMITER_ID" : "TEMPLATE_ID";
            Token token = new Token((Object)TemplateAwareTokenScanner.this.getAttribute(attributeId));
            return token;
        }
    }
}

