/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.utils;

import java.util.Objects;
import org.eclipse.n4js.n4JS.ModuleSpecifierForm;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.xtext.naming.QualifiedName;

public class ImportSpecifierUtil {
    public static IN4JSProject getDependencyWithID(String projectName, IN4JSProject project) {
        if (Objects.equals(project.getProjectName(), projectName)) {
            return project;
        }
        for (IN4JSProject p : project.getDependencies()) {
            if (!Objects.equals(p.getProjectName(), projectName)) continue;
            return p;
        }
        return null;
    }

    public static ModuleSpecifierForm computeImportType(QualifiedName name, IN4JSProject project) {
        String firstSegment = name.getFirstSegment();
        IN4JSProject targetProject = ImportSpecifierUtil.getDependencyWithID(firstSegment, project);
        boolean firstSegmentIsProjectName = targetProject != null;
        return ImportSpecifierUtil.computeImportType(name, firstSegmentIsProjectName, targetProject);
    }

    public static ModuleSpecifierForm computeImportType(QualifiedName name, boolean useProjectName, IN4JSProject project) {
        if (useProjectName) {
            if (name.getSegmentCount() == 1) {
                QualifiedName moduleSpecifier = ImportSpecifierUtil.getMainModuleOfProject(project);
                if (moduleSpecifier == null) {
                    return ModuleSpecifierForm.PROJECT_NO_MAIN;
                }
                return ModuleSpecifierForm.PROJECT;
            }
            return ModuleSpecifierForm.COMPLETE;
        }
        return ModuleSpecifierForm.PLAIN;
    }

    public static QualifiedName getMainModuleOfProject(IN4JSProject project) {
        String mainModuleSpec;
        if (project != null && (mainModuleSpec = project.getMainModule()) != null) {
            QualifiedName mainModuleQN = QualifiedName.create((String[])mainModuleSpec.split("/"));
            return mainModuleQN;
        }
        return null;
    }
}

