/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.util;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.utils.RecursionGuard;

public class ConsumptionUtils {
    RecursionGuard<TClassifier> guard = new RecursionGuard();
    List<TClassifier> result = new LinkedList<TClassifier>();
    TInterface searchedInterface;

    public static TClassifier findInterfaceDefiningConsumedMember(TClassifier consumingClassifier, TMember consumedMember) {
        if (consumedMember == null || !(consumedMember.eContainer() instanceof TInterface)) {
            return null;
        }
        TInterface tinterface = (TInterface)consumedMember.eContainer();
        List<TClassifier> path = ConsumptionUtils.findPathToInterface(consumingClassifier, tinterface);
        if (path.isEmpty()) {
            return null;
        }
        return path.get(0);
    }

    public static List<TClassifier> findPathToInterface(TClassifier from, TInterface toInterface) {
        EList<ParameterizedTypeRef> superInterfaces = from instanceof TClass ? ((TClass)from).getImplementedInterfaceRefs() : ((TInterface)from).getSuperInterfaceRefs();
        ConsumptionUtils finder = new ConsumptionUtils(toInterface);
        finder.doFindPathToInterface((List<ParameterizedTypeRef>)superInterfaces);
        return finder.result;
    }

    private ConsumptionUtils(TInterface searchedInterface) {
        this.searchedInterface = searchedInterface;
    }

    private boolean doFindPathToInterface(List<ParameterizedTypeRef> superInterfaces) {
        if (superInterfaces.stream().anyMatch(ref -> ref.getDeclaredType() == this.searchedInterface)) {
            this.result.add(0, this.searchedInterface);
            return true;
        }
        for (ParameterizedTypeRef ptr : superInterfaces) {
            TInterface tInterface = (TInterface)ptr.getDeclaredType();
            if (!this.guard.tryNext((Object)tInterface) || !this.doFindPathToInterface((List<ParameterizedTypeRef>)tInterface.getSuperInterfaceRefs())) continue;
            this.result.add(0, tInterface);
            return true;
        }
        return false;
    }
}

