/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.extensions.ExpressionExtensions;
import org.eclipse.n4js.scoping.members.TypingStrategyFilterDesc;
import org.eclipse.n4js.scoping.members.WrongTypingStrategyDescription;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.xtext.scoping.FilterWithErrorMarkerScope;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class TypingStrategyAwareMemberScope
extends FilterWithErrorMarkerScope {
    private final TypingStrategyFilterDesc strategyFilter;
    private final boolean useSite;
    private final String receiverTypeName;

    public TypingStrategyAwareMemberScope(IScope parent, TypeRef receiverType, EObject context) {
        super(parent);
        boolean isLeftHand = ExpressionExtensions.isLeftHandSide(context);
        this.strategyFilter = new TypingStrategyFilterDesc(TypeUtils.retrieveTypingStrategy((TypeRef)receiverType), isLeftHand);
        this.useSite = receiverType != null && receiverType.isUseSiteStructuralTyping();
        this.receiverTypeName = receiverType == null || receiverType.eIsProxy() ? "unknown type" : receiverType.getTypeRefAsString();
    }

    protected IEObjectDescriptionWithError wrapFilteredDescription(IEObjectDescription originalDescr) {
        return new WrongTypingStrategyDescription(originalDescr, this.strategyFilter.getTypingStrategy() == TypingStrategy.STRUCTURAL_FIELDS, this.useSite, this.receiverTypeName);
    }

    protected boolean isAccepted(IEObjectDescription originalDescr) {
        if (originalDescr == null || IEObjectDescriptionWithError.isErrorDescription((IEObjectDescription)originalDescr)) {
            return true;
        }
        return this.strategyFilter.apply(originalDescr);
    }
}

