/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.scoping.accessModifiers.MemberVisibilityChecker;
import org.eclipse.n4js.scoping.members.TypingStrategyFilter;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.StructuralTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TAnnotation;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.Result;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.n4js.validation.validators.PolyfillValidatorFragment;
import org.eclipse.n4js.validation.validators.StaticPolyfillValidatorExtension;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class N4JSClassValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private PolyfillValidatorFragment polyfillValidatorFragment;
    @Inject
    @Extension
    private ContainerTypesHelper containerTypesHelper;
    @Inject
    private MemberVisibilityChecker memberVisibilityChecker;
    @Inject
    private N4JSElementKeywordProvider n4jsElementKeywordProvider;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkTestClassExported(N4ClassDeclaration classDecl) {
        Type _definedType_1;
        TClass clazz;
        Type _definedType = null;
        if (classDecl != null) {
            _definedType = classDecl.getDefinedType();
        }
        if (_definedType instanceof TClass && !(clazz = (TClass)(_definedType_1 = classDecl.getDefinedType())).isAbstract() && !clazz.isExported() && this.hasTestMethods(clazz)) {
            this.addIssue(IssueCodes.getMessageForCLF_TEST_CLASS_NOT_EXPORTED(), (EObject)classDecl, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "CLF_TEST_CLASS_NOT_EXPORTED", new String[0]);
        }
    }

    private boolean hasTestMethods(TClass clazz) {
        TModule module;
        boolean _tripleNotEquals;
        Resource _eResource = null;
        if (clazz != null) {
            _eResource = clazz.eResource();
        }
        boolean bl = _tripleNotEquals = _eResource != null;
        if (_tripleNotEquals && (module = N4JSResource.getModule(clazz.eResource())) != null) {
            Functions.Function1 _function = it -> AnnotationDefinition.TEST_METHOD.hasAnnotation((TAnnotableElement)it);
            return IterableExtensions.exists((Iterable)Iterables.filter(this.containerTypesHelper.fromContext((EObject)module).allMembers((ContainerType<?>)clazz, false, false), TMethod.class), (Functions.Function1)_function);
        }
        return false;
    }

    @Check
    public void checkSpecConstructorArguments(NewExpression newExpression) {
        ObjectLiteral objectLiteral;
        Type _definedType;
        boolean _not_3;
        boolean _not_2;
        boolean _greaterThan;
        boolean _not_1;
        boolean _not;
        Expression _callee = newExpression.getCallee();
        boolean bl = _not = !(_callee instanceof IdentifierRef);
        if (_not) {
            return;
        }
        Expression _callee_1 = newExpression.getCallee();
        IdentifierRef identifierRef = (IdentifierRef)_callee_1;
        IdentifiableElement _id = identifierRef.getId();
        boolean bl2 = _not_1 = !(_id instanceof TClass);
        if (_not_1) {
            return;
        }
        IdentifiableElement _id_1 = identifierRef.getId();
        TClass tclass = (TClass)_id_1;
        TMethod ctor = this.containerTypesHelper.fromContext((EObject)newExpression).findConstructor((ContainerType<?>)tclass);
        if (ctor == null || IterableExtensions.isNullOrEmpty((Iterable)ctor.getFpars())) {
            return;
        }
        Functions.Function1 _function = it -> {
            TAnnotation _annotation = AnnotationDefinition.SPEC.getAnnotation((TAnnotableElement)it);
            return _annotation != null;
        };
        List fparsWithSpecAnnotation = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)ctor.getFpars(), (Functions.Function1)_function));
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)fparsWithSpecAnnotation);
        if (_isNullOrEmpty) {
            return;
        }
        int _size = fparsWithSpecAnnotation.size();
        boolean bl3 = _greaterThan = _size > 1;
        if (_greaterThan) {
            return;
        }
        TFormalParameter fparWithSpecAnnotation = (TFormalParameter)Iterables.getOnlyElement((Iterable)fparsWithSpecAnnotation);
        TypeRef typeRef = fparWithSpecAnnotation.getTypeRef();
        if (!(typeRef instanceof ThisTypeRefStructural) || TypingStrategy.STRUCTURAL_FIELD_INITIALIZER != typeRef.getTypingStrategy()) {
            return;
        }
        int indexOfTheSpecFpar = ctor.getFpars().indexOf((Object)fparWithSpecAnnotation);
        if (indexOfTheSpecFpar < 0 || newExpression.getArguments().size() <= indexOfTheSpecFpar) {
            return;
        }
        Argument _get = (Argument)newExpression.getArguments().get(indexOfTheSpecFpar);
        Expression _expression = null;
        if (_get != null) {
            _expression = _get.getExpression();
        }
        boolean bl4 = _not_2 = !(_expression instanceof ObjectLiteral);
        if (_not_2) {
            return;
        }
        Argument _get_1 = (Argument)newExpression.getArguments().get(indexOfTheSpecFpar);
        Expression _expression_1 = null;
        if (_get_1 != null) {
            _expression_1 = _get_1.getExpression();
        }
        boolean bl5 = _not_3 = !((_definedType = (objectLiteral = (ObjectLiteral)_expression_1).getDefinedType()) instanceof ContainerType);
        if (_not_3) {
            return;
        }
        TypingStrategyFilter strategy = new TypingStrategyFilter(TypingStrategy.STRUCTURAL);
        Functions.Function1 _function_1 = member -> member instanceof TField || member instanceof TSetter;
        Functions.Function1 _function_2 = it -> strategy.apply((TMember)it);
        Functions.Function1 _function_3 = it -> it.getName();
        Map publicWritableFieldsAndSetters = IterableExtensions.toMap((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(this.containerTypesHelper.fromContext((EObject)newExpression).allMembers((ContainerType<?>)tclass), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        Consumer<TField> _function_4 = it -> publicWritableFieldsAndSetters.put(it.getName(), it);
        Iterables.filter((Iterable)((ThisTypeRefStructural)typeRef).getStructuralMembers(), TField.class).forEach(_function_4);
        this.checkFieldInitializationOfImplementedInterface(publicWritableFieldsAndSetters, objectLiteral);
    }

    private void checkFieldInitializationOfImplementedInterface(Map<String, TMember> publicWritableFieldsMap, ObjectLiteral objectLiteral) {
        Type _definedType = objectLiteral.getDefinedType();
        EList properties = ((ContainerType)_definedType).getOwnedMembers();
        Consumer<TMember> _function = property -> {
            boolean _builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation;
            ContainerType containingClassifier;
            TMember field = (TMember)publicWritableFieldsMap.get(property.getName());
            if (field != null && (containingClassifier = field.getContainingType()) instanceof TInterface && (_builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation = N4JSLanguageUtils.builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation((TInterface)containingClassifier))) {
                String message = IssueCodes.getMessageForCLF_SPEC_BUILT_IN_OR_PROVIDED_BY_RUNTIME_OR_EXTENAL_WITHOUT_N4JS_ANNOTATION(field.getName(), ((TInterface)containingClassifier).getName());
                this.addIssue(message, property.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME, "CLF_SPEC_BUILT_IN_OR_PROVIDED_BY_RUNTIME_OR_EXTENAL_WITHOUT_N4JS_ANNOTATION", new String[0]);
            }
        };
        properties.forEach(_function);
    }

    @Check
    public void checkN4ClassDeclaration(N4ClassDeclaration n4Class) {
        boolean _not;
        Type _definedType = n4Class.getDefinedType();
        boolean bl = _not = !(_definedType instanceof TClass);
        if (_not) {
            return;
        }
        boolean _holdsPolyfill = this.polyfillValidatorFragment.holdsPolyfill(this, n4Class);
        if (_holdsPolyfill) {
            Type _definedType_1 = n4Class.getDefinedType();
            TClass tClass = (TClass)_definedType_1;
            this.internalCheckAbstractFinal(tClass);
            boolean _holdsSuperClass = this.holdsSuperClass(n4Class);
            if (_holdsSuperClass) {
                this.holdsNoCyclicInheritance(n4Class);
            }
            StaticPolyfillValidatorExtension.internalCheckPolyFilledClassWithAdditionalInterface(n4Class, this);
            this.internalCheckImplementedInterfaces(n4Class);
            this.internalCheckSpecAnnotation(n4Class);
        }
    }

    public void addIssue(String message, EObject source, EStructuralFeature feature, String issueCode, String ... issueData) {
        super.addIssue(message, source, feature, issueCode, issueData);
    }

    private void internalCheckAbstractFinal(TClass tClass) {
        if (tClass.isAbstract() && tClass.isFinal()) {
            String message = IssueCodes.getMessageForCLF_ABSTRACT_FINAL("class");
            this.addIssue(message, tClass.getAstElement(), (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "CLF_ABSTRACT_FINAL", new String[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean holdsSuperClass(N4ClassDeclaration n4Class) {
        Type superType;
        ParameterizedTypeRef _superClassRef = n4Class.getSuperClassRef();
        Type _declaredType = null;
        if (_superClassRef != null) {
            _declaredType = _superClassRef.getDeclaredType();
        }
        if ((superType = _declaredType) == null) return true;
        if (superType.getName() == null) return true;
        if (superType instanceof PrimitiveType) {
            String message = IssueCodes.getMessageForCLF_EXTENDS_PRIMITIVE_GENERIC_TYPE(((PrimitiveType)superType).getName());
            this.addIssue(message, (EObject)n4Class.getSuperClassRef(), null, "CLF_EXTENDS_PRIMITIVE_GENERIC_TYPE", new String[0]);
            return true;
        }
        if (!(superType instanceof TClass) && !(superType instanceof TObjectPrototype)) {
            if (superType instanceof TInterface) {
                String message_1 = IssueCodes.getMessageForSYN_KW_EXTENDS_IMPLEMENTS_MIXED_UP(this.validatorMessageHelper.description((EObject)n4Class), "extend", this.validatorMessageHelper.description((EObject)superType), "implements");
                this.addIssue(message_1, (EObject)n4Class.getSuperClassRef(), null, "SYN_KW_EXTENDS_IMPLEMENTS_MIXED_UP", new String[0]);
                return true;
            }
            String message_2 = IssueCodes.getMessageForCLF_WRONG_META_TYPE(this.validatorMessageHelper.description((EObject)n4Class), "extend", this.validatorMessageHelper.description((EObject)superType));
            this.addIssue(message_2, (EObject)n4Class.getSuperClassRef(), null, "CLF_WRONG_META_TYPE", new String[0]);
            return false;
        }
        if (superType instanceof TClass) {
            if (((TClass)superType).isFinal() && !N4JSLanguageUtils.isPolyfill((AnnotableElement)n4Class) && !N4JSLanguageUtils.isStaticPolyfill((AnnotableElement)n4Class)) {
                String superClassUri;
                String message_3 = IssueCodes.getMessageForCLF_EXTEND_FINAL(((TClass)superType).getName());
                Object _eGet = ((TClass)superType).eGet((EStructuralFeature)TypesPackage.eINSTANCE.getSyntaxRelatedTElement_AstElement(), false);
                EObject superTypeAstElement = (EObject)_eGet;
                String _xifexpression = null;
                if (superTypeAstElement != null) {
                    _xifexpression = EcoreUtil.getURI((EObject)superTypeAstElement).toString();
                }
                if ((superClassUri = _xifexpression) != null) {
                    this.addIssue(message_3, (EObject)n4Class.getSuperClassRef(), null, "CLF_EXTEND_FINAL", "org.eclipse.n4js.validation.validators.N4JSClassValidator.super_type_declaration_uri", superClassUri);
                    return false;
                }
                this.addIssue(message_3, (EObject)n4Class.getSuperClassRef(), null, "CLF_EXTEND_FINAL", "org.eclipse.n4js.validation.validators.N4JSClassValidator.super_type_declaration_uri");
                return false;
            }
            boolean _holdsCtorOfSuperTypeIsAccessible = this.holdsCtorOfSuperTypeIsAccessible(n4Class, (TClassifier)superType);
            if (!_holdsCtorOfSuperTypeIsAccessible) return false;
            boolean bl = false;
            boolean _not = bl;
            if (_not) {
                return false;
            }
            if (!((TClass)superType).isObservable()) return true;
            if (((TClass)n4Class.getDefinedType()).isObservable()) return true;
            String message_4 = IssueCodes.getMessageForCLF_OBSERVABLE_MISSING(n4Class.getName(), ((TClass)superType).getName());
            this.addIssue(message_4, (EObject)n4Class, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "CLF_OBSERVABLE_MISSING", new String[0]);
            return false;
        }
        if (!(superType instanceof TObjectPrototype)) return true;
        boolean _holdsCtorOfSuperTypeIsAccessible_1 = this.holdsCtorOfSuperTypeIsAccessible(n4Class, (TClassifier)superType);
        boolean _not_1 = !_holdsCtorOfSuperTypeIsAccessible_1;
        if (!_not_1) return true;
        return false;
    }

    private boolean holdsCtorOfSuperTypeIsAccessible(N4ClassDeclaration n4Class, TClassifier superType) {
        ParameterizedTypeRef receiverTypeRef = TypeUtils.createTypeRef((Type)n4Class.getDefinedType(), (TypeArgument[])new TypeArgument[0]);
        TMethod superCtor = this.containerTypesHelper.fromContext((EObject)n4Class).findConstructor((ContainerType<?>)superType);
        if (superCtor != null && !this.memberVisibilityChecker.isVisible((EObject)n4Class, (TypeRef)receiverTypeRef, (TMember)superCtor).visibility) {
            String message = IssueCodes.getMessageForCLF_EXTEND_NON_ACCESSIBLE_CTOR(this.n4jsElementKeywordProvider.keyword(superType), superType.getName());
            this.addIssue(message, (EObject)n4Class, (EStructuralFeature)N4JSPackage.Literals.N4_CLASS_DEFINITION__SUPER_CLASS_REF, "CLF_EXTEND_NON_ACCESSIBLE_CTOR", new String[0]);
            return false;
        }
        return true;
    }

    private void internalCheckImplementedInterfaces(N4ClassDeclaration n4Class) {
        Consumer<ParameterizedTypeRef> _function = it -> {
            Type consumedType = it.getDeclaredType();
            if (consumedType != null && consumedType.getName() != null && !(consumedType instanceof TInterface)) {
                if ((consumedType instanceof TClass || consumedType instanceof TObjectPrototype) && n4Class.getSuperClassRef() == null) {
                    String message = IssueCodes.getMessageForSYN_KW_EXTENDS_IMPLEMENTS_MIXED_UP(this.validatorMessageHelper.description((EObject)n4Class), "implement", this.validatorMessageHelper.description((EObject)consumedType), "extends");
                    this.addIssue(message, (EObject)it, null, "SYN_KW_EXTENDS_IMPLEMENTS_MIXED_UP", new String[0]);
                } else {
                    String message_1 = IssueCodes.getMessageForCLF_WRONG_META_TYPE(this.validatorMessageHelper.description((EObject)n4Class), "implement", this.validatorMessageHelper.description((EObject)consumedType));
                    this.addIssue(message_1, (EObject)it, null, "CLF_WRONG_META_TYPE", new String[0]);
                }
            }
        };
        n4Class.getImplementedInterfaceRefs().forEach(_function);
    }

    private void internalCheckSpecAnnotation(N4ClassDeclaration n4ClassDeclaration) {
        N4MethodDeclaration ctor = n4ClassDeclaration.getOwnedCtor();
        if (ctor != null) {
            boolean _greaterEqualsThan;
            String message;
            ArrayList specAnnotations = CollectionLiterals.newArrayList();
            int i = 0;
            EList _fpars = ctor.getFpars();
            for (FormalParameter currFPar : _fpars) {
                Annotation annSpec = AnnotationDefinition.SPEC.getAnnotation((AnnotableElement)currFPar);
                if (annSpec != null) {
                    boolean correctType;
                    specAnnotations.add(annSpec);
                    boolean bl = correctType = currFPar.getDeclaredTypeRef() instanceof ThisTypeRef && TypingStrategy.STRUCTURAL_FIELD_INITIALIZER == currFPar.getDeclaredTypeRef().getTypingStrategy();
                    if (!correctType) {
                        message = IssueCodes.getMessageForCLF_SPEC_WRONG_TYPE();
                        this.addIssue(message, (EObject)annSpec, null, "CLF_SPEC_WRONG_TYPE", new String[0]);
                    } else {
                        this.holdsAdditionalSpecFieldMatchesOwnedFields(n4ClassDeclaration, ctor, i);
                    }
                }
                ++i;
            }
            int _size = specAnnotations.size();
            boolean bl = _greaterEqualsThan = _size >= 2;
            if (_greaterEqualsThan) {
                for (Annotation currAnnSpec : specAnnotations) {
                    message = IssueCodes.getMessageForCLF_SPEC_MULTIPLE();
                    this.addIssue(message, (EObject)currAnnSpec, null, "CLF_SPEC_MULTIPLE", new String[0]);
                }
            }
        }
    }

    public void holdsAdditionalSpecFieldMatchesOwnedFields(N4ClassDeclaration n4ClassDeclaration, N4MethodDeclaration ctor, int parIndex) {
        boolean _greaterEqualsThan;
        Type _definedType = n4ClassDeclaration.getDefinedType();
        TClass tclass = (TClass)_definedType;
        Type _definedType_1 = ctor.getDefinedType();
        EList fpars = ((TFunction)_definedType_1).getFpars();
        int _size = fpars.size();
        boolean bl = _greaterEqualsThan = parIndex >= _size;
        if (_greaterEqualsThan) {
            return;
        }
        TFormalParameter fpar = (TFormalParameter)fpars.get(parIndex);
        TypeRef fparType = fpar.getTypeRef();
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)n4ClassDeclaration);
        int memberIndex = 0;
        EList _structuralMembers = fparType.getStructuralMembers();
        for (TStructMember smember : _structuralMembers) {
            Functions.Function1 _function = it -> {
                String _name = it.getName();
                String _name_1 = smember.getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            };
            TMember tfield = (TMember)IterableExtensions.findFirst((Iterable)tclass.getOwnedMembers(), (Functions.Function1)_function);
            if (tfield != null && (tfield.isField() || tfield.isSetter())) {
                TypeRef fieldType = this.ts.tau((TypableElement)tfield, (TypeRef)TypeUtils.createTypeRef((Type)tclass, (TypeArgument[])new TypeArgument[0]));
                TypeRef smemberType = this.ts.tau((TypableElement)smember, (TypeRef)TypeUtils.createTypeRef((Type)tclass, (TypeArgument[])new TypeArgument[0]));
                Result subtypeRes = this.ts.subtype(G, (TypeArgument)smemberType, (TypeArgument)fieldType);
                boolean _isFailure = subtypeRes.isFailure();
                if (_isFailure) {
                    String message = IssueCodes.getMessageForCLF_SPEC_WRONG_ADD_MEMBERTYPE(smember.getName(), this.validatorMessageHelper.description((EObject)tfield), this.validatorMessageHelper.trimTypesystemMessage(subtypeRes));
                    TypeRef _declaredTypeRef = ((FormalParameter)ctor.getFpars().get(parIndex)).getDeclaredTypeRef();
                    TStructMember errMember = (TStructMember)((StructuralTypeRef)_declaredTypeRef).getStructuralMembers().get(memberIndex);
                    Object _xifexpression = null;
                    EObject _astElement = errMember.getAstElement();
                    boolean _tripleNotEquals = _astElement != null;
                    _xifexpression = _tripleNotEquals ? errMember.getAstElement() : errMember;
                    TStructMember sourceObject = _xifexpression;
                    this.addIssue(message, (EObject)sourceObject, "CLF_SPEC_WRONG_ADD_MEMBERTYPE");
                }
            }
            ++memberIndex;
        }
    }

    private boolean holdsNoCyclicInheritance(N4ClassDeclaration n4ClassDeclaration) {
        Type _definedType = n4ClassDeclaration.getDefinedType();
        TClassifier cls = (TClassifier)_definedType;
        List<TClassifier> cycle = this.findCyclicInheritance(cls);
        if (cycle != null) {
            Functions.Function1 _function = it -> it.getName();
            String message = IssueCodes.getMessageForCLF_INHERITANCE_CYCLE(IterableExtensions.join((Iterable)ListExtensions.map(cycle, (Functions.Function1)_function), (CharSequence)", "));
            this.addIssue(message, (EObject)n4ClassDeclaration, (EStructuralFeature)N4JSPackage.Literals.N4_CLASS_DEFINITION__SUPER_CLASS_REF, "CLF_INHERITANCE_CYCLE", new String[0]);
            return false;
        }
        return true;
    }
}

