/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.tests;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.LiveExecutionType;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.runner.XpectRunner;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.setup.XtextStandaloneSetup;
import org.eclipse.xpect.xtext.lib.setup.XtextWorkspaceSetup;
import org.eclipse.xpect.xtext.lib.util.InMemoryFileSystemAccessFormatter;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;
import org.eclipse.xtext.resource.XtextResource;
import org.junit.runner.RunWith;

@RunWith(value=XpectRunner.class)
@XpectImport(value={XtextStandaloneSetup.class, XtextWorkspaceSetup.class})
public class GeneratorTest {
    @Inject
    private GeneratorDelegate generator;

    protected IGeneratorContext createGeneratorContext(XtextResource resource) {
        return new GeneratorContext();
    }

    protected InMemoryFileSystemAccessFormatter createInMemoryFileSystemAccessFormatter() {
        return new InMemoryFileSystemAccessFormatter();
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    @ParameterParser(syntax="('file' arg2=TEXT)?")
    public void generated(@StringExpectation IStringExpectation expectation, @ThisResource XtextResource resource, String arg2) {
        InMemoryFileSystemAccess fsa = new InMemoryFileSystemAccess();
        IGeneratorContext context = this.createGeneratorContext(resource);
        this.generator.beforeGenerate((Resource)resource, (IFileSystemAccess2)fsa, context);
        this.generator.doGenerate((Resource)resource, (IFileSystemAccess2)fsa, context);
        this.generator.afterGenerate((Resource)resource, (IFileSystemAccess2)fsa, context);
        String files = this.createInMemoryFileSystemAccessFormatter().includeOnlyFileNamesEndingWith(arg2).apply(fsa);
        expectation.assertEquals((Object)files);
    }

    protected GeneratorDelegate getGenerator() {
        return this.generator;
    }
}

