/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc.tags;

import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.jsdoc.DescriptionParser;
import org.eclipse.n4js.jsdoc.JSDocCharScanner;
import org.eclipse.n4js.jsdoc.JSDocSerializer;
import org.eclipse.n4js.jsdoc.TagDictionary;
import org.eclipse.n4js.jsdoc.dom.ContentNode;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.jsdoc.dom.DomFactory;
import org.eclipse.n4js.jsdoc.dom.LineTag;
import org.eclipse.n4js.jsdoc.dom.Tag;
import org.eclipse.n4js.jsdoc.dom.TagTitle;
import org.eclipse.n4js.jsdoc.dom.TagValue;
import org.eclipse.n4js.jsdoc.dom.Text;
import org.eclipse.n4js.jsdoc.tags.AbstractLineTagDefinition;

public class LineTagWithSimpleTextDefinition
extends AbstractLineTagDefinition {
    public static final String VALUE = "VALUE";

    public LineTagWithSimpleTextDefinition(String title) {
        this.setTitles(title);
    }

    @Override
    public Tag parse(TagTitle title, JSDocCharScanner scanner, DescriptionParser descriptionParser) {
        ContentNode node = descriptionParser.parse(scanner, TagDictionary.emptyDict());
        if (!(node instanceof Text)) {
            String asText;
            String string = asText = node != null ? JSDocSerializer.toJSDocString(node) : "";
            if (asText.isEmpty()) {
                node = null;
            } else {
                Text text = DomFactory.eINSTANCE.createText();
                text.setText(asText);
                if (node == null) {
                    text.setRange(scanner.nextOffset(), scanner.nextOffset());
                } else {
                    text.setRange(node.getBegin(), node.getEnd());
                }
                node = text;
            }
        } else {
            Text text = (Text)node;
            if (text.getText().isEmpty()) {
                node = null;
            }
        }
        LineTag tag = this.createLineTag(title);
        if (node != null) {
            this.addValue((Tag)tag, VALUE, node);
        }
        return tag;
    }

    public String getValue(LineTag tag, String defaultValue) {
        if (tag == null || !this.getAllTitles().contains(tag.getTitle().getTitle())) {
            return defaultValue;
        }
        TagValue tv = tag.getValueByKey(VALUE);
        if (tv.getContents().isEmpty()) {
            return defaultValue;
        }
        return ((Text)tv.getContents().get(0)).getText();
    }

    public String getValue(Doclet doclet, String defaultValue) {
        EList<LineTag> tags = doclet.lineTags(this.getTitle());
        if (tags.isEmpty()) {
            return defaultValue;
        }
        return this.getValue((LineTag)tags.get(0), defaultValue);
    }
}

