/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IDynamicReferenceProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;

public class DynamicPluginProjectReferences
implements IDynamicReferenceProvider {
    public static State state;

    public List<IProject> getDependentProjects(IBuildConfiguration buildConfiguration) throws CoreException {
        IPluginModelBase model;
        IProject input = buildConfiguration.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)input);
        if (javaProject != null && (model = PDECore.getDefault().getModelManager().findModel(javaProject.getProject())) != null) {
            ArrayList<IProject> allProj = new ArrayList<IProject>();
            BundleDescription currentBundle = model.getBundleDescription();
            if (state == null) {
                state = StateObjectFactory.defaultFactory.createState(true);
            }
            if (state != null && currentBundle != null) {
                BundleDescription[] bundlePrereq;
                BundleDescription[] bundleDescriptionArray = bundlePrereq = state.getStateHelper().getPrerequisites(new BundleDescription[]{currentBundle});
                int n = bundlePrereq.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkspaceRoot root;
                    IProject project;
                    BundleDescription bundle = bundleDescriptionArray[n2];
                    if (!bundle.equals((Object)currentBundle) && (project = (root = PDECore.getWorkspace().getRoot()).getProject(bundle.getName())).exists() && !allProj.contains(project)) {
                        allProj.add(project);
                    }
                    ++n2;
                }
            }
            return allProj;
        }
        return Collections.emptyList();
    }
}

