/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.changes;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.n4js.ui.changes.IAtomicChange;
import org.eclipse.n4js.ui.changes.IChange;
import org.eclipse.n4js.ui.changes.ICompositeChange;
import org.eclipse.n4js.utils.RecursionGuard;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

public class ChangeManager {
    @Inject
    private Injector tempInjector;

    private IURIEditorOpener getEditorOpener() {
        return PlatformUI.isWorkbenchRunning() ? (IURIEditorOpener)this.tempInjector.getInstance(IURIEditorOpener.class) : null;
    }

    public List<IAtomicChange> flatten(Collection<? extends IChange> changes) {
        return this.flatten(changes, new ArrayList<IAtomicChange>(), (RecursionGuard<IChange>)new RecursionGuard());
    }

    public List<IAtomicChange> flattenAndOrganized(Collection<? extends IChange> changes) {
        List<IAtomicChange> unorg = this.flatten(changes);
        Collections.sort(unorg, Collections.reverseOrder());
        return unorg;
    }

    private List<IAtomicChange> flatten(Collection<? extends IChange> changes, List<IAtomicChange> addHere, RecursionGuard<IChange> guard) {
        for (IChange iChange : changes) {
            if (!guard.tryNext((Object)iChange)) continue;
            if (iChange instanceof ICompositeChange) {
                this.flatten(((ICompositeChange)iChange).getChildren(), addHere, guard);
                continue;
            }
            if (!(iChange instanceof IAtomicChange)) continue;
            addHere.add((IAtomicChange)iChange);
        }
        return addHere;
    }

    public Map<URI, List<IAtomicChange>> organize(Collection<? extends IChange> changes) {
        List<IAtomicChange> flatChanges = this.flatten(changes);
        HashMap<URI, List<IAtomicChange>> result = new HashMap<URI, List<IAtomicChange>>();
        for (IAtomicChange currChange : flatChanges) {
            URI currURI = currChange.getURI().trimFragment();
            ArrayList<IAtomicChange> currL = (ArrayList<IAtomicChange>)result.get(currURI);
            if (currL == null) {
                currL = new ArrayList<IAtomicChange>();
                result.put(currURI, currL);
            }
            currL.add(currChange);
        }
        for (List currL : result.values()) {
            Collections.sort(currL, Collections.reverseOrder());
        }
        return result;
    }

    public void applyAll(Collection<? extends IChange> changes) throws BadLocationException {
        Map<URI, List<IAtomicChange>> changesPerFile = this.organize(changes);
        for (URI currURI : changesPerFile.keySet()) {
            IXtextDocument document = this.getDocument(currURI);
            this.applyAllInSameDocument((Collection<? extends IAtomicChange>)changesPerFile.get(currURI), (IDocument)document);
        }
    }

    public void applyAllInSameDocument(Collection<? extends IAtomicChange> changes, IDocument document) throws BadLocationException {
        DocumentRewriteSession rewriteSession = null;
        try {
            if (document instanceof IDocumentExtension4) {
                rewriteSession = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
            }
            for (IAtomicChange iAtomicChange : changes) {
                iAtomicChange.apply(document);
            }
        }
        finally {
            if (rewriteSession != null) {
                ((IDocumentExtension4)document).stopRewriteSession(rewriteSession);
            }
        }
    }

    private IXtextDocument getDocument(URI uri) {
        return this.getEditor(uri).getDocument();
    }

    private XtextEditor getEditor(URI uri) {
        IEditorPart editor;
        URI uriToEditor;
        URI uRI = uriToEditor = uri != null ? uri.trimFragment() : null;
        if (uriToEditor != null && (editor = this.getEditorOpener().open(uriToEditor, false)) instanceof XtextEditor) {
            return (XtextEditor)editor;
        }
        return null;
    }
}

