/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Singleton;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.impl.ToBeBuilt;

@Singleton
@Beta
public class ClosedProjectsQueue {
    private final Deque<Task> internalQueue = new ConcurrentLinkedDeque<Task>();

    protected void enqueue(Set<String> projectNames, ToBeBuilt toBeBuilt) {
        this.internalQueue.addLast(new Task((ImmutableSet<String>)ImmutableSet.copyOf(projectNames), toBeBuilt));
    }

    protected void insert(Set<String> projectNames, ToBeBuilt toBeBuilt) {
        this.internalQueue.addFirst(new Task((ImmutableSet<String>)ImmutableSet.copyOf(projectNames), toBeBuilt));
    }

    protected Task exhaust() {
        LinkedHashSet projectNames = new LinkedHashSet();
        ToBeBuilt toBeBuilt = new ToBeBuilt();
        Set<URI> toBeDeleted = toBeBuilt.getToBeDeleted();
        Task next = this.internalQueue.poll();
        while (next != null) {
            Set<URI> nextToBeDeleted = next.toBeBuilt.getToBeDeleted();
            if (nextToBeDeleted != null && !nextToBeDeleted.isEmpty()) {
                projectNames.addAll(next.projectNames);
                toBeDeleted.addAll(nextToBeDeleted);
            }
            next = this.internalQueue.poll();
        }
        return new Task((ImmutableSet<String>)ImmutableSet.copyOf(projectNames), toBeBuilt);
    }

    public class Task {
        private final ImmutableSet<String> projectNames;
        private final ToBeBuilt toBeBuilt;

        protected Task(ImmutableSet<String> projectNames, ToBeBuilt toBeBuilt) {
            this.projectNames = projectNames;
            this.toBeBuilt = toBeBuilt;
        }

        public boolean isEmpty() {
            return this.toBeBuilt.getToBeDeleted().isEmpty();
        }

        public void reschedule() {
            Set<URI> toBeDeleted = this.toBeBuilt.getToBeDeleted();
            if (toBeDeleted != null && !toBeDeleted.isEmpty()) {
                ToBeBuilt scheduleMe = new ToBeBuilt();
                scheduleMe.getToBeDeleted().addAll(toBeDeleted);
                ClosedProjectsQueue.this.insert((Set<String>)this.projectNames, scheduleMe);
            }
        }

        public ImmutableSet<String> getProjectNames() {
            return this.projectNames;
        }

        public ToBeBuilt getToBeBuilt() {
            return this.toBeBuilt;
        }
    }
}

