/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.internal.validation;

import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.html.core.internal.validate.HTMLValidationAdapterFactory;
import org.eclipse.wst.html.core.internal.validation.HTMLValidationReporter;
import org.eclipse.wst.html.core.internal.validation.HTMLValidator;
import org.eclipse.wst.html.core.internal.validation.LocalizedMessage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.validate.ValidationAdapter;
import org.eclipse.wst.sse.core.internal.validate.ValidationReporter;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Text;

public class HTMLSourceValidator
extends HTMLValidator
implements ISourceValidator {
    private IDocument fDocument;

    public void connect(IDocument document) {
        this.fDocument = document;
    }

    public void disconnect(IDocument document) {
        this.fDocument = null;
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        if (helper == null || this.fDocument == null) {
            return;
        }
        if (reporter != null && reporter.isCancelled()) {
            throw new OperationCanceledException();
        }
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
        if (model == null) {
            return;
        }
        try {
            IndexedRegion ir;
            IDOMDocument document = null;
            if (model instanceof IDOMModel) {
                document = ((IDOMModel)model).getDocument();
            }
            if (document == null || !this.hasHTMLFeature(document)) {
                return;
            }
            IPath filePath = null;
            IFile file = null;
            ITextFileBuffer fb = FileBufferModelManager.getInstance().getBuffer(this.fDocument);
            if (fb != null) {
                filePath = fb.getLocation();
                if (filePath.segmentCount() > 1 && !(file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath)).isAccessible()) {
                    file = null;
                }
            } else {
                filePath = new Path(model.getId());
            }
            if ((ir = this.getCoveringNode(dirtyRegion)) instanceof Text) {
                while (ir != null && ir instanceof Text) {
                    ir = model.getIndexedRegion(ir.getEndOffset());
                }
            }
            if (ir instanceof INodeNotifier) {
                HTMLValidationAdapterFactory factory = HTMLValidationAdapterFactory.getInstance();
                ValidationAdapter adapter = (ValidationAdapter)factory.adapt((INodeNotifier)ir);
                if (adapter == null) {
                    return;
                }
                if (reporter != null) {
                    HTMLValidationReporter rep = null;
                    rep = this.getReporter(reporter, file, (IDOMModel)model);
                    rep.clear();
                    adapter.setReporter((ValidationReporter)rep);
                    LocalizedMessage mess = new LocalizedMessage(4, filePath.toString().substring(1));
                    reporter.displaySubtask((IValidator)this, (IMessage)mess);
                }
                adapter.validate(ir);
            }
        }
        finally {
            this.releaseModel(model);
        }
    }

    private IndexedRegion getCoveringNode(IRegion dirtyRegion) {
        IndexedRegion largestRegion = null;
        if (this.fDocument instanceof IStructuredDocument) {
            IStructuredDocumentRegion[] regions = ((IStructuredDocument)this.fDocument).getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
            largestRegion = this.getLargest(regions);
        }
        return largestRegion;
    }

    private boolean hasHTMLFeature(IDOMDocument document) {
        DocumentTypeAdapter adapter = (DocumentTypeAdapter)document.getAdapterFor(DocumentTypeAdapter.class);
        if (adapter == null) {
            return false;
        }
        return adapter.hasFeature("HTML");
    }

    protected IndexedRegion getLargest(IStructuredDocumentRegion[] sdRegions) {
        if (sdRegions == null || sdRegions.length == 0) {
            return null;
        }
        IndexedRegion currentLargest = this.getCorrespondingNode(sdRegions[0]);
        int i = 0;
        while (i < sdRegions.length) {
            if (!sdRegions[i].isDeleted()) {
                IndexedRegion corresponding = this.getCorrespondingNode(sdRegions[i]);
                if (currentLargest instanceof Text) {
                    currentLargest = corresponding;
                }
                if (corresponding != null && !(corresponding instanceof Text) && corresponding.getStartOffset() <= currentLargest.getStartOffset() && corresponding.getEndOffset() >= currentLargest.getEndOffset()) {
                    currentLargest = corresponding;
                }
            }
            ++i;
        }
        return currentLargest;
    }

    protected IndexedRegion getCorrespondingNode(IStructuredDocumentRegion sdRegion) {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
        IndexedRegion indexedRegion = null;
        try {
            if (sModel != null) {
                indexedRegion = sModel.getIndexedRegion(sdRegion.getStart());
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return indexedRegion;
    }
}

