/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.text;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.util.Strings;

public class GenericTokenizer
implements Function<String, List<String>> {
    public List<String> apply(String input) {
        ArrayList result = Lists.newArrayList();
        if (!Strings.isEmpty((String)input)) {
            int lastOffset = 0;
            CharType lastType = CharType.get(input.charAt(0));
            int offset = 1;
            while (offset < input.length()) {
                char c = input.charAt(offset);
                CharType type = CharType.get(c);
                if (!type.canContinue(lastType)) {
                    String token = input.substring(lastOffset, offset);
                    result.add(token);
                    lastOffset = offset;
                    lastType = type;
                }
                ++offset;
            }
            String token = input.substring(lastOffset, input.length());
            result.add(token);
        }
        return result;
    }

    public static enum CharType {
        LETTER{

            @Override
            public boolean canContinue(CharType previous) {
                switch (previous) {
                    case LETTER: {
                        return true;
                    }
                }
                return false;
            }
        }
        ,
        NUMBER{

            @Override
            public boolean canContinue(CharType previous) {
                switch (previous) {
                    case LETTER: 
                    case NUMBER: {
                        return true;
                    }
                }
                return false;
            }
        }
        ,
        SPACE{

            @Override
            public boolean canContinue(CharType previous) {
                switch (previous) {
                    case SPACE: {
                        return true;
                    }
                }
                return false;
            }
        }
        ,
        SYMBOL{

            @Override
            public boolean canContinue(CharType previous) {
                return false;
            }
        };


        public static CharType get(char c) {
            switch (Character.getType(c)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return LETTER;
                }
                case 9: 
                case 10: 
                case 11: {
                    return NUMBER;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return SPACE;
                }
            }
            return SYMBOL;
        }

        public abstract boolean canContinue(CharType var1);
    }
}

