/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.utils;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.PlatformUI;

public class AutobuildUtils {
    private static final Logger LOG = LogManager.getLogger(AutobuildUtils.class);

    public static boolean get() {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    public static void turnOff() {
        AutobuildUtils.set(false);
    }

    public static void turnOn() {
        AutobuildUtils.set(true);
    }

    public static void set(boolean enable) {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription workspaceDescription = workspace.getDescription();
            if (workspaceDescription != null && workspaceDescription.isAutoBuilding() != enable) {
                workspaceDescription.setAutoBuilding(enable);
                try {
                    LOG.info((Object)("Turning auto-build " + (enable ? "on" : "off") + "..."));
                    workspace.setDescription(workspaceDescription);
                    LOG.info((Object)("Auto-build was successfully turned " + (enable ? "on" : "off") + "."));
                }
                catch (CoreException e) {
                    throw new IllegalStateException("Error while trying to turn workspace autobuild " + (enable ? "on" : "off") + ".", e);
                }
            }
        } else {
            LOG.info((Object)"Workbench is not running, cannot change autobuild settings.");
        }
    }

    public static ClosableAutobuild suppressAutobuild() {
        ClosableAutobuild closableAutobuild = new ClosableAutobuild(AutobuildUtils.get());
        AutobuildUtils.turnOff();
        return closableAutobuild;
    }

    public static class ClosableAutobuild
    implements AutoCloseable {
        private final boolean originalSetting;

        ClosableAutobuild(boolean originalSetting) {
            this.originalSetting = originalSetting;
        }

        @Override
        public void close() {
            AutobuildUtils.set(this.originalSetting);
        }
    }
}

