/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.highlighting;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.ui.codetemplates.templates.Codetemplate;
import org.eclipse.xtext.ui.codetemplates.templates.Codetemplates;
import org.eclipse.xtext.ui.codetemplates.templates.TemplatePart;
import org.eclipse.xtext.ui.codetemplates.templates.TemplatesPackage;
import org.eclipse.xtext.ui.codetemplates.templates.Variable;
import org.eclipse.xtext.ui.codetemplates.ui.evaluator.EvaluatedTemplate;
import org.eclipse.xtext.ui.codetemplates.ui.highlighting.TemplateBodyHighlighter;
import org.eclipse.xtext.ui.codetemplates.ui.registry.LanguageRegistry;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;

public class SemanticHighlighter
implements ISemanticHighlightingCalculator {
    @Inject
    private LanguageRegistry registry;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public void provideHighlightingFor(XtextResource resource, final IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        TemplateBodyHighlighter highlighter;
        if (resource == null || resource.getContents().isEmpty()) {
            return;
        }
        Codetemplates templates = (Codetemplates)resource.getContents().get(0);
        Grammar grammar = templates.getLanguage();
        if (grammar != null && !grammar.eIsProxy() && (highlighter = this.getHighlighter(grammar)) != null) {
            ContextTypeIdHelper helper = this.registry.getContextTypeIdHelper(grammar);
            ContextTypeRegistry contextTypeRegistry = this.registry.getContextTypeRegistry(grammar);
            for (Codetemplate template : templates.getTemplates()) {
                this.operationCanceledManager.checkCanceled(cancelIndicator);
                if (template.getBody() == null) continue;
                final EvaluatedTemplate evaluatedTemplate = new EvaluatedTemplate(template);
                highlighter.provideHighlightingFor(evaluatedTemplate.getMappedString(), new IHighlightedPositionAcceptor(){

                    public void addPosition(int offset, int length, String ... id) {
                        int beginOffset = evaluatedTemplate.getOriginalOffset(offset);
                        int endOffset = evaluatedTemplate.getOriginalOffset(offset + length);
                        int fixedLength = endOffset - beginOffset;
                        acceptor.addPosition(beginOffset, fixedLength, id);
                    }
                });
                String id = null;
                TemplateContextType contextType = null;
                if (template.getContext() != null && (id = helper.getId(template.getContext())) != null) {
                    contextType = contextTypeRegistry.getContextType(id);
                }
                HashSet defaultResolvers = Sets.newHashSet();
                if (contextType != null) {
                    UnmodifiableIterator resolvers = Iterators.filter((Iterator)contextType.resolvers(), TemplateVariableResolver.class);
                    while (resolvers.hasNext()) {
                        TemplateVariableResolver resolver = (TemplateVariableResolver)resolvers.next();
                        defaultResolvers.add(resolver.getType());
                    }
                }
                for (TemplatePart part : template.getBody().getParts()) {
                    Variable variable;
                    ICompositeNode node;
                    if (!(part instanceof Variable) || (node = NodeModelUtils.findActualNodeFor((EObject)(variable = (Variable)part))) == null) continue;
                    for (ILeafNode leafNode : node.getLeafNodes()) {
                        if (!(leafNode.getGrammarElement() instanceof Keyword)) continue;
                        acceptor.addPosition(leafNode.getTotalOffset(), leafNode.getTotalLength(), new String[]{"template.variable"});
                    }
                    List typeNodes = NodeModelUtils.findNodesForFeature((EObject)variable, (EStructuralFeature)TemplatesPackage.Literals.VARIABLE__TYPE);
                    if (typeNodes.isEmpty()) {
                        if (defaultResolvers.contains(variable.getName())) {
                            List nameNodes = NodeModelUtils.findNodesForFeature((EObject)variable, (EStructuralFeature)TemplatesPackage.Literals.VARIABLE__NAME);
                            for (INode nameNode : nameNodes) {
                                this.highlightNode(nameNode, "template.variable", acceptor);
                            }
                        }
                    } else {
                        INode nameNode;
                        nameNode = typeNodes.iterator();
                        while (nameNode.hasNext()) {
                            INode typeNode = (INode)nameNode.next();
                            this.highlightNode(typeNode, "template.variable", acceptor);
                        }
                    }
                    List parameterNodes = NodeModelUtils.findNodesForFeature((EObject)variable, (EStructuralFeature)TemplatesPackage.Literals.VARIABLE__PARAMETERS);
                    for (INode parameterNode : parameterNodes) {
                        this.highlightNode(parameterNode, "template.variable.argument", acceptor);
                    }
                }
            }
        }
    }

    protected TemplateBodyHighlighter getHighlighter(Grammar grammar) {
        return this.registry.getTemplateBodyHighlighter(grammar);
    }

    protected void highlightNode(INode node, String id, IHighlightedPositionAcceptor acceptor) {
        if (node == null) {
            return;
        }
        if (node instanceof ILeafNode) {
            ITextRegion textRegion = node.getTextRegion();
            acceptor.addPosition(textRegion.getOffset(), textRegion.getLength(), new String[]{id});
        } else {
            for (ILeafNode leaf : node.getLeafNodes()) {
                if (leaf.isHidden()) continue;
                ITextRegion leafRegion = leaf.getTextRegion();
                acceptor.addPosition(leafRegion.getOffset(), leafRegion.getLength(), new String[]{id});
            }
        }
    }
}

