/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.tests;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.ILinesExpectation;
import org.eclipse.xpect.runner.LiveExecutionType;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.runner.XpectRunner;
import org.eclipse.xpect.text.IRegion;
import org.eclipse.xpect.util.IssueVisualizer;
import org.eclipse.xpect.xtext.lib.setup.XtextStandaloneSetup;
import org.eclipse.xpect.xtext.lib.setup.XtextWorkspaceSetup;
import org.eclipse.xpect.xtext.lib.tests.ValidationTestConfig;
import org.eclipse.xpect.xtext.lib.tests.ValidationTestModuleSetup;
import org.eclipse.xpect.xtext.lib.util.IssueFormatter;
import org.eclipse.xpect.xtext.lib.util.NextLine;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.Issue;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.runner.RunWith;

@RunWith(value=XpectRunner.class)
@XpectImport(value={XtextStandaloneSetup.class, XtextWorkspaceSetup.class, ValidationTestModuleSetup.class, ValidationTestModuleSetup.IssuesByLineProvider.class, ValidationTestConfig.class})
public class ValidationTest {
    protected Function<? super Issue, String> createIssueFormatter(CharSequence document) {
        return new IssueFormatter(document, false);
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.ERROR})
    public void errors(ILinesExpectation expectation, @ValidationTestModuleSetup.IssuesByLine Multimap<IRegion, Issue> line2issue, @NextLine IRegion line, ValidationTestConfig cfg) {
        List<String> issues = this.getActualIssues(line2issue, line, cfg, Severity.ERROR);
        expectation.assertEquals(issues);
    }

    protected List<String> getActualIssues(Multimap<IRegion, Issue> line2issue, IRegion line, ValidationTestConfig cfg, Severity ... severities) {
        Collection issuesInLine = line2issue.get((Object)line);
        ArrayList filteredIssues = Lists.newArrayList((Iterable)Iterables.filter((Iterable)issuesInLine, (Predicate)Predicates.and((Predicate)new ValidationTestModuleSetup.SeverityPredicate(severities), cfg.getIgnoreFilter())));
        ArrayList formattedIssues = Lists.newArrayList((Iterable)Iterables.transform((Iterable)filteredIssues, this.createIssueFormatter(line.getDocument())));
        if (formattedIssues.isEmpty()) {
            Assert.fail((String)("No issues found in line " + line));
        }
        return formattedIssues;
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.INFO})
    public void infos(ILinesExpectation expectation, @ValidationTestModuleSetup.IssuesByLine Multimap<IRegion, Issue> line2issue, @NextLine IRegion line, ValidationTestConfig cfg) {
        List<String> issues = this.getActualIssues(line2issue, line, cfg, Severity.INFO);
        expectation.assertEquals(issues);
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.INFO, Severity.ERROR, Severity.WARNING})
    public void issues(ILinesExpectation expectation, @ValidationTestModuleSetup.IssuesByLine Multimap<IRegion, Issue> line2issue, @NextLine IRegion line, ValidationTestConfig cfg) {
        List<String> issues = this.getActualIssues(line2issue, line, cfg, Severity.INFO, Severity.ERROR, Severity.WARNING);
        expectation.assertEquals(issues);
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.INFO, Severity.ERROR, Severity.WARNING})
    public void noIssues(@ValidationTestModuleSetup.IssuesByLine Multimap<IRegion, Issue> line2issue, @NextLine IRegion line) {
        this.assertNoIssuesInLine(line2issue, line, Severity.INFO, Severity.ERROR, Severity.WARNING);
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.ERROR})
    public void noErrors(@ValidationTestModuleSetup.IssuesByLine Multimap<IRegion, Issue> line2issue, @NextLine IRegion line) {
        this.assertNoIssuesInLine(line2issue, line, Severity.ERROR);
    }

    @Xpect
    @Deprecated
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.ERROR})
    public void noerrors(@ValidationTestModuleSetup.IssuesByLine Multimap<IRegion, Issue> line2issue, @NextLine IRegion line) {
        this.assertNoIssuesInLine(line2issue, line, Severity.ERROR);
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.WARNING})
    public void noWarnings(@ValidationTestModuleSetup.IssuesByLine Multimap<IRegion, Issue> line2issue, @NextLine IRegion line) {
        this.assertNoIssuesInLine(line2issue, line, Severity.WARNING);
    }

    @Xpect
    @Deprecated
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.WARNING})
    public void nowarnings(@ValidationTestModuleSetup.IssuesByLine Multimap<IRegion, Issue> line2issue, @NextLine IRegion line) {
        this.assertNoIssuesInLine(line2issue, line, Severity.WARNING);
    }

    protected void assertNoIssuesInLine(Multimap<IRegion, Issue> line2issue, IRegion line, Severity ... serverities) throws ComparisonFailure {
        Collection issues = line2issue.get((Object)line);
        if (!issues.isEmpty()) {
            String document = line.getDocument().toString();
            String visualized = new IssueVisualizer().visualize(document, issues);
            throw new ComparisonFailure("no Issues expected, but found:", document, visualized);
        }
    }

    @Xpect(liveExecution=LiveExecutionType.FAST)
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.WARNING})
    public void warnings(ILinesExpectation expectation, @ValidationTestModuleSetup.IssuesByLine Multimap<IRegion, Issue> line2issue, @NextLine IRegion line, ValidationTestConfig cfg) {
        List<String> issues = this.getActualIssues(line2issue, line, cfg, Severity.WARNING);
        expectation.assertEquals(issues);
    }
}

