/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.conversion;

import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.conversion.impl.STRINGValueConverter;
import org.eclipse.xtext.nodemodel.INode;

public class JSONSTRINGValueConverter
extends STRINGValueConverter {
    protected String convertFromString(String literal, INode node) throws ValueConverterWithValueException {
        char aChar;
        char[] convtBuf;
        char[] in = literal.toCharArray();
        int off = 1;
        int len = literal.length() - 1;
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        String errorMessage = null;
        int errorIndex = -1;
        int errorLength = -1;
        block16: while (off < end - 1) {
            if ((aChar = in[off++]) == '\\') {
                if (off < end) {
                    aChar = in[off++];
                    switch (aChar) {
                        case 'u': {
                            int value = 0;
                            if (off + 4 > end || !this.isHexSequence(in, off, 4)) {
                                out[outLen++] = aChar;
                                if (errorMessage != null) continue block16;
                                errorMessage = "Invalid unicode";
                                errorIndex = off - 2;
                                errorLength = 2;
                                break;
                            }
                            int i = 0;
                            while (i < 4) {
                                aChar = in[off++];
                                switch (aChar) {
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        value = (value << 4) + aChar - 48;
                                        break;
                                    }
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': {
                                        value = (value << 4) + 10 + aChar - 97;
                                        break;
                                    }
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': {
                                        value = (value << 4) + 10 + aChar - 65;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                }
                                ++i;
                            }
                            out[outLen++] = (char)value;
                            break;
                        }
                        case 't': {
                            out[outLen++] = 9;
                            break;
                        }
                        case 'r': {
                            out[outLen++] = 13;
                            break;
                        }
                        case 'n': {
                            out[outLen++] = 10;
                            break;
                        }
                        case 'f': {
                            out[outLen++] = 12;
                            break;
                        }
                        case 'b': {
                            out[outLen++] = 8;
                            break;
                        }
                        case '\"': {
                            out[outLen++] = 34;
                            break;
                        }
                        case '\\': {
                            out[outLen++] = 92;
                            break;
                        }
                        case '/': {
                            out[outLen++] = 47;
                            break;
                        }
                        default: {
                            if (errorMessage == null) {
                                errorMessage = this.getInvalidEscapeSequenceMessage();
                                errorIndex = off - 2;
                                errorLength = 2;
                            }
                            out[outLen++] = aChar;
                            break;
                        }
                    }
                    continue;
                }
                if (errorMessage == null) {
                    errorMessage = this.getInvalidEscapeSequenceMessage();
                    errorIndex = off - 1;
                    errorLength = 1;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        if (off < end) {
            if (off != end - 1) {
                throw new IllegalStateException();
            }
            aChar = in[off];
            if (in[0] != in[off]) {
                out[outLen++] = aChar;
                if (errorMessage == null) {
                    if (in[off] == '\\') {
                        errorMessage = this.getInvalidEscapeSequenceMessage();
                        errorIndex = off;
                        errorLength = 1;
                    } else {
                        errorMessage = this.getStringNotClosedMessage();
                    }
                } else {
                    errorMessage = this.getStringNotClosedMessage();
                    errorIndex = -1;
                    errorLength = -1;
                }
            }
        }
        if (errorMessage != null) {
            throw new ValueConverterWithValueException(errorMessage, node, (Object)new String(out, 0, outLen), errorIndex, errorLength, null);
        }
        return new String(out, 0, outLen);
    }

    protected String getInvalidEscapeSequenceMessage() {
        return "Invalid escape sequence (valid ones are  \\\"  \\\\ \\/ \\b  \\f  \\n  \\r  \\t)";
    }
}

