/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.runner.exceptions.DependencyCycleDetectedException;
import org.eclipse.n4js.runner.exceptions.InsolvableRuntimeEnvironmentException;
import org.eclipse.n4js.runner.extension.RuntimeEnvironment;
import org.eclipse.n4js.utils.DependencyCycle;
import org.eclipse.n4js.utils.DependencyTraverser;
import org.eclipse.n4js.validation.helper.SourceContainerAwareDependencyProvider;

public class RuntimeEnvironmentsHelper {
    private static final Logger LOGGER = Logger.getLogger(RuntimeEnvironmentsHelper.class);
    @Inject
    private IN4JSCore in4jscore;

    public Optional<IN4JSProject> findRuntimeEnvironmentProject(RuntimeEnvironment runtimeEnvironment) {
        return this.findRuntimeEnvironmentProject(runtimeEnvironment, this.getAllProjects());
    }

    public Optional<IN4JSProject> findRuntimeEnvironmentProject(RuntimeEnvironment runtimeEnvironment, Iterable<IN4JSProject> projects) {
        return FluentIterable.from(projects).filter(p -> RuntimeEnvironmentsHelper.isRuntimeEnvironment(p)).filter(p -> runtimeEnvironment.getProjectName().equals(p.getProjectName())).first();
    }

    public Set<RuntimeEnvironment> findCompatibleRuntimeEnvironments(IN4JSProject project) {
        if (RuntimeEnvironmentsHelper.isRuntimeEnvironment(project) || RuntimeEnvironmentsHelper.isRuntimeLibrary(project)) {
            throw new InsolvableRuntimeEnvironmentException(project);
        }
        ImmutableList<IN4JSProject> reqRuntimeLibraries = this.collectRequiredRuntimeLibraries(project);
        return FluentIterable.from(this.getAllProjects()).filter(p -> RuntimeEnvironmentsHelper.isRuntimeEnvironment(p)).transform(p -> new AbstractMap.SimpleEntry<IN4JSProject, List<IN4JSProject>>((IN4JSProject)p, this.getProjectProvidedRuntimeLibraries((IN4JSProject)p))).filter(e -> ((List)e.getValue()).containsAll((Collection<?>)reqRuntimeLibraries)).transform(e -> (IN4JSProject)e.getKey()).transformAndConcat(re -> this.getRuntimeEnvironmentAndAllExtendedEnvironments((IN4JSProject)re)).transform(rRE -> RuntimeEnvironment.fromProjectName(rRE.getProjectName())).filter(rRE -> rRE != null).toSet();
    }

    public Set<IN4JSProject> getRuntimeEnvironmentAndAllExtendedEnvironments(IN4JSProject project) {
        if (!project.getProjectType().equals((Object)ProjectType.RUNTIME_ENVIRONMENT)) {
            return null;
        }
        HashSet<IN4JSProject> allREs = new HashSet<IN4JSProject>(this.getExtendedRuntimeEnvironments(project));
        allREs.add(project);
        return allREs;
    }

    private ImmutableList<IN4JSProject> collectRequiredRuntimeLibraries(IN4JSProject project) {
        HashSet<IN4JSProject> runtimeLibraryDependencies = new HashSet<IN4JSProject>();
        ProjectsCollectingDependencyVisitor visitor = new ProjectsCollectingDependencyVisitor(runtimeLibraryDependencies, p -> RuntimeEnvironmentsHelper.isRuntimeLibrary(p));
        DependencyTraverser traverser = new DependencyTraverser((Object)project, (DependencyTraverser.DependencyVisitor)visitor, (DependencyTraverser.DependencyProvider)new SourceContainerAwareDependencyProvider(true), true);
        DependencyCycle result = traverser.findCycle();
        if (result.hasCycle()) {
            throw new DependencyCycleDetectedException(project);
        }
        return ImmutableList.copyOf(runtimeLibraryDependencies);
    }

    private List<IN4JSProject> getProjectProvidedRuntimeLibraries(IN4JSProject runtimeEnvironment) {
        HashSet<IN4JSProject> providedRuntimeLibraries = new HashSet<IN4JSProject>();
        if (RuntimeEnvironmentsHelper.isRuntimeEnvironment(runtimeEnvironment)) {
            this.collectProvidedRuntimeLibraries(runtimeEnvironment, providedRuntimeLibraries);
        }
        this.collectRuntimeLibrariesFromExtendedRuntimeEnvironments(runtimeEnvironment, providedRuntimeLibraries);
        return new ArrayList<IN4JSProject>(providedRuntimeLibraries);
    }

    private void collectRuntimeLibrariesFromExtendedRuntimeEnvironments(IN4JSProject runtimeEnvironment, Collection<IN4JSProject> collection) {
        for (IN4JSProject extendedRuntimeEnvironment : this.getExtendedRuntimeEnvironments(runtimeEnvironment)) {
            this.collectProvidedRuntimeLibraries(extendedRuntimeEnvironment, collection);
        }
    }

    private void collectProvidedRuntimeLibraries(IN4JSProject project, Collection<IN4JSProject> collection) {
        ProjectsCollectingDependencyVisitor visitor = new ProjectsCollectingDependencyVisitor(collection, s -> RuntimeEnvironmentsHelper.isRuntimeLibrary(s));
        DependencyTraverser.DependencyProvider dependencyProvider = p -> p.getProvidedRuntimeLibraries();
        DependencyTraverser traverser = new DependencyTraverser((Object)project, (DependencyTraverser.DependencyVisitor)visitor, dependencyProvider, true);
        traverser.traverse();
    }

    public boolean containsAllCompatible(List<RuntimeEnvironment> runnerEnvironments, List<RuntimeEnvironment> requiredEnvironments) {
        if (runnerEnvironments.isEmpty() || requiredEnvironments.isEmpty()) {
            LOGGER.debug((Object)"cannot compare empty runtime environments lists");
            return false;
        }
        if (runnerEnvironments.containsAll(requiredEnvironments)) {
            return true;
        }
        boolean result = true;
        ImmutableList allRuntimeEnvironments = FluentIterable.from(this.getAllProjects()).filter(p -> RuntimeEnvironmentsHelper.isRuntimeEnvironment(p)).toList();
        Map<IN4JSProject, List> reExtendedEnvironments = allRuntimeEnvironments.stream().collect(Collectors.toMap(e -> e, arg_0 -> this.lambda$14((List)allRuntimeEnvironments, arg_0)));
        Iterator<RuntimeEnvironment> iterRuntimeEnvironment = runnerEnvironments.iterator();
        while (result && iterRuntimeEnvironment.hasNext()) {
            RuntimeEnvironment re = iterRuntimeEnvironment.next();
            List listExtendedEnvironments = reExtendedEnvironments.keySet().stream().filter(p -> p.getProjectName().equals(re.getProjectName())).collect(Collectors.toList());
            if (listExtendedEnvironments.size() != 1) {
                LOGGER.debug((Object)("Multiple projects with name " + re.getProjectName() + " : " + listExtendedEnvironments.stream().map(p -> p.getProjectName()).reduce(new String(), (r, e) -> {
                    r = String.valueOf(r) + ", " + e;
                    return r;
                })));
                LOGGER.error((Object)("Cannot obtain project for name " + re.getProjectName()));
                return false;
            }
            IN4JSProject extendedRuntimeEnvironment = (IN4JSProject)listExtendedEnvironments.get(0);
            List listExtendedEnvironemntsNames = reExtendedEnvironments.get(extendedRuntimeEnvironment);
            boolean bl = result = result && requiredEnvironments.stream().map(bre -> bre.getProjectName()).allMatch(breName -> listExtendedEnvironemntsNames.contains(breName));
        }
        return result;
    }

    private List<String> getExtendedRuntimeEnvironmentsIds(IN4JSProject runtimeEnv, List<IN4JSProject> allRuntimeEnv) {
        return this.getExtendedRuntimeEnvironments(runtimeEnv).stream().map(p -> p.getProjectName()).collect(Collectors.toList());
    }

    private List<IN4JSProject> getExtendedRuntimeEnvironments(IN4JSProject runtimeEnvironment) {
        ArrayList<IN4JSProject> runtimeEnvironments = new ArrayList<IN4JSProject>();
        Optional extended = runtimeEnvironment.getExtendedRuntimeEnvironmentId();
        while (extended.isPresent()) {
            String id = (String)extended.get();
            ImmutableList extendedRE = FluentIterable.from(this.getAllProjects()).filter(p -> id.equals(p.getProjectName())).toList();
            if (extendedRE.isEmpty()) break;
            if (extendedRE.size() > 1) {
                LOGGER.debug((Object)("multiple projects match id " + id));
            }
            IN4JSProject extendedRuntimeEnvironment = (IN4JSProject)extendedRE.get(0);
            runtimeEnvironments.add(extendedRuntimeEnvironment);
            extended = extendedRuntimeEnvironment.getExtendedRuntimeEnvironmentId();
        }
        return runtimeEnvironments;
    }

    private static boolean isRuntimeEnvironment(IN4JSProject project) {
        return ProjectType.RUNTIME_ENVIRONMENT.equals((Object)project.getProjectType());
    }

    private static boolean isRuntimeLibrary(IN4JSProject project) {
        return ProjectType.RUNTIME_LIBRARY.equals((Object)project.getProjectType());
    }

    private Iterable<IN4JSProject> getAllProjects() {
        return this.in4jscore.findAllProjects();
    }

    private /* synthetic */ List lambda$14(List list, IN4JSProject e) {
        return this.getExtendedRuntimeEnvironmentsIds(e, list);
    }

    private final class ProjectsCollectingDependencyVisitor
    implements DependencyTraverser.DependencyVisitor<IN4JSProject> {
        private final Collection<IN4JSProject> collectedProjects;
        private final Predicate<IN4JSProject> projectFilter;

        private ProjectsCollectingDependencyVisitor(Collection<IN4JSProject> depsRuntimeLibraries, Predicate<IN4JSProject> projectFilter) {
            this.projectFilter = projectFilter;
            this.collectedProjects = depsRuntimeLibraries;
        }

        public void accept(IN4JSProject p) {
            if (this.projectFilter.test(p)) {
                this.collectedProjects.add(p);
            }
        }
    }
}

