/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.compileTime;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.compileTime.CompileTimeEvaluationError;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TObjectPrototype;

public abstract class CompileTimeValue {
    public static final int PRECISION_OF_DIVISION = 16;
    private static final MathContext MATH_CONTEXT_FOR_DIVISON = new MathContext(16, RoundingMode.DOWN);
    public static final CompileTimeValue UNDEFINED = new ValueValid<String>("undefined"){};
    public static final CompileTimeValue NULL = new ValueValid<String>("null"){};
    public static final ValueBoolean TRUE = new ValueBoolean(true);
    public static final ValueBoolean FALSE = new ValueBoolean(false);

    private CompileTimeValue() {
    }

    public abstract boolean isValid();

    public static ValueInvalid error() {
        return new ValueInvalid(new CompileTimeEvaluationError[0]);
    }

    public static ValueInvalid error(String message) {
        return CompileTimeValue.error(message, null, null);
    }

    public static ValueInvalid error(String message, EObject astNode) {
        return CompileTimeValue.error(message, astNode, null);
    }

    public static ValueInvalid error(String message, EObject astNode, EStructuralFeature feature) {
        Objects.requireNonNull(message);
        return CompileTimeValue.error(new CompileTimeEvaluationError(message, astNode, feature));
    }

    public static ValueInvalid error(CompileTimeEvaluationError ... errors) {
        return new ValueInvalid(errors);
    }

    public static CompileTimeValue of(Object value) {
        if (value instanceof CompileTimeValue) {
            return (CompileTimeValue)value;
        }
        if (value instanceof Boolean) {
            return CompileTimeValue.of((Boolean)value);
        }
        if (value instanceof String) {
            return CompileTimeValue.of((String)value);
        }
        if (value instanceof Number) {
            return CompileTimeValue.of((Number)value);
        }
        if (value instanceof BigDecimal) {
            return CompileTimeValue.of((BigDecimal)value);
        }
        if (value instanceof TField) {
            return CompileTimeValue.of((TField)value);
        }
        return CompileTimeValue.error();
    }

    public static CompileTimeValue of(Boolean value) {
        return value != null ? (value.booleanValue() ? TRUE : FALSE) : CompileTimeValue.error();
    }

    public static CompileTimeValue of(String value) {
        return value != null ? new ValueString(value) : CompileTimeValue.error();
    }

    public static CompileTimeValue of(Number value) {
        return value != null ? CompileTimeValue.of(BigDecimal.valueOf(value.doubleValue())) : CompileTimeValue.error();
    }

    public static CompileTimeValue of(BigDecimal value) {
        return value != null ? new ValueNumber(value) : CompileTimeValue.error();
    }

    public static CompileTimeValue of(TField value) {
        if (value != null) {
            EObject parent = value.eContainer();
            if (!(parent instanceof TObjectPrototype && "Symbol".equals(((TObjectPrototype)parent).getName()) && N4Scheme.isFromResourceWithN4Scheme((EObject)parent))) {
                throw new IllegalArgumentException("given TField does not represent a built-in symbol");
            }
            return new ValueSymbol(value.getName());
        }
        return CompileTimeValue.error();
    }

    public static CompileTimeValue invert(CompileTimeValue value, EObject astNode) {
        ValueInvalid invalid = CompileTimeValue.requireValueType(value, ValueBoolean.class, "operand must be a boolean", astNode);
        if (invalid != null) {
            return invalid;
        }
        return ((ValueBoolean)value).invert();
    }

    public static CompileTimeValue and(CompileTimeValue valueLeft, CompileTimeValue valueRight, EObject astNodeLeft, EObject astNodeRight) {
        ValueInvalid invalid = CompileTimeValue.combineErrors(CompileTimeValue.requireValueType(valueLeft, ValueBoolean.class, "left operand must be a boolean", astNodeLeft), CompileTimeValue.requireValueType(valueRight, ValueBoolean.class, "right operand must be a boolean", astNodeRight));
        if (invalid != null) {
            return invalid;
        }
        return CompileTimeValue.of((Boolean)((ValueBoolean)valueLeft).getValue() != false && (Boolean)((ValueBoolean)valueRight).getValue() != false);
    }

    public static CompileTimeValue or(CompileTimeValue valueLeft, CompileTimeValue valueRight, EObject astNodeLeft, EObject astNodeRight) {
        ValueInvalid invalid = CompileTimeValue.combineErrors(CompileTimeValue.requireValueType(valueLeft, ValueBoolean.class, "left operand must be a boolean", astNodeLeft), CompileTimeValue.requireValueType(valueRight, ValueBoolean.class, "right operand must be a boolean", astNodeRight));
        if (invalid != null) {
            return invalid;
        }
        return CompileTimeValue.of((Boolean)((ValueBoolean)valueLeft).getValue() != false || (Boolean)((ValueBoolean)valueRight).getValue() != false);
    }

    public static CompileTimeValue negate(CompileTimeValue value, EObject astNode) {
        ValueInvalid invalid = CompileTimeValue.requireValueType(value, ValueNumber.class, "operand must be a number", astNode);
        if (invalid != null) {
            return invalid;
        }
        return ((ValueNumber)value).negate();
    }

    public static CompileTimeValue add(CompileTimeValue valueLeft, CompileTimeValue valueRight, EObject astNode) {
        if (valueLeft == null || !valueLeft.isValid() || valueRight == null || !valueRight.isValid()) {
            return CompileTimeValue.combineErrors(CompileTimeValue.error(), valueLeft, valueRight);
        }
        if (valueLeft instanceof ValueNumber && valueRight instanceof ValueNumber) {
            return CompileTimeValue.of(((BigDecimal)((ValueNumber)valueLeft).getValue()).add((BigDecimal)((ValueNumber)valueRight).getValue()));
        }
        if (valueLeft.isValid() && valueRight.isValid() && (valueLeft instanceof ValueString || valueRight instanceof ValueString)) {
            return CompileTimeValue.of(String.valueOf(valueLeft.toString()) + valueRight.toString());
        }
        return CompileTimeValue.error("one of the operands must be a string or both must be a number", astNode);
    }

    public static CompileTimeValue subtract(CompileTimeValue valueLeft, CompileTimeValue valueRight, EObject astNodeLeft, EObject astNodeRight) {
        ValueInvalid invalid = CompileTimeValue.combineErrors(CompileTimeValue.requireValueType(valueLeft, ValueNumber.class, "left operand must be a number", astNodeLeft), CompileTimeValue.requireValueType(valueRight, ValueNumber.class, "right operand must be a number", astNodeRight));
        if (invalid != null) {
            return invalid;
        }
        return CompileTimeValue.of(((BigDecimal)((ValueNumber)valueLeft).getValue()).subtract((BigDecimal)((ValueNumber)valueRight).getValue()));
    }

    public static CompileTimeValue multiply(CompileTimeValue valueLeft, CompileTimeValue valueRight, EObject astNodeLeft, EObject astNodeRight) {
        ValueInvalid invalid = CompileTimeValue.combineErrors(CompileTimeValue.requireValueType(valueLeft, ValueNumber.class, "left operand must be a number", astNodeLeft), CompileTimeValue.requireValueType(valueRight, ValueNumber.class, "right operand must be a number", astNodeRight));
        if (invalid != null) {
            return invalid;
        }
        return CompileTimeValue.of(((BigDecimal)((ValueNumber)valueLeft).getValue()).multiply((BigDecimal)((ValueNumber)valueRight).getValue()));
    }

    public static CompileTimeValue divide(CompileTimeValue valueLeft, CompileTimeValue valueRight, EObject astNodeLeft, EObject astNodeRight) {
        ValueInvalid invalid = CompileTimeValue.combineErrors(CompileTimeValue.requireValueType(valueLeft, ValueNumber.class, "left operand must be a number", astNodeLeft), CompileTimeValue.requireValueType(valueRight, ValueNumber.class, "right operand must be a number", astNodeRight));
        if (invalid != null) {
            return invalid;
        }
        if (((ValueNumber)valueRight).isZero()) {
            return CompileTimeValue.error("division by zero not allowed in compile-time expressions", astNodeRight);
        }
        BigDecimal decimalLeft = (BigDecimal)((ValueNumber)valueLeft).getValue();
        BigDecimal decimalRight = (BigDecimal)((ValueNumber)valueRight).getValue();
        return CompileTimeValue.of(decimalLeft.divide(decimalRight, MATH_CONTEXT_FOR_DIVISON));
    }

    public static CompileTimeValue remainder(CompileTimeValue valueLeft, CompileTimeValue valueRight, EObject astNodeLeft, EObject astNodeRight) {
        ValueInvalid invalid = CompileTimeValue.combineErrors(CompileTimeValue.requireValueType(valueLeft, ValueNumber.class, "left operand must be a number", astNodeLeft), CompileTimeValue.requireValueType(valueRight, ValueNumber.class, "right operand must be a number", astNodeRight));
        if (invalid != null) {
            return invalid;
        }
        if (((ValueNumber)valueRight).isZero()) {
            return CompileTimeValue.error("division by zero not allowed in compile-time expressions", astNodeRight);
        }
        return CompileTimeValue.of(((BigDecimal)((ValueNumber)valueLeft).getValue()).remainder((BigDecimal)((ValueNumber)valueRight).getValue()));
    }

    public static ValueInvalid combineErrors(CompileTimeValue ... values) {
        boolean foundInvalid = false;
        LinkedList<CompileTimeEvaluationError> errors = new LinkedList<CompileTimeEvaluationError>();
        CompileTimeValue[] compileTimeValueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            CompileTimeValue currValue = compileTimeValueArray[n2];
            if (currValue != null && !currValue.isValid()) {
                foundInvalid = true;
                errors.addAll(((ValueInvalid)currValue).getErrors());
            }
            ++n2;
        }
        return foundInvalid ? new ValueInvalid(errors.toArray(new CompileTimeEvaluationError[errors.size()])) : null;
    }

    public static ValueInvalid requireValueType(CompileTimeValue value, Class<? extends ValueValid<?>> expectedType, String message, EObject astNode) {
        if (value == null) {
            return CompileTimeValue.error("missing value", astNode);
        }
        if (value instanceof ValueInvalid) {
            return (ValueInvalid)value;
        }
        if (value.getClass() != expectedType) {
            return message != null && astNode != null ? CompileTimeValue.error(message, astNode) : CompileTimeValue.error();
        }
        return null;
    }

    public static String serialize(CompileTimeValue value) {
        if (value == null) {
            return null;
        }
        if (!value.isValid()) {
            return null;
        }
        if (value == UNDEFINED || value == NULL) {
            return value.toString();
        }
        if (value instanceof ValueBoolean) {
            return "?" + value;
        }
        if (value instanceof ValueString) {
            return "\"" + value;
        }
        if (value instanceof ValueNumber) {
            return "#" + value;
        }
        if (value instanceof ValueSymbol) {
            return "$" + (String)((ValueSymbol)value).getValue();
        }
        throw new UnsupportedOperationException("unknown subclass of CompileTimeValue: " + value);
    }

    public static CompileTimeValue deserialize(String str) {
        if (str == null) {
            return CompileTimeValue.error();
        }
        if (UNDEFINED.toString().equals(str)) {
            return UNDEFINED;
        }
        if (NULL.toString().equals(str)) {
            return NULL;
        }
        if (str.length() > 0) {
            char head = str.charAt(0);
            String tail = str.substring(1);
            switch (head) {
                case '?': {
                    if ("true".equalsIgnoreCase(tail)) {
                        return TRUE;
                    }
                    if (!"false".equalsIgnoreCase(tail)) break;
                    return FALSE;
                }
                case '\"': {
                    return CompileTimeValue.of(tail);
                }
                case '#': {
                    return new ValueNumber(new BigDecimal(tail));
                }
                case '$': {
                    return new ValueSymbol(tail);
                }
            }
        }
        throw new UnsupportedOperationException("cannot deserialize CompileTimeValue from string: " + str);
    }

    public static final class ValueBoolean
    extends ValueValid<Boolean> {
        private ValueBoolean(Boolean value) {
            super(value);
        }

        public ValueBoolean invert() {
            return (ValueBoolean)ValueBoolean.of((Boolean)this.getValue() == false);
        }
    }

    public static final class ValueInvalid
    extends CompileTimeValue {
        private final CompileTimeEvaluationError[] errors;

        public ValueInvalid(CompileTimeEvaluationError ... errors) {
            Objects.requireNonNull(errors);
            this.errors = Arrays.copyOf(errors, errors.length);
        }

        public List<CompileTimeEvaluationError> getErrors() {
            return Collections.unmodifiableList(Arrays.asList(this.errors));
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }

    public static final class ValueNumber
    extends ValueValid<BigDecimal> {
        private ValueNumber(BigDecimal value) {
            super(value.stripTrailingZeros());
        }

        public boolean isZero() {
            return ((BigDecimal)this.getValue()).compareTo(BigDecimal.ZERO) == 0;
        }

        public ValueNumber negate() {
            return (ValueNumber)ValueNumber.of(((BigDecimal)this.getValue()).negate());
        }
    }

    public static final class ValueString
    extends ValueValid<String> {
        private ValueString(String value) {
            super(value);
        }
    }

    public static final class ValueSymbol
    extends ValueValid<String> {
        private ValueSymbol(String symbolName) {
            super(symbolName);
        }

        @Override
        public String toString() {
            return "#" + (String)this.getValue();
        }
    }

    public static abstract class ValueValid<T>
    extends CompileTimeValue {
        private final T value;

        private ValueValid(T value) {
            Objects.requireNonNull(value);
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        public T getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass() && this.value.equals(((ValueValid)obj).value);
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

