/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries.nodejs;

import com.google.common.base.StandardSystemProperty;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.BinariesConstants;
import org.eclipse.n4js.binaries.BinariesPreferenceStore;
import org.eclipse.n4js.binaries.BinariesValidator;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.semver.Semver.VersionNumber;

@Singleton
public class NpmrcBinary
implements Binary {
    private static final String NPM_CONFIG_USERCONFIG = "NPM_CONFIG_userconfig";
    private String memoizedCalculatedNpmrcPath = null;
    @Inject
    private BinariesValidator validator;
    @Inject
    private Provider<NpmBinary> npmBinaryProvider;
    @Inject
    private BinariesPreferenceStore preferenceStore;

    @Override
    public String getId() {
        return NpmrcBinary.class.getName();
    }

    @Override
    public String getLabel() {
        return "npmrc";
    }

    @Override
    public String getDescription() {
        return "Configuration of the folder location of the .npmrc file can be provided here. If not given, then the location will be resolved to '" + this.getDefaultNpmrcPath() + "'. The required minimum version npm is '" + BinariesConstants.NPM_MIN_VERSION + "'.";
    }

    @Override
    public VersionNumber getMinimumVersion() {
        return null;
    }

    @Override
    public String getBinaryAbsolutePath() {
        return String.valueOf(this.getUserNodePathOrDefault()) + File.separator + ".npmrc";
    }

    @Override
    public String getVersionArgument() {
        return "-v";
    }

    @Override
    public Binary getParent() {
        return (Binary)this.npmBinaryProvider.get();
    }

    @Override
    public Iterable<Binary> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> updateEnvironment(Map<String, String> environment) {
        String additionalNodePath = String.valueOf(this.getUserNodePathOrDefault()) + File.separator + ".npmrc";
        environment.put(NPM_CONFIG_USERCONFIG, additionalNodePath);
        return environment;
    }

    @Override
    public URI getUserConfiguredLocation() {
        return this.preferenceStore.getPath(this);
    }

    @Override
    public IStatus validate() {
        IStatus parentStatus;
        Binary parent = this.getParent();
        if (parent != null && !(parentStatus = parent.validate()).isOK()) {
            return parentStatus;
        }
        return this.validator.validateBinaryFile(this);
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NpmrcBinary)) {
            return false;
        }
        NpmrcBinary other = (NpmrcBinary)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    String getUserNodePathOrDefault() {
        URI userConfiguredLocation = this.getUserConfiguredLocation();
        return userConfiguredLocation == null ? this.getDefaultNpmrcPath() : new File(userConfiguredLocation).getAbsolutePath();
    }

    private String getDefaultNpmrcPath() {
        if (this.memoizedCalculatedNpmrcPath == null) {
            this.memoizedCalculatedNpmrcPath = StandardSystemProperty.USER_HOME.value();
        }
        return this.memoizedCalculatedNpmrcPath;
    }
}

