/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.projectDescription.ModuleFilter;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.utils.WildcardPathFilterHelper;
import org.eclipse.xtext.resource.IResourceDescription;

public abstract class AbstractN4JSCore
implements IN4JSCore {
    @Inject
    private WildcardPathFilterHelper wildcardHelper;

    @Override
    public int getDepthOfLocation(URI nestedLocation) {
        IN4JSProject containingProject = (IN4JSProject)this.findProject(nestedLocation).orNull();
        if (containingProject == null || !containingProject.exists()) {
            return -1;
        }
        URI containingProjectLocation = containingProject.getLocation();
        while (Objects.equals(nestedLocation.lastSegment(), "")) {
            nestedLocation = nestedLocation.trimSegments(1);
        }
        while (Objects.equals(containingProjectLocation.lastSegment(), "")) {
            containingProjectLocation = containingProjectLocation.trimSegments(1);
        }
        return nestedLocation.segmentCount() - containingProjectLocation.segmentCount();
    }

    @Override
    public boolean isInSameProject(URI nestedLocation1, URI nestedLocation2) {
        Optional<? extends IN4JSProject> project1 = this.findProject(nestedLocation1);
        if (project1.isPresent()) {
            Optional<? extends IN4JSProject> project2 = this.findProject(nestedLocation2);
            return project2.isPresent() && ((IN4JSProject)project1.get()).equals(project2.get());
        }
        return false;
    }

    @Override
    public boolean isNoValidate(URI nestedLocation) {
        boolean noValidate = false;
        ModuleFilter validationFilter = this.getModuleValidationFilter(nestedLocation);
        if (validationFilter != null) {
            noValidate |= this.wildcardHelper.isPathContainedByFilter(nestedLocation, validationFilter);
        }
        return noValidate;
    }

    @Override
    public String getOutputPath(URI nestedLocation) {
        String outputPath = null;
        Optional<? extends IN4JSSourceContainer> container = this.findN4JSSourceContainer(nestedLocation);
        if (container.isPresent()) {
            outputPath = ((IN4JSSourceContainer)container.get()).getProject().getOutputPath();
        }
        return outputPath;
    }

    @Override
    public ModuleFilter getModuleValidationFilter(URI nestedLocation) {
        ModuleFilter moduleFilter = null;
        Optional<? extends IN4JSSourceContainer> container = this.findN4JSSourceContainer(nestedLocation);
        if (container.isPresent()) {
            moduleFilter = ((IN4JSSourceContainer)container.get()).getProject().getModuleValidationFilter();
        }
        return moduleFilter;
    }

    @Override
    public TModule loadModuleFromIndex(ResourceSet resourceSet, IResourceDescription resourceDescription, boolean allowFullLoad) {
        URI resourceURI = resourceDescription.getURI();
        Resource resource = resourceSet.getResource(resourceURI, false);
        if (resource instanceof N4JSResource) {
            N4JSResource resourceCasted = (N4JSResource)resource;
            Script existingScript = resourceCasted.getScript();
            TModule existingModule = resourceCasted.getModule();
            if (existingModule != null) {
                return existingModule;
            }
            if (existingScript != null && !existingScript.eIsProxy()) {
                resourceCasted.installDerivedState(false);
                return resourceCasted.getModule();
            }
        }
        if (resource == null) {
            resource = resourceSet.createResource(resourceURI);
        }
        if (resource instanceof N4JSResource && resource.getContents().isEmpty()) {
            N4JSResource casted = (N4JSResource)resource;
            try {
                if (casted.loadFromDescription(resourceDescription)) {
                    casted.performPostProcessing();
                    return casted.getModule();
                }
                if (allowFullLoad) {
                    casted.unload();
                    casted.load(resourceSet.getLoadOptions());
                    casted.installDerivedState(false);
                    return casted.getModule();
                }
            }
            catch (Exception e) {
                casted.unload();
                return null;
            }
        }
        return null;
    }
}

