/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import java.util.List;
import org.eclipse.n4js.scoping.members.ComposedMemberFactory;
import org.eclipse.n4js.scoping.members.ComposedMemberInfo;
import org.eclipse.n4js.scoping.members.FieldFactory;
import org.eclipse.n4js.scoping.members.GetterFactory;
import org.eclipse.n4js.scoping.members.MemberFactory;
import org.eclipse.n4js.scoping.members.MethodFactory;
import org.eclipse.n4js.scoping.members.SetterFactory;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TMember;

public class UnionMemberFactory
extends ComposedMemberFactory {
    UnionMemberFactory(ComposedMemberInfo cma) {
        super(cma);
    }

    @Override
    protected MemberFactory getMemberFactory() {
        switch (this.memberType) {
            case METHOD: {
                return new MethodFactory.UnionMethodFactory(this.cmi);
            }
            case FIELD: {
                return new FieldFactory.UnionFieldFactory(this.cmi);
            }
            case GETTER: {
                return new GetterFactory.UnionGetterFactory(this.cmi);
            }
            case SETTER: {
                return new SetterFactory.UnionSetterFactory(this.cmi);
            }
        }
        return null;
    }

    @Override
    protected MemberType getNewMemberType() {
        if (this.cmi.hasMethodMemberType() && this.cmi.hasNonMethodMemberType()) {
            return null;
        }
        if (this.cmi.onlyMethodMemberTypes()) {
            return MemberType.METHOD;
        }
        if (this.cmi.onlyGetterMemberTypes()) {
            return MemberType.GETTER;
        }
        if (this.cmi.onlySetterMemberTypes()) {
            return MemberType.SETTER;
        }
        if (this.cmi.onlyFieldMemberTypes()) {
            if (this.allTypeRefAreEqual()) {
                return MemberType.FIELD;
            }
            if (this.cmi.isWriteAccess()) {
                return MemberType.SETTER;
            }
            return MemberType.GETTER;
        }
        if (!this.cmi.hasGetterMemberType()) {
            return MemberType.SETTER;
        }
        if (!this.cmi.hasSetterMemberType()) {
            return MemberType.GETTER;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.cmi.isEmpty();
    }

    @Override
    public boolean isValid() {
        if (this.cmi.isSiblingMissing()) {
            return false;
        }
        if (this.specialMemberFactory == null) {
            return false;
        }
        return this.specialMemberFactory.isValid();
    }

    @Override
    public List<TMember> getConstituentMembers() {
        return this.cmi.getConstituentMembers();
    }
}

