/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui;

import com.google.inject.Inject;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.n4js.ts.ui.navigation.URIBasedStorage;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.N4JSEditorErrorTickUpdater;
import org.eclipse.n4js.ui.external.EclipseExternalLibraryWorkspace;
import org.eclipse.n4js.ui.labeling.N4JSDescriptionLabelProvider;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextReadonlyEditorInput;

public class N4JSEditor
extends XtextEditor
implements IShowInSource,
IShowInTargetList {
    private static final Logger LOG = Logger.getLogger(N4JSEditor.class);
    private N4JSEditorErrorTickUpdater errorTickUpdater = null;
    private final AtomicInteger reconcilingCounter = new AtomicInteger();
    @Inject
    private IImageHelper imageHelper;
    @Inject
    private EclipseExternalLibraryWorkspace extWS;
    @Inject
    private N4JSDescriptionLabelProvider labelProvider;

    void setErrorTickUpdater(N4JSEditorErrorTickUpdater errorTickUpdater) {
        this.errorTickUpdater = errorTickUpdater;
    }

    public boolean isEditable() {
        FileEditorInput fei;
        IFile inputFile;
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput && (inputFile = (fei = (FileEditorInput)input).getFile()).toString().contains("node_modules")) {
            boolean editorShowsExternalFile;
            URI fileUri = URIUtils.toFileUri((IResource)inputFile);
            URI project = this.extWS.findProjectWith(fileUri);
            boolean bl = editorShowsExternalFile = project != null;
            if (editorShowsExternalFile) {
                return false;
            }
        }
        return super.isEditable();
    }

    public Image getDefaultImage() {
        Image defaultImage = this.getImageN4JSVariantOrGiven(super.getDefaultImage());
        return defaultImage;
    }

    protected Image getImageN4JSVariantOrGiven(Image titleImage) {
        Image image;
        IEditorInput input = this.getEditorInput();
        URI uri = null;
        if (input instanceof XtextReadonlyEditorInput) {
            XtextReadonlyEditorInput xrei = (XtextReadonlyEditorInput)input;
            try {
                IStorage storage = xrei.getStorage();
                if (storage instanceof URIBasedStorage) {
                    URIBasedStorage ubs = (URIBasedStorage)storage;
                    uri = ubs.getURI();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (input instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)input;
            uri = URIUtils.convert((IResource)fei.getFile());
        }
        if (uri != null && (image = this.labelProvider.getImageForURI(uri)) != null) {
            titleImage = image;
        }
        return titleImage;
    }

    public boolean isReconciling() {
        return this.reconcilingCounter.get() > 0;
    }

    public void setReconciling(boolean reconciling) {
        if (reconciling) {
            int oldCounter = this.reconcilingCounter.getAndIncrement();
            if (oldCounter == 0) {
                this.refreshTitleImage();
            }
        } else {
            int newCounter = this.reconcilingCounter.decrementAndGet();
            if (newCounter == 0) {
                this.refreshTitleImage();
            }
        }
    }

    protected void refreshTitleImage() {
        N4JSEditorErrorTickUpdater etu = this.errorTickUpdater;
        if (etu != null) {
            etu.updateEditorImage(this);
        }
    }

    public ImageDescriptor applyTitleImageOverlays(ImageDescriptor titleImageDesc) {
        if (this.isReconciling()) {
            Image image = this.imageHelper.getImage(titleImageDesc);
            titleImageDesc = new DecorationOverlayIcon(image, (ImageDescriptor)ImageDescriptorCache.ImageRef.TINY_CLOCK.asImageDescriptor().get(), 1);
        }
        return titleImageDesc;
    }

    public final ISourceViewer getSourceViewer2() {
        return this.getSourceViewer();
    }

    public void initializeViewerColors(ISourceViewer viewer) {
        super.initializeViewerColors(viewer);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        boolean tokenStyleChanged = event.getProperty().contains(".syntaxColorer.tokenStyles");
        if (tokenStyleChanged) {
            LOG.error((Object)"Unexpected event", (Throwable)new Exception());
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IContributionItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            IMenuManager subMenu;
            IContributionItem testShowIn;
            if (items[i] instanceof IMenuManager && (testShowIn = (subMenu = (IMenuManager)items[i]).find(ContributionItemFactory.VIEWS_SHOW_IN.getId())) != null) {
                menu.remove((IContributionItem)subMenu);
            }
            ++i;
        }
    }

    public ShowInContext getShowInContext() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)this.getEditorInput();
            return new ShowInContext((Object)fei.getFile(), null);
        }
        if (editorInput instanceof XtextReadonlyEditorInput) {
            XtextReadonlyEditorInput readOnlyEditorInput = (XtextReadonlyEditorInput)editorInput;
            try {
                IStorage storage = readOnlyEditorInput.getStorage();
                return new ShowInContext((Object)storage.getFullPath(), null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return new ShowInContext(null, null);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
    }
}

